/*
 * Decompiled with CFR 0.152.
 */
package org.immutables.fixture.deep;

import com.google.common.base.MoreObjects;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.util.ArrayList;
import java.util.Objects;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.fixture.deep.Canvas;
import org.immutables.fixture.deep.ImmutablePoint;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@Generated(from="Canvas.Point", generator="Modifiables")
@NotThreadSafe
public final class ModifiablePoint
implements Canvas.Point {
    private static final long INIT_BIT_X = 1L;
    private static final long INIT_BIT_Y = 2L;
    private long initBits = 3L;
    private int x;
    private int y;

    private ModifiablePoint() {
    }

    public static ModifiablePoint create(int x, int y) {
        return new ModifiablePoint().setX(x).setY(y);
    }

    public static ModifiablePoint create() {
        return new ModifiablePoint();
    }

    @Override
    public final int x() {
        if (!this.xIsSet()) {
            this.checkRequiredAttributes();
        }
        return this.x;
    }

    @Override
    public final int y() {
        if (!this.yIsSet()) {
            this.checkRequiredAttributes();
        }
        return this.y;
    }

    @CanIgnoreReturnValue
    public ModifiablePoint clear() {
        this.initBits = 3L;
        this.x = 0;
        this.y = 0;
        return this;
    }

    public ModifiablePoint from(Canvas.Point instance) {
        Objects.requireNonNull(instance, "instance");
        if (instance instanceof ModifiablePoint) {
            this.from((ModifiablePoint)instance);
            return this;
        }
        this.setX(instance.x());
        this.setY(instance.y());
        return this;
    }

    public ModifiablePoint from(ModifiablePoint instance) {
        Objects.requireNonNull(instance, "instance");
        if (instance.xIsSet()) {
            this.setX(instance.x());
        }
        if (instance.yIsSet()) {
            this.setY(instance.y());
        }
        return this;
    }

    @CanIgnoreReturnValue
    public ModifiablePoint setX(int x) {
        this.x = x;
        this.initBits &= 0xFFFFFFFFFFFFFFFEL;
        return this;
    }

    @CanIgnoreReturnValue
    public ModifiablePoint setY(int y) {
        this.y = y;
        this.initBits &= 0xFFFFFFFFFFFFFFFDL;
        return this;
    }

    public final boolean xIsSet() {
        return (this.initBits & 1L) == 0L;
    }

    public final boolean yIsSet() {
        return (this.initBits & 2L) == 0L;
    }

    @CanIgnoreReturnValue
    public final ModifiablePoint unsetX() {
        this.initBits |= 1L;
        this.x = 0;
        return this;
    }

    @CanIgnoreReturnValue
    public final ModifiablePoint unsetY() {
        this.initBits |= 2L;
        this.y = 0;
        return this;
    }

    public final boolean isInitialized() {
        return this.initBits == 0L;
    }

    private void checkRequiredAttributes() {
        if (!this.isInitialized()) {
            throw new IllegalStateException(this.formatRequiredAttributesMessage());
        }
    }

    private String formatRequiredAttributesMessage() {
        ArrayList<String> attributes = new ArrayList<String>();
        if (!this.xIsSet()) {
            attributes.add("x");
        }
        if (!this.yIsSet()) {
            attributes.add("y");
        }
        return "Point is not initialized, some of the required attributes are not set " + attributes;
    }

    public final ImmutablePoint toImmutable() {
        this.checkRequiredAttributes();
        return ImmutablePoint.copyOf(this);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        if (!(another instanceof ModifiablePoint)) {
            return false;
        }
        ModifiablePoint other = (ModifiablePoint)another;
        if (!this.isInitialized() || !other.isInitialized()) {
            return false;
        }
        return this.equalTo(other);
    }

    private boolean equalTo(ModifiablePoint another) {
        return this.x == another.x && this.y == another.y;
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.x;
        h += (h << 5) + this.y;
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"ModifiablePoint").add("x", this.xIsSet() ? Integer.valueOf(this.x()) : "?").add("y", this.yIsSet() ? Integer.valueOf(this.y()) : "?").toString();
    }
}

