/*
 * Decompiled with CFR 0.152.
 */
package org.immutables.fixture.encoding.defs;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;

final class OptionalList2<T> {
    private final List<T> list = null;

    OptionalList2() {
    }

    public boolean equals(OptionalList2<T> other) {
        return Objects.equals(this.list, other.list);
    }

    public Optional<List<T>> get() {
        return Optional.ofNullable(this.list);
    }

    public int hashCode() {
        return Objects.hashCode(this.list);
    }

    public String toString() {
        return Objects.toString(this.list);
    }

    static <T> List<T> initFromOptional(Optional<List<T>> optional) {
        Objects.requireNonNull(optional, "optional");
        return optional.map(elements -> OptionalList2.createSafeList(elements)).orElse(null);
    }

    private static <T> List<T> createSafeList(Iterable<T> iterable) {
        List list = StreamSupport.stream(iterable.spliterator(), false).map(element -> Objects.requireNonNull(element, "element")).collect(Collectors.toList());
        return Collections.unmodifiableList(list);
    }

    static final class Builder<T> {
        private List<T> list;

        Builder() {
        }

        void addAll(Iterable<T> iterable) {
            Objects.requireNonNull(iterable, "iterable");
            if (this.list == null) {
                this.list = new ArrayList<T>();
            }
            StreamSupport.stream(iterable.spliterator(), false).map(element -> Objects.requireNonNull(element, "element")).forEach(element -> this.list.add(element));
        }

        void addSingle(T element) {
            if (this.list == null) {
                this.list = new ArrayList<T>();
            }
            this.list.add(Objects.requireNonNull(element, "element"));
        }

        @SafeVarargs
        final void addVarargs(T ... elements) {
            if (this.list == null) {
                this.list = new ArrayList<T>();
            }
            Stream.of(elements).forEach(element -> this.list.add(Objects.requireNonNull(element, "element")));
        }

        List<T> build() {
            return this.list;
        }

        void setFromIterable(Iterable<T> iterable) {
            this.list = this.list == null ? null : StreamSupport.stream(iterable.spliterator(), false).map(element -> Objects.requireNonNull(element, "element")).collect(Collectors.toList());
        }

        void setFromOptional(Optional<List<T>> optional) {
            this.list = optional.orElse(null);
        }
    }
}

