/*
 * Decompiled with CFR 0.152.
 */
package org.immutables.fixture.jackson;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.MoreObjects;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.util.ArrayList;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.fixture.jackson.BlogEvent;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="BlogEvent.AbstractBodyChanged", generator="Immutables")
@Immutable
public final class BodyChanged
implements BlogEvent.AbstractBodyChanged {
    private final String body;

    private BodyChanged(String body) {
        this.body = Objects.requireNonNull(body, "body");
    }

    private BodyChanged(BodyChanged original, String body) {
        this.body = body;
    }

    @Override
    @JsonProperty(value="body")
    public String getBody() {
        return this.body;
    }

    public final BodyChanged withBody(String value) {
        String newValue = Objects.requireNonNull(value, "body");
        if (this.body.equals(newValue)) {
            return this;
        }
        return new BodyChanged(this, newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof BodyChanged && this.equalTo(0, (BodyChanged)another);
    }

    private boolean equalTo(int synthetic, BodyChanged another) {
        return this.body.equals(another.body);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.body.hashCode();
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"BodyChanged").omitNullValues().add("body", (Object)this.body).toString();
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static BodyChanged fromJson(Json json) {
        Builder builder = BodyChanged.builder();
        if (json.body != null) {
            builder.body(json.body);
        }
        return builder.build();
    }

    public static BodyChanged of(String body) {
        return new BodyChanged(body);
    }

    public static BodyChanged copyOf(BlogEvent.AbstractBodyChanged instance) {
        if (instance instanceof BodyChanged) {
            return (BodyChanged)instance;
        }
        return BodyChanged.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="BlogEvent.AbstractBodyChanged", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_BODY = 1L;
        private long initBits = 1L;
        @Nullable
        private String body;

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(BlogEvent.AbstractBodyChanged instance) {
            Objects.requireNonNull(instance, "instance");
            this.body(instance.getBody());
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder body(String body) {
            this.body = Objects.requireNonNull(body, "body");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public BodyChanged build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new BodyChanged(null, this.body);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("body");
            }
            return "Cannot build BodyChanged, some of required attributes are not set " + attributes;
        }
    }

    @Deprecated
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    @Generated(from="BlogEvent.AbstractBodyChanged", generator="Immutables")
    static final class Json
    implements BlogEvent.AbstractBodyChanged {
        @Nullable
        String body;

        Json() {
        }

        @JsonProperty(value="body")
        public void setBody(String body) {
            this.body = body;
        }

        @Override
        public String getBody() {
            throw new UnsupportedOperationException();
        }
    }
}

