/*
 * Decompiled with CFR 0.152.
 */
package org.immutables.fixture.jackson;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.JsonNode;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.fixture.jackson.AnyGetterInBuilder;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="AnyGetterInBuilder", generator="Immutables")
@Immutable
public final class ImmutableAnyGetterInBuilder
extends AnyGetterInBuilder {
    private final Map<String, JsonNode> any;

    private ImmutableAnyGetterInBuilder(Map<String, ? extends JsonNode> any) {
        this.any = ImmutableAnyGetterInBuilder.createUnmodifiableMap(true, false, any);
    }

    private ImmutableAnyGetterInBuilder(ImmutableAnyGetterInBuilder original, Map<String, JsonNode> any) {
        this.any = any;
    }

    @Override
    @JsonProperty(value="any")
    @JsonAnyGetter
    public Map<String, JsonNode> any() {
        return this.any;
    }

    public final ImmutableAnyGetterInBuilder withAny(Map<String, ? extends JsonNode> entries) {
        if (this.any == entries) {
            return this;
        }
        Map<String, JsonNode> newValue = ImmutableAnyGetterInBuilder.createUnmodifiableMap(true, false, entries);
        return new ImmutableAnyGetterInBuilder(this, newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableAnyGetterInBuilder && this.equalTo(0, (ImmutableAnyGetterInBuilder)another);
    }

    private boolean equalTo(int synthetic, ImmutableAnyGetterInBuilder another) {
        return this.any.equals(another.any);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.any.hashCode();
        return h;
    }

    public String toString() {
        return "AnyGetterInBuilder{any=" + this.any + "}";
    }

    public static ImmutableAnyGetterInBuilder of(Map<String, ? extends JsonNode> any) {
        return new ImmutableAnyGetterInBuilder(any);
    }

    public static ImmutableAnyGetterInBuilder copyOf(AnyGetterInBuilder instance) {
        if (instance instanceof ImmutableAnyGetterInBuilder) {
            return (ImmutableAnyGetterInBuilder)instance;
        }
        return new AnyGetterInBuilder.Builder().from(instance).build();
    }

    private static <K, V> Map<K, V> createUnmodifiableMap(boolean checkNulls, boolean skipNulls, Map<? extends K, ? extends V> map) {
        switch (map.size()) {
            case 0: {
                return Collections.emptyMap();
            }
            case 1: {
                Map.Entry<K, V> e = map.entrySet().iterator().next();
                K k = e.getKey();
                V v = e.getValue();
                if (checkNulls) {
                    Objects.requireNonNull(k, "key");
                    if (v == null) {
                        Objects.requireNonNull(v, "value for key: " + k);
                    }
                }
                if (skipNulls && (k == null || v == null)) {
                    return Collections.emptyMap();
                }
                return Collections.singletonMap(k, v);
            }
        }
        LinkedHashMap<K, V> linkedMap = new LinkedHashMap<K, V>(map.size());
        if (skipNulls || checkNulls) {
            for (Map.Entry<K, V> e : map.entrySet()) {
                K k = e.getKey();
                V v = e.getValue();
                if (skipNulls) {
                    if (k == null || v == null) {
                        continue;
                    }
                } else if (checkNulls) {
                    Objects.requireNonNull(k, "key");
                    if (v == null) {
                        Objects.requireNonNull(v, "value for key: " + k);
                    }
                }
                linkedMap.put(k, v);
            }
        } else {
            linkedMap.putAll(map);
        }
        return Collections.unmodifiableMap(linkedMap);
    }

    @Generated(from="AnyGetterInBuilder", generator="Immutables")
    @NotThreadSafe
    public static class Builder {
        private Map<String, JsonNode> any = new LinkedHashMap<String, JsonNode>();

        public Builder() {
            if (!(this instanceof AnyGetterInBuilder.Builder)) {
                throw new UnsupportedOperationException("Use: new AnyGetterInBuilder.Builder()");
            }
        }

        @CanIgnoreReturnValue
        public final AnyGetterInBuilder.Builder from(AnyGetterInBuilder instance) {
            Objects.requireNonNull(instance, "instance");
            this.putAllAny(instance.any());
            return (AnyGetterInBuilder.Builder)this;
        }

        @JsonAnySetter
        @CanIgnoreReturnValue
        public final AnyGetterInBuilder.Builder putAny(String key, JsonNode value) {
            this.any.put(Objects.requireNonNull(key, "any key"), value == null ? Objects.requireNonNull(value, "any value for key: " + key) : value);
            return (AnyGetterInBuilder.Builder)this;
        }

        @CanIgnoreReturnValue
        public final AnyGetterInBuilder.Builder putAny(Map.Entry<String, ? extends JsonNode> entry) {
            String k = entry.getKey();
            JsonNode v = entry.getValue();
            this.any.put(Objects.requireNonNull(k, "any key"), v == null ? Objects.requireNonNull(v, "any value for key: " + k) : v);
            return (AnyGetterInBuilder.Builder)this;
        }

        @JsonProperty(value="any")
        @CanIgnoreReturnValue
        public final AnyGetterInBuilder.Builder any(Map<String, ? extends JsonNode> entries) {
            this.any.clear();
            return this.putAllAny(entries);
        }

        @CanIgnoreReturnValue
        public final AnyGetterInBuilder.Builder putAllAny(Map<String, ? extends JsonNode> entries) {
            for (Map.Entry<String, ? extends JsonNode> e : entries.entrySet()) {
                String k = e.getKey();
                JsonNode v = e.getValue();
                this.any.put(Objects.requireNonNull(k, "any key"), v == null ? Objects.requireNonNull(v, "any value for key: " + k) : v);
            }
            return (AnyGetterInBuilder.Builder)this;
        }

        public ImmutableAnyGetterInBuilder build() {
            return new ImmutableAnyGetterInBuilder(null, ImmutableAnyGetterInBuilder.createUnmodifiableMap(false, false, this.any));
        }
    }
}

