/*
 * Decompiled with CFR 0.152.
 */
package org.immutables.fixture.jackson;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.MoreObjects;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.util.ArrayList;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.fixture.jackson.BlogEvent;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="BlogEvent.AbstractPostPublished", generator="Immutables")
@Immutable
public final class PostPublished
implements BlogEvent.AbstractPostPublished {
    private final String postId;

    private PostPublished(String postId) {
        this.postId = Objects.requireNonNull(postId, "postId");
    }

    private PostPublished(PostPublished original, String postId) {
        this.postId = postId;
    }

    @Override
    @JsonProperty(value="postId")
    public String getPostId() {
        return this.postId;
    }

    public final PostPublished withPostId(String value) {
        String newValue = Objects.requireNonNull(value, "postId");
        if (this.postId.equals(newValue)) {
            return this;
        }
        return new PostPublished(this, newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof PostPublished && this.equalTo(0, (PostPublished)another);
    }

    private boolean equalTo(int synthetic, PostPublished another) {
        return this.postId.equals(another.postId);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.postId.hashCode();
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"PostPublished").omitNullValues().add("postId", (Object)this.postId).toString();
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static PostPublished fromJson(Json json) {
        Builder builder = PostPublished.builder();
        if (json.postId != null) {
            builder.postId(json.postId);
        }
        return builder.build();
    }

    public static PostPublished of(String postId) {
        return new PostPublished(postId);
    }

    public static PostPublished copyOf(BlogEvent.AbstractPostPublished instance) {
        if (instance instanceof PostPublished) {
            return (PostPublished)instance;
        }
        return PostPublished.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="BlogEvent.AbstractPostPublished", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_POST_ID = 1L;
        private long initBits = 1L;
        @Nullable
        private String postId;

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(BlogEvent.AbstractPostPublished instance) {
            Objects.requireNonNull(instance, "instance");
            this.postId(instance.getPostId());
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder postId(String postId) {
            this.postId = Objects.requireNonNull(postId, "postId");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public PostPublished build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new PostPublished(null, this.postId);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("postId");
            }
            return "Cannot build PostPublished, some of required attributes are not set " + attributes;
        }
    }

    @Deprecated
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    @Generated(from="BlogEvent.AbstractPostPublished", generator="Immutables")
    static final class Json
    implements BlogEvent.AbstractPostPublished {
        @Nullable
        String postId;

        Json() {
        }

        @JsonProperty(value="postId")
        public void setPostId(String postId) {
            this.postId = postId;
        }

        @Override
        public String getPostId() {
            throw new UnsupportedOperationException();
        }
    }
}

