/*
 * Decompiled with CFR 0.152.
 */
package org.immutables.fixture.jdkonly;

import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.fixture.jdkonly.JdkCopyCons;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="JdkCopyCons", generator="Immutables")
@Immutable
public final class ImmutableJdkCopyCons
implements JdkCopyCons {
    private final List<String> strings;

    private ImmutableJdkCopyCons(Iterable<String> strings) {
        this.strings = ImmutableJdkCopyCons.createUnmodifiableList(false, ImmutableJdkCopyCons.createSafeList(strings, true, false));
    }

    private ImmutableJdkCopyCons(ImmutableJdkCopyCons original, List<String> strings) {
        this.strings = strings;
    }

    @Override
    public List<String> getStrings() {
        return this.strings;
    }

    public final ImmutableJdkCopyCons withStrings(String ... elements) {
        List<String> newValue = ImmutableJdkCopyCons.createUnmodifiableList(false, ImmutableJdkCopyCons.createSafeList(Arrays.asList(elements), true, false));
        return new ImmutableJdkCopyCons(this, newValue);
    }

    public final ImmutableJdkCopyCons withStrings(Iterable<String> elements) {
        if (this.strings == elements) {
            return this;
        }
        List<String> newValue = ImmutableJdkCopyCons.createUnmodifiableList(false, ImmutableJdkCopyCons.createSafeList(elements, true, false));
        return new ImmutableJdkCopyCons(this, newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableJdkCopyCons && this.equalTo(0, (ImmutableJdkCopyCons)another);
    }

    private boolean equalTo(int synthetic, ImmutableJdkCopyCons another) {
        return this.strings.equals(another.strings);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.strings.hashCode();
        return h;
    }

    public String toString() {
        return "JdkCopyCons{strings=" + this.strings + "}";
    }

    public static ImmutableJdkCopyCons of(List<String> strings) {
        return ImmutableJdkCopyCons.of(strings);
    }

    public static ImmutableJdkCopyCons of(Iterable<String> strings) {
        return new ImmutableJdkCopyCons(strings);
    }

    public static ImmutableJdkCopyCons copyOf(JdkCopyCons instance) {
        if (instance instanceof ImmutableJdkCopyCons) {
            return (ImmutableJdkCopyCons)instance;
        }
        return ImmutableJdkCopyCons.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
        ArrayList<T> list;
        if (iterable instanceof Collection) {
            int size = ((Collection)iterable).size();
            if (size == 0) {
                return Collections.emptyList();
            }
            list = new ArrayList();
        } else {
            list = new ArrayList<T>();
        }
        for (T element : iterable) {
            if (skipNulls && element == null) continue;
            if (checkNulls) {
                Objects.requireNonNull(element, "element");
            }
            list.add(element);
        }
        return list;
    }

    private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
        switch (list.size()) {
            case 0: {
                return Collections.emptyList();
            }
            case 1: {
                return Collections.singletonList(list.get(0));
            }
        }
        if (clone) {
            return Collections.unmodifiableList(new ArrayList<T>(list));
        }
        if (list instanceof ArrayList) {
            ((ArrayList)list).trimToSize();
        }
        return Collections.unmodifiableList(list);
    }

    @Generated(from="JdkCopyCons", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private List<String> strings = new ArrayList<String>();

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(JdkCopyCons instance) {
            Objects.requireNonNull(instance, "instance");
            this.addAllStrings(instance.getStrings());
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addStrings(String element) {
            this.strings.add(Objects.requireNonNull(element, "strings element"));
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addStrings(String ... elements) {
            for (String element : elements) {
                this.strings.add(Objects.requireNonNull(element, "strings element"));
            }
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder strings(Iterable<String> elements) {
            this.strings.clear();
            return this.addAllStrings(elements);
        }

        @CanIgnoreReturnValue
        public final Builder addAllStrings(Iterable<String> elements) {
            for (String element : elements) {
                this.strings.add(Objects.requireNonNull(element, "strings element"));
            }
            return this;
        }

        public ImmutableJdkCopyCons build() {
            return new ImmutableJdkCopyCons(null, ImmutableJdkCopyCons.createUnmodifiableList(true, this.strings));
        }
    }
}

