/*
 * Decompiled with CFR 0.152.
 */
package org.immutables.fixture.modifiable;

import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.fixture.modifiable.AllowNullsObject;
import org.immutables.fixture.modifiable.ModifiableAllowNullsObject;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="AllowNullsObject", generator="Immutables")
@Immutable
public final class ImmutableAllowNullsObject
implements AllowNullsObject {
    private final Map<String, String> map;
    private final List<String> list;

    private ImmutableAllowNullsObject(Map<String, String> map, List<String> list) {
        this.map = map;
        this.list = list;
    }

    @Override
    public Map<String, String> getMap() {
        return this.map;
    }

    @Override
    public List<String> getList() {
        return this.list;
    }

    public final ImmutableAllowNullsObject withMap(Map<String, ? extends String> entries) {
        if (this.map == entries) {
            return this;
        }
        Map<String, String> newValue = ImmutableAllowNullsObject.createUnmodifiableMap(false, false, entries);
        return new ImmutableAllowNullsObject(newValue, this.list);
    }

    public final ImmutableAllowNullsObject withList(String ... elements) {
        List<String> newValue = ImmutableAllowNullsObject.createUnmodifiableList(false, ImmutableAllowNullsObject.createSafeList(Arrays.asList(elements), false, false));
        return new ImmutableAllowNullsObject(this.map, newValue);
    }

    public final ImmutableAllowNullsObject withList(Iterable<String> elements) {
        if (this.list == elements) {
            return this;
        }
        List<String> newValue = ImmutableAllowNullsObject.createUnmodifiableList(false, ImmutableAllowNullsObject.createSafeList(elements, false, false));
        return new ImmutableAllowNullsObject(this.map, newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableAllowNullsObject && this.equalTo(0, (ImmutableAllowNullsObject)another);
    }

    private boolean equalTo(int synthetic, ImmutableAllowNullsObject another) {
        return this.map.equals(another.map) && this.list.equals(another.list);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.map.hashCode();
        h += (h << 5) + this.list.hashCode();
        return h;
    }

    public String toString() {
        return "AllowNullsObject{map=" + this.map + ", list=" + this.list + "}";
    }

    public static ImmutableAllowNullsObject copyOf(AllowNullsObject instance) {
        if (instance instanceof ImmutableAllowNullsObject) {
            return (ImmutableAllowNullsObject)instance;
        }
        return ImmutableAllowNullsObject.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
        ArrayList<T> list;
        if (iterable instanceof Collection) {
            int size = ((Collection)iterable).size();
            if (size == 0) {
                return Collections.emptyList();
            }
            list = new ArrayList();
        } else {
            list = new ArrayList<T>();
        }
        for (T element : iterable) {
            if (skipNulls && element == null) continue;
            if (checkNulls) {
                Objects.requireNonNull(element, "element");
            }
            list.add(element);
        }
        return list;
    }

    private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
        switch (list.size()) {
            case 0: {
                return Collections.emptyList();
            }
            case 1: {
                return Collections.singletonList(list.get(0));
            }
        }
        if (clone) {
            return Collections.unmodifiableList(new ArrayList<T>(list));
        }
        if (list instanceof ArrayList) {
            ((ArrayList)list).trimToSize();
        }
        return Collections.unmodifiableList(list);
    }

    private static <K, V> Map<K, V> createUnmodifiableMap(boolean checkNulls, boolean skipNulls, Map<? extends K, ? extends V> map) {
        switch (map.size()) {
            case 0: {
                return Collections.emptyMap();
            }
            case 1: {
                Map.Entry<K, V> e = map.entrySet().iterator().next();
                K k = e.getKey();
                V v = e.getValue();
                if (checkNulls) {
                    Objects.requireNonNull(k, "key");
                    if (v == null) {
                        Objects.requireNonNull(v, "value for key: " + k);
                    }
                }
                if (skipNulls && (k == null || v == null)) {
                    return Collections.emptyMap();
                }
                return Collections.singletonMap(k, v);
            }
        }
        LinkedHashMap<K, V> linkedMap = new LinkedHashMap<K, V>(map.size());
        if (skipNulls || checkNulls) {
            for (Map.Entry<K, V> e : map.entrySet()) {
                K k = e.getKey();
                V v = e.getValue();
                if (skipNulls) {
                    if (k == null || v == null) {
                        continue;
                    }
                } else if (checkNulls) {
                    Objects.requireNonNull(k, "key");
                    if (v == null) {
                        Objects.requireNonNull(v, "value for key: " + k);
                    }
                }
                linkedMap.put(k, v);
            }
        } else {
            linkedMap.putAll(map);
        }
        return Collections.unmodifiableMap(linkedMap);
    }

    @Generated(from="AllowNullsObject", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private Map<String, String> map = new LinkedHashMap<String, String>();
        private List<String> list = new ArrayList<String>();

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(ModifiableAllowNullsObject instance) {
            Objects.requireNonNull(instance, "instance");
            this.putAllMap(instance.getMap());
            this.addAllList(instance.getList());
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder from(AllowNullsObject instance) {
            Objects.requireNonNull(instance, "instance");
            if (instance instanceof ModifiableAllowNullsObject) {
                return this.from((ModifiableAllowNullsObject)instance);
            }
            this.putAllMap(instance.getMap());
            this.addAllList(instance.getList());
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder putMap(@Nullable String key, @Nullable String value) {
            this.map.put(key, value);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder putMap(Map.Entry<String, ? extends String> entry) {
            String k = entry.getKey();
            String v = entry.getValue();
            this.map.put(k, v);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder map(Map<String, ? extends String> entries) {
            this.map.clear();
            return this.putAllMap(entries);
        }

        @CanIgnoreReturnValue
        public final Builder putAllMap(Map<String, ? extends String> entries) {
            for (Map.Entry<String, ? extends String> e : entries.entrySet()) {
                String k = e.getKey();
                String v = e.getValue();
                this.map.put(k, v);
            }
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addList(@Nullable String element) {
            this.list.add(element);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addList(String ... elements) {
            for (String element : elements) {
                this.list.add(element);
            }
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder list(Iterable<String> elements) {
            this.list.clear();
            return this.addAllList(elements);
        }

        @CanIgnoreReturnValue
        public final Builder addAllList(Iterable<String> elements) {
            for (String element : elements) {
                this.list.add(element);
            }
            return this;
        }

        public ImmutableAllowNullsObject build() {
            return new ImmutableAllowNullsObject(ImmutableAllowNullsObject.createUnmodifiableMap(false, false, this.map), ImmutableAllowNullsObject.createUnmodifiableList(true, this.list));
        }
    }
}

