/*
 * Decompiled with CFR 0.152.
 */
package org.immutables.fixture.modifiable;

import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.fixture.modifiable.DefaultMap;
import org.immutables.fixture.modifiable.ModifiableDefaultMap;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="DefaultMap", generator="Immutables")
@Immutable
public final class ImmutableDefaultMap
implements DefaultMap {
    private final Map<String, String> map;

    private ImmutableDefaultMap(Builder builder) {
        this.map = builder.mapIsSet() ? ImmutableDefaultMap.createUnmodifiableMap(false, false, builder.map) : ImmutableDefaultMap.createUnmodifiableMap(true, false, DefaultMap.super.getMap());
    }

    private ImmutableDefaultMap(Map<String, String> map) {
        this.map = map;
    }

    @Override
    public Map<String, String> getMap() {
        return this.map;
    }

    public final ImmutableDefaultMap withMap(Map<String, ? extends String> entries) {
        if (this.map == entries) {
            return this;
        }
        Map<String, String> newValue = ImmutableDefaultMap.createUnmodifiableMap(true, false, entries);
        return new ImmutableDefaultMap(newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableDefaultMap && this.equalTo(0, (ImmutableDefaultMap)another);
    }

    private boolean equalTo(int synthetic, ImmutableDefaultMap another) {
        return this.map.equals(another.map);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.map.hashCode();
        return h;
    }

    public String toString() {
        return "DefaultMap{map=" + this.map + "}";
    }

    public static ImmutableDefaultMap copyOf(DefaultMap instance) {
        if (instance instanceof ImmutableDefaultMap) {
            return (ImmutableDefaultMap)instance;
        }
        return ImmutableDefaultMap.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    private static <K, V> Map<K, V> createUnmodifiableMap(boolean checkNulls, boolean skipNulls, Map<? extends K, ? extends V> map) {
        switch (map.size()) {
            case 0: {
                return Collections.emptyMap();
            }
            case 1: {
                Map.Entry<K, V> e = map.entrySet().iterator().next();
                K k = e.getKey();
                V v = e.getValue();
                if (checkNulls) {
                    Objects.requireNonNull(k, "key");
                    if (v == null) {
                        Objects.requireNonNull(v, "value for key: " + k);
                    }
                }
                if (skipNulls && (k == null || v == null)) {
                    return Collections.emptyMap();
                }
                return Collections.singletonMap(k, v);
            }
        }
        LinkedHashMap<K, V> linkedMap = new LinkedHashMap<K, V>(map.size());
        if (skipNulls || checkNulls) {
            for (Map.Entry<K, V> e : map.entrySet()) {
                K k = e.getKey();
                V v = e.getValue();
                if (skipNulls) {
                    if (k == null || v == null) {
                        continue;
                    }
                } else if (checkNulls) {
                    Objects.requireNonNull(k, "key");
                    if (v == null) {
                        Objects.requireNonNull(v, "value for key: " + k);
                    }
                }
                linkedMap.put(k, v);
            }
        } else {
            linkedMap.putAll(map);
        }
        return Collections.unmodifiableMap(linkedMap);
    }

    @Generated(from="DefaultMap", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long OPT_BIT_MAP = 1L;
        private long optBits;
        private Map<String, String> map = new LinkedHashMap<String, String>();

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(ModifiableDefaultMap instance) {
            Objects.requireNonNull(instance, "instance");
            this.putAllMap(instance.getMap());
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder from(DefaultMap instance) {
            Objects.requireNonNull(instance, "instance");
            if (instance instanceof ModifiableDefaultMap) {
                return this.from((ModifiableDefaultMap)instance);
            }
            this.putAllMap(instance.getMap());
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder putMap(String key, String value) {
            this.map.put(Objects.requireNonNull(key, "map key"), value == null ? Objects.requireNonNull(value, "map value for key: " + key) : value);
            this.optBits |= 1L;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder putMap(Map.Entry<String, ? extends String> entry) {
            String k = entry.getKey();
            String v = entry.getValue();
            this.map.put(Objects.requireNonNull(k, "map key"), v == null ? Objects.requireNonNull(v, "map value for key: " + k) : v);
            this.optBits |= 1L;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder map(Map<String, ? extends String> entries) {
            this.map.clear();
            this.optBits |= 1L;
            return this.putAllMap(entries);
        }

        @CanIgnoreReturnValue
        public final Builder putAllMap(Map<String, ? extends String> entries) {
            for (Map.Entry<String, ? extends String> e : entries.entrySet()) {
                String k = e.getKey();
                String v = e.getValue();
                this.map.put(Objects.requireNonNull(k, "map key"), v == null ? Objects.requireNonNull(v, "map value for key: " + k) : v);
            }
            this.optBits |= 1L;
            return this;
        }

        public ImmutableDefaultMap build() {
            return new ImmutableDefaultMap(this);
        }

        private boolean mapIsSet() {
            return (this.optBits & 1L) != 0L;
        }
    }
}

