/*
 * Decompiled with CFR 0.152.
 */
package org.immutables.fixture.modifiable;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Multimap;
import com.google.common.primitives.Ints;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.util.Map;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.fixture.modifiable.ModifiableMutableImmutableCollection;
import org.immutables.fixture.modifiable.MutableImmutableCollection;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="MutableImmutableCollection", generator="Immutables")
@Immutable
public final class ImmutableMutableImmutableCollection
extends MutableImmutableCollection {
    private final ImmutableList<String> a;
    private final ImmutableSet<String> b;
    private final ImmutableMultimap<String, Integer> c;
    private final ImmutableMap<Void, Void> d;

    private ImmutableMutableImmutableCollection(ImmutableList<String> a, ImmutableSet<String> b, ImmutableMultimap<String, Integer> c, ImmutableMap<Void, Void> d) {
        this.a = a;
        this.b = b;
        this.c = c;
        this.d = d;
    }

    @Override
    ImmutableList<String> a() {
        return this.a;
    }

    @Override
    ImmutableSet<String> b() {
        return this.b;
    }

    @Override
    ImmutableMultimap<String, Integer> c() {
        return this.c;
    }

    @Override
    ImmutableMap<Void, Void> d() {
        return this.d;
    }

    public final ImmutableMutableImmutableCollection withA(String ... elements) {
        ImmutableList newValue = ImmutableList.copyOf((Object[])elements);
        return new ImmutableMutableImmutableCollection((ImmutableList<String>)newValue, this.b, this.c, this.d);
    }

    public final ImmutableMutableImmutableCollection withA(Iterable<String> elements) {
        if (this.a == elements) {
            return this;
        }
        ImmutableList newValue = ImmutableList.copyOf(elements);
        return new ImmutableMutableImmutableCollection((ImmutableList<String>)newValue, this.b, this.c, this.d);
    }

    public final ImmutableMutableImmutableCollection withB(String ... elements) {
        ImmutableSet newValue = ImmutableSet.copyOf((Object[])elements);
        return new ImmutableMutableImmutableCollection(this.a, (ImmutableSet<String>)newValue, this.c, this.d);
    }

    public final ImmutableMutableImmutableCollection withB(Iterable<String> elements) {
        if (this.b == elements) {
            return this;
        }
        ImmutableSet newValue = ImmutableSet.copyOf(elements);
        return new ImmutableMutableImmutableCollection(this.a, (ImmutableSet<String>)newValue, this.c, this.d);
    }

    public final ImmutableMutableImmutableCollection withC(Multimap<String, ? extends Integer> entries) {
        if (this.c == entries) {
            return this;
        }
        ImmutableMultimap newValue = ImmutableMultimap.copyOf(entries);
        return new ImmutableMutableImmutableCollection(this.a, this.b, (ImmutableMultimap<String, Integer>)newValue, this.d);
    }

    public final ImmutableMutableImmutableCollection withD(Map<? extends Void, ? extends Void> entries) {
        if (this.d == entries) {
            return this;
        }
        ImmutableMap newValue = ImmutableMap.copyOf(entries);
        return new ImmutableMutableImmutableCollection(this.a, this.b, this.c, (ImmutableMap<Void, Void>)newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableMutableImmutableCollection && this.equalTo(0, (ImmutableMutableImmutableCollection)another);
    }

    private boolean equalTo(int synthetic, ImmutableMutableImmutableCollection another) {
        return this.a.equals(another.a) && this.b.equals(another.b) && this.c.equals(another.c) && this.d.equals(another.d);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.a.hashCode();
        h += (h << 5) + this.b.hashCode();
        h += (h << 5) + this.c.hashCode();
        h += (h << 5) + this.d.hashCode();
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"MutableImmutableCollection").omitNullValues().add("a", this.a).add("b", this.b).add("c", this.c).add("d", this.d).toString();
    }

    public static ImmutableMutableImmutableCollection copyOf(MutableImmutableCollection instance) {
        if (instance instanceof ImmutableMutableImmutableCollection) {
            return (ImmutableMutableImmutableCollection)instance;
        }
        return ImmutableMutableImmutableCollection.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="MutableImmutableCollection", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private ImmutableList.Builder<String> a = ImmutableList.builder();
        private ImmutableSet.Builder<String> b = ImmutableSet.builder();
        private ImmutableMultimap.Builder<String, Integer> c = ImmutableMultimap.builder();
        private ImmutableMap.Builder<Void, Void> d = ImmutableMap.builder();

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(ModifiableMutableImmutableCollection instance) {
            Objects.requireNonNull(instance, "instance");
            this.addAllA((Iterable<String>)instance.a());
            this.addAllB((Iterable<String>)instance.b());
            this.putAllC((Multimap<String, ? extends Integer>)instance.c());
            this.putAllD((Map<? extends Void, ? extends Void>)instance.d());
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder from(MutableImmutableCollection instance) {
            Objects.requireNonNull(instance, "instance");
            if (instance instanceof ModifiableMutableImmutableCollection) {
                return this.from((ModifiableMutableImmutableCollection)instance);
            }
            this.addAllA((Iterable<String>)instance.a());
            this.addAllB((Iterable<String>)instance.b());
            this.putAllC((Multimap<String, ? extends Integer>)instance.c());
            this.putAllD((Map<? extends Void, ? extends Void>)instance.d());
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addA(String element) {
            this.a.add((Object)element);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addA(String ... elements) {
            this.a.add((Object[])elements);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder a(Iterable<String> elements) {
            this.a = ImmutableList.builder();
            return this.addAllA(elements);
        }

        @CanIgnoreReturnValue
        public final Builder addAllA(Iterable<String> elements) {
            this.a.addAll(elements);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addB(String element) {
            this.b.add((Object)element);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addB(String ... elements) {
            this.b.add((Object[])elements);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder b(Iterable<String> elements) {
            this.b = ImmutableSet.builder();
            return this.addAllB(elements);
        }

        @CanIgnoreReturnValue
        public final Builder addAllB(Iterable<String> elements) {
            this.b.addAll(elements);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder putC(String key, int ... values) {
            this.c.putAll((Object)key, (Iterable)Ints.asList((int[])values));
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder putAllC(String key, Iterable<Integer> values) {
            this.c.putAll((Object)key, values);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder putC(String key, int value) {
            this.c.put((Object)key, (Object)value);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder putC(Map.Entry<String, ? extends Integer> entry) {
            this.c.put(entry);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder c(Multimap<String, ? extends Integer> entries) {
            this.c = ImmutableMultimap.builder();
            return this.putAllC(entries);
        }

        @CanIgnoreReturnValue
        public final Builder putAllC(Multimap<String, ? extends Integer> entries) {
            this.c.putAll(entries);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder putD(Void key, Void value) {
            this.d.put((Object)key, (Object)value);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder putD(Map.Entry<? extends Void, ? extends Void> entry) {
            this.d.put(entry);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder d(Map<? extends Void, ? extends Void> entries) {
            this.d = ImmutableMap.builder();
            return this.putAllD(entries);
        }

        @CanIgnoreReturnValue
        public final Builder putAllD(Map<? extends Void, ? extends Void> entries) {
            this.d.putAll(entries);
            return this;
        }

        public ImmutableMutableImmutableCollection build() {
            return new ImmutableMutableImmutableCollection(this.a.build(), this.b.build(), this.c.build(), this.d.build());
        }
    }
}

