/*
 * Decompiled with CFR 0.152.
 */
package org.immutables.fixture.nullable;

import com.google.gson.Gson;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonToken;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.annotation.ParametersAreNonnullByDefault;
import org.immutables.fixture.nullable.ImmutableNonnullConstruction;
import org.immutables.fixture.nullable.NonnullConstruction;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@Generated(from="org.immutables.fixture.nullable", generator="Gsons")
public final class GsonAdaptersNonnullConstruction
implements TypeAdapterFactory {
    public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
        if (NonnullConstructionTypeAdapter.adapts(type)) {
            return new NonnullConstructionTypeAdapter(gson);
        }
        return null;
    }

    public String toString() {
        return "GsonAdaptersNonnullConstruction(NonnullConstruction)";
    }

    @Generated(from="NonnullConstruction", generator="Gsons")
    private static class NonnullConstructionTypeAdapter
    extends TypeAdapter<NonnullConstruction> {
        NonnullConstructionTypeAdapter(Gson gson) {
        }

        static boolean adapts(TypeToken<?> type) {
            return NonnullConstruction.class == type.getRawType() || ImmutableNonnullConstruction.class == type.getRawType();
        }

        public void write(JsonWriter out, NonnullConstruction value) throws IOException {
            if (value == null) {
                out.nullValue();
            } else {
                this.writeNonnullConstruction(out, value);
            }
        }

        public NonnullConstruction read(JsonReader in) throws IOException {
            return this.readNonnullConstruction(in);
        }

        private void writeNonnullConstruction(JsonWriter out, NonnullConstruction instance) throws IOException {
            out.beginObject();
            String[] arrElements = instance.arr();
            out.name("arr");
            out.beginArray();
            for (String e : arrElements) {
                out.value(e);
            }
            out.endArray();
            String[] brrElements = instance.brr();
            if (brrElements != null) {
                out.name("brr");
                out.beginArray();
                for (String e : brrElements) {
                    out.value(e);
                }
                out.endArray();
            } else if (out.getSerializeNulls()) {
                out.name("brr");
                out.nullValue();
            }
            List<String> axElements = instance.ax();
            out.name("ax");
            out.beginArray();
            for (String e : axElements) {
                out.value(e);
            }
            out.endArray();
            out.name("a");
            out.value((long)instance.a());
            out.endObject();
        }

        private NonnullConstruction readNonnullConstruction(JsonReader in) throws IOException {
            if (in.peek() == JsonToken.NULL) {
                in.nextNull();
                return null;
            }
            ImmutableNonnullConstruction.Builder builder = ImmutableNonnullConstruction.builder();
            in.beginObject();
            while (in.hasNext()) {
                this.eachAttribute(in, builder);
            }
            in.endObject();
            return builder.build();
        }

        private void eachAttribute(JsonReader in, ImmutableNonnullConstruction.Builder builder) throws IOException {
            String attributeName = in.nextName();
            switch (attributeName.charAt(0)) {
                case 'a': {
                    if ("arr".equals(attributeName)) {
                        this.readInArr(in, builder);
                        return;
                    }
                    if (!"ax".equals(attributeName)) break;
                    this.readInAx(in, builder);
                    return;
                }
                case 'b': {
                    if (!"brr".equals(attributeName)) break;
                    this.readInBrr(in, builder);
                    return;
                }
            }
            in.skipValue();
        }

        private void readInArr(JsonReader in, ImmutableNonnullConstruction.Builder builder) throws IOException {
            ArrayList<String> elements = new ArrayList<String>();
            if (in.peek() == JsonToken.BEGIN_ARRAY) {
                in.beginArray();
                while (in.hasNext()) {
                    elements.add(in.nextString());
                }
                in.endArray();
            } else if (in.peek() == JsonToken.NULL) {
                in.nextNull();
            } else {
                elements.add(in.nextString());
            }
            builder.arr(elements.toArray(new String[elements.size()]));
        }

        private void readInBrr(JsonReader in, ImmutableNonnullConstruction.Builder builder) throws IOException {
            if (in.peek() == JsonToken.NULL) {
                in.nextNull();
            } else {
                ArrayList<String> elements = new ArrayList<String>();
                if (in.peek() == JsonToken.BEGIN_ARRAY) {
                    in.beginArray();
                    while (in.hasNext()) {
                        elements.add(in.nextString());
                    }
                    in.endArray();
                } else if (in.peek() == JsonToken.NULL) {
                    in.nextNull();
                } else {
                    elements.add(in.nextString());
                }
                builder.brr(elements.toArray(new String[elements.size()]));
            }
        }

        private void readInAx(JsonReader in, ImmutableNonnullConstruction.Builder builder) throws IOException {
            boolean empty = true;
            if (in.peek() == JsonToken.BEGIN_ARRAY) {
                in.beginArray();
                while (in.hasNext()) {
                    builder.addAx(in.nextString());
                    empty = false;
                }
                in.endArray();
            } else if (in.peek() == JsonToken.NULL) {
                in.nextNull();
            } else {
                builder.addAx(in.nextString());
                empty = false;
            }
            if (empty) {
                builder.addAllAx(Collections.emptyList());
            }
        }
    }
}

