/*
 * Decompiled with CFR 0.152.
 */
package org.immutables.fixture.style;

import com.google.common.base.MoreObjects;
import java.util.ArrayList;
import java.util.Objects;
import java.util.Optional;
import org.immutables.fixture.style.LightOnAnnotations;
import org.immutables.fixture.style.ModifiableLightOnAnnotations;

public final class ImmutableLightOnAnnotations<X>
implements LightOnAnnotations<X> {
    private final int a;
    private final X x;

    private ImmutableLightOnAnnotations(int a, X x) {
        this.a = a;
        this.x = x;
    }

    @Override
    public int a() {
        return this.a;
    }

    @Override
    public Optional<X> x() {
        return Optional.ofNullable(this.x);
    }

    public final ImmutableLightOnAnnotations<X> withA(int value) {
        if (this.a == value) {
            return this;
        }
        return new ImmutableLightOnAnnotations<X>(value, this.x);
    }

    public final ImmutableLightOnAnnotations<X> withX(X value) {
        X newValue = Objects.requireNonNull(value, "x");
        if (this.x == newValue) {
            return this;
        }
        return new ImmutableLightOnAnnotations<X>(this.a, newValue);
    }

    public final ImmutableLightOnAnnotations<X> withX(Optional<? extends X> optional) {
        X value = optional.orElse(null);
        if (this.x == value) {
            return this;
        }
        return new ImmutableLightOnAnnotations<Object>(this.a, value);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableLightOnAnnotations && this.equalTo(0, (ImmutableLightOnAnnotations)another);
    }

    private boolean equalTo(int synthetic, ImmutableLightOnAnnotations<?> another) {
        return this.a == another.a && Objects.equals(this.x, another.x);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.a;
        h += (h << 5) + Objects.hashCode(this.x);
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"LightOnAnnotations").omitNullValues().add("a", this.a).add("x", this.x).toString();
    }

    public static <X> ImmutableLightOnAnnotations<X> copyOf(LightOnAnnotations<X> instance) {
        if (instance instanceof ImmutableLightOnAnnotations) {
            return (ImmutableLightOnAnnotations)instance;
        }
        return ImmutableLightOnAnnotations.builder().from(instance).build();
    }

    public static <X> Builder<X> builder() {
        return new Builder();
    }

    public static final class Builder<X> {
        private static final long INIT_BIT_A = 1L;
        private long initBits = 1L;
        private int a;
        private X x;

        private Builder() {
        }

        public final Builder<X> from(ModifiableLightOnAnnotations<X> instance) {
            Optional<X> xOptional;
            Objects.requireNonNull(instance, "instance");
            if (instance.aIsSet()) {
                this.a(instance.a());
            }
            if ((xOptional = instance.x()).isPresent()) {
                this.x(xOptional);
            }
            return this;
        }

        public final Builder<X> from(LightOnAnnotations<X> instance) {
            Objects.requireNonNull(instance, "instance");
            if (instance instanceof ModifiableLightOnAnnotations) {
                return this.from((ModifiableLightOnAnnotations)instance);
            }
            this.a(instance.a());
            Optional<X> xOptional = instance.x();
            if (xOptional.isPresent()) {
                this.x(xOptional);
            }
            return this;
        }

        public final Builder<X> a(int a) {
            this.a = a;
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder<X> x(X x) {
            this.x = Objects.requireNonNull(x, "x");
            return this;
        }

        public final Builder<X> x(Optional<? extends X> x) {
            this.x = x.orElse(null);
            return this;
        }

        public ImmutableLightOnAnnotations<X> build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableLightOnAnnotations(this.a, this.x);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("a");
            }
            return "Cannot build LightOnAnnotations, some of required attributes are not set " + attributes;
        }
    }
}

