/*
 * Decompiled with CFR 0.152.
 */
package org.immutables.fixture.style;

import com.google.common.base.MoreObjects;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.util.Objects;
import java.util.Optional;
import java.util.OptionalInt;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.fixture.style.OptionalWithNullable;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="OptionalWithNullable", generator="Immutables")
@Immutable
public final class ImmutableOptionalWithNullable
implements OptionalWithNullable {
    @Nullable
    private final String javaOptional;
    @Nullable
    private final Integer javaOptionalInt;
    @Nullable
    private final Integer javaOptionalInteger;
    private final com.google.common.base.Optional<String> guavaOptional;
    @Nullable
    private final String javaOptionalStringParameter;

    private ImmutableOptionalWithNullable(Optional<String> javaOptionalStringParameter) {
        this.javaOptionalStringParameter = javaOptionalStringParameter.orElse(null);
        this.javaOptional = null;
        this.javaOptionalInt = null;
        this.javaOptionalInteger = null;
        this.guavaOptional = com.google.common.base.Optional.absent();
    }

    private ImmutableOptionalWithNullable(@Nullable String javaOptionalStringParameter) {
        this.javaOptionalStringParameter = javaOptionalStringParameter;
        this.javaOptional = null;
        this.javaOptionalInt = null;
        this.javaOptionalInteger = null;
        this.guavaOptional = com.google.common.base.Optional.absent();
    }

    private ImmutableOptionalWithNullable(@Nullable String javaOptional, @Nullable Integer javaOptionalInt, @Nullable Integer javaOptionalInteger, com.google.common.base.Optional<String> guavaOptional, @Nullable String javaOptionalStringParameter) {
        this.javaOptional = javaOptional;
        this.javaOptionalInt = javaOptionalInt;
        this.javaOptionalInteger = javaOptionalInteger;
        this.guavaOptional = guavaOptional;
        this.javaOptionalStringParameter = javaOptionalStringParameter;
    }

    @Override
    public Optional<String> getJavaOptional() {
        return Optional.ofNullable(this.javaOptional);
    }

    @Override
    public OptionalInt getJavaOptionalInt() {
        return this.javaOptionalInt != null ? OptionalInt.of(this.javaOptionalInt) : OptionalInt.empty();
    }

    @Override
    public Optional<Integer> getJavaOptionalInteger() {
        return Optional.ofNullable(this.javaOptionalInteger);
    }

    @Override
    public com.google.common.base.Optional<String> getGuavaOptional() {
        return this.guavaOptional;
    }

    @Override
    public Optional<String> getJavaOptionalStringParameter() {
        return Optional.ofNullable(this.javaOptionalStringParameter);
    }

    public final ImmutableOptionalWithNullable withJavaOptional(@Nullable String value) {
        String newValue = value;
        if (Objects.equals(this.javaOptional, newValue)) {
            return this;
        }
        return new ImmutableOptionalWithNullable(newValue, this.javaOptionalInt, this.javaOptionalInteger, this.guavaOptional, this.javaOptionalStringParameter);
    }

    public final ImmutableOptionalWithNullable withJavaOptional(Optional<String> optional) {
        String value = optional.orElse(null);
        if (Objects.equals(this.javaOptional, value)) {
            return this;
        }
        return new ImmutableOptionalWithNullable(value, this.javaOptionalInt, this.javaOptionalInteger, this.guavaOptional, this.javaOptionalStringParameter);
    }

    public final ImmutableOptionalWithNullable withJavaOptionalInt(int value) {
        Integer newValue = value;
        if (Objects.equals(this.javaOptionalInt, newValue)) {
            return this;
        }
        return new ImmutableOptionalWithNullable(this.javaOptional, newValue, this.javaOptionalInteger, this.guavaOptional, this.javaOptionalStringParameter);
    }

    public final ImmutableOptionalWithNullable withJavaOptionalInt(OptionalInt optional) {
        Integer value;
        Integer n = value = optional.isPresent() ? Integer.valueOf(optional.getAsInt()) : null;
        if (Objects.equals(this.javaOptionalInt, value)) {
            return this;
        }
        return new ImmutableOptionalWithNullable(this.javaOptional, value, this.javaOptionalInteger, this.guavaOptional, this.javaOptionalStringParameter);
    }

    public final ImmutableOptionalWithNullable withJavaOptionalInteger(@Nullable Integer value) {
        Integer newValue = value;
        if (Objects.equals(this.javaOptionalInteger, newValue)) {
            return this;
        }
        return new ImmutableOptionalWithNullable(this.javaOptional, this.javaOptionalInt, newValue, this.guavaOptional, this.javaOptionalStringParameter);
    }

    public final ImmutableOptionalWithNullable withJavaOptionalInteger(Optional<Integer> optional) {
        Integer value = optional.orElse(null);
        if (Objects.equals(this.javaOptionalInteger, value)) {
            return this;
        }
        return new ImmutableOptionalWithNullable(this.javaOptional, this.javaOptionalInt, value, this.guavaOptional, this.javaOptionalStringParameter);
    }

    public final ImmutableOptionalWithNullable withGuavaOptional(@Nullable String value) {
        com.google.common.base.Optional newValue = com.google.common.base.Optional.fromNullable((Object)value);
        if (this.guavaOptional.equals((Object)newValue)) {
            return this;
        }
        return new ImmutableOptionalWithNullable(this.javaOptional, this.javaOptionalInt, this.javaOptionalInteger, (com.google.common.base.Optional<String>)newValue, this.javaOptionalStringParameter);
    }

    public final ImmutableOptionalWithNullable withGuavaOptional(com.google.common.base.Optional<String> optional) {
        com.google.common.base.Optional<String> value = optional;
        if (this.guavaOptional.equals(value)) {
            return this;
        }
        return new ImmutableOptionalWithNullable(this.javaOptional, this.javaOptionalInt, this.javaOptionalInteger, value, this.javaOptionalStringParameter);
    }

    public final ImmutableOptionalWithNullable withJavaOptionalStringParameter(@Nullable String value) {
        String newValue = value;
        if (Objects.equals(this.javaOptionalStringParameter, newValue)) {
            return this;
        }
        return new ImmutableOptionalWithNullable(this.javaOptional, this.javaOptionalInt, this.javaOptionalInteger, this.guavaOptional, newValue);
    }

    public final ImmutableOptionalWithNullable withJavaOptionalStringParameter(Optional<String> optional) {
        String value = optional.orElse(null);
        if (Objects.equals(this.javaOptionalStringParameter, value)) {
            return this;
        }
        return new ImmutableOptionalWithNullable(this.javaOptional, this.javaOptionalInt, this.javaOptionalInteger, this.guavaOptional, value);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableOptionalWithNullable && this.equalTo(0, (ImmutableOptionalWithNullable)another);
    }

    private boolean equalTo(int synthetic, ImmutableOptionalWithNullable another) {
        return Objects.equals(this.javaOptional, another.javaOptional) && Objects.equals(this.javaOptionalInt, another.javaOptionalInt) && Objects.equals(this.javaOptionalInteger, another.javaOptionalInteger) && this.guavaOptional.equals(another.guavaOptional) && Objects.equals(this.javaOptionalStringParameter, another.javaOptionalStringParameter);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + Objects.hashCode(this.javaOptional);
        h += (h << 5) + Objects.hashCode(this.javaOptionalInt);
        h += (h << 5) + Objects.hashCode(this.javaOptionalInteger);
        h += (h << 5) + this.guavaOptional.hashCode();
        h += (h << 5) + Objects.hashCode(this.javaOptionalStringParameter);
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"OptionalWithNullable").omitNullValues().add("javaOptional", (Object)this.javaOptional).add("javaOptionalInt", (Object)this.javaOptionalInt).add("javaOptionalInteger", (Object)this.javaOptionalInteger).add("guavaOptional", this.guavaOptional.orNull()).add("javaOptionalStringParameter", (Object)this.javaOptionalStringParameter).toString();
    }

    public static ImmutableOptionalWithNullable of(Optional<String> javaOptionalStringParameter) {
        return new ImmutableOptionalWithNullable(javaOptionalStringParameter);
    }

    public static ImmutableOptionalWithNullable of(@Nullable String javaOptionalStringParameter) {
        return new ImmutableOptionalWithNullable(javaOptionalStringParameter);
    }

    public static ImmutableOptionalWithNullable copyOf(OptionalWithNullable instance) {
        if (instance instanceof ImmutableOptionalWithNullable) {
            return (ImmutableOptionalWithNullable)instance;
        }
        return ImmutableOptionalWithNullable.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="OptionalWithNullable", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        @Nullable
        private String javaOptional;
        @Nullable
        private Integer javaOptionalInt;
        @Nullable
        private Integer javaOptionalInteger;
        private com.google.common.base.Optional<String> guavaOptional = com.google.common.base.Optional.absent();
        @Nullable
        private String javaOptionalStringParameter;

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(OptionalWithNullable instance) {
            Optional<String> javaOptionalStringParameterOptional;
            com.google.common.base.Optional<String> guavaOptionalOptional;
            Optional<Integer> javaOptionalIntegerOptional;
            OptionalInt javaOptionalIntOptional;
            Objects.requireNonNull(instance, "instance");
            Optional<String> javaOptionalOptional = instance.getJavaOptional();
            if (javaOptionalOptional.isPresent()) {
                this.javaOptional(javaOptionalOptional);
            }
            if ((javaOptionalIntOptional = instance.getJavaOptionalInt()).isPresent()) {
                this.javaOptionalInt(javaOptionalIntOptional);
            }
            if ((javaOptionalIntegerOptional = instance.getJavaOptionalInteger()).isPresent()) {
                this.javaOptionalInteger(javaOptionalIntegerOptional);
            }
            if ((guavaOptionalOptional = instance.getGuavaOptional()).isPresent()) {
                this.guavaOptional(guavaOptionalOptional);
            }
            if ((javaOptionalStringParameterOptional = instance.getJavaOptionalStringParameter()).isPresent()) {
                this.javaOptionalStringParameter(javaOptionalStringParameterOptional);
            }
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder javaOptional(@Nullable String javaOptional) {
            this.javaOptional = javaOptional;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder javaOptional(Optional<String> javaOptional) {
            this.javaOptional = javaOptional.orElse(null);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder javaOptionalInt(int javaOptionalInt) {
            this.javaOptionalInt = javaOptionalInt;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder javaOptionalInt(OptionalInt javaOptionalInt) {
            this.javaOptionalInt = javaOptionalInt.isPresent() ? Integer.valueOf(javaOptionalInt.getAsInt()) : null;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder javaOptionalInteger(@Nullable Integer javaOptionalInteger) {
            this.javaOptionalInteger = javaOptionalInteger;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder javaOptionalInteger(Optional<Integer> javaOptionalInteger) {
            this.javaOptionalInteger = javaOptionalInteger.orElse(null);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder guavaOptional(@Nullable String guavaOptional) {
            this.guavaOptional = com.google.common.base.Optional.fromNullable((Object)guavaOptional);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder guavaOptional(com.google.common.base.Optional<String> guavaOptional) {
            this.guavaOptional = guavaOptional;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder javaOptionalStringParameter(@Nullable String javaOptionalStringParameter) {
            this.javaOptionalStringParameter = javaOptionalStringParameter;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder javaOptionalStringParameter(Optional<String> javaOptionalStringParameter) {
            this.javaOptionalStringParameter = javaOptionalStringParameter.orElse(null);
            return this;
        }

        public ImmutableOptionalWithNullable build() {
            return new ImmutableOptionalWithNullable(this.javaOptional, this.javaOptionalInt, this.javaOptionalInteger, this.guavaOptional, this.javaOptionalStringParameter);
        }
    }
}

