/*
 * Decompiled with CFR 0.152.
 */
package org.immutables.fixture.style;

import com.google.common.base.MoreObjects;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.util.Objects;
import java.util.Optional;
import java.util.OptionalInt;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.fixture.style.OptionalWithoutNullable;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="OptionalWithoutNullable", generator="Immutables")
@Immutable
public final class ImmutableOptionalWithoutNullable
implements OptionalWithoutNullable {
    @Nullable
    private final String javaOptional;
    @Nullable
    private final Integer javaOptionalInt;
    private final com.google.common.base.Optional<String> guavaOptional;
    @Nullable
    private final String javaOptionalStringParameter;

    private ImmutableOptionalWithoutNullable(Optional<String> javaOptionalStringParameter) {
        this.javaOptionalStringParameter = javaOptionalStringParameter.orElse(null);
        this.javaOptional = null;
        this.javaOptionalInt = null;
        this.guavaOptional = com.google.common.base.Optional.absent();
    }

    private ImmutableOptionalWithoutNullable(@Nullable String javaOptional, @Nullable Integer javaOptionalInt, com.google.common.base.Optional<String> guavaOptional, @Nullable String javaOptionalStringParameter) {
        this.javaOptional = javaOptional;
        this.javaOptionalInt = javaOptionalInt;
        this.guavaOptional = guavaOptional;
        this.javaOptionalStringParameter = javaOptionalStringParameter;
    }

    @Override
    public Optional<String> getJavaOptional() {
        return Optional.ofNullable(this.javaOptional);
    }

    @Override
    public OptionalInt getJavaOptionalInt() {
        return this.javaOptionalInt != null ? OptionalInt.of(this.javaOptionalInt) : OptionalInt.empty();
    }

    @Override
    public com.google.common.base.Optional<String> getGuavaOptional() {
        return this.guavaOptional;
    }

    @Override
    public Optional<String> getJavaOptionalStringParameter() {
        return Optional.ofNullable(this.javaOptionalStringParameter);
    }

    public final ImmutableOptionalWithoutNullable withJavaOptional(String value) {
        String newValue = Objects.requireNonNull(value, "javaOptional");
        if (Objects.equals(this.javaOptional, newValue)) {
            return this;
        }
        return new ImmutableOptionalWithoutNullable(newValue, this.javaOptionalInt, this.guavaOptional, this.javaOptionalStringParameter);
    }

    public final ImmutableOptionalWithoutNullable withJavaOptional(Optional<String> optional) {
        String value = optional.orElse(null);
        if (Objects.equals(this.javaOptional, value)) {
            return this;
        }
        return new ImmutableOptionalWithoutNullable(value, this.javaOptionalInt, this.guavaOptional, this.javaOptionalStringParameter);
    }

    public final ImmutableOptionalWithoutNullable withJavaOptionalInt(int value) {
        Integer newValue = value;
        if (Objects.equals(this.javaOptionalInt, newValue)) {
            return this;
        }
        return new ImmutableOptionalWithoutNullable(this.javaOptional, newValue, this.guavaOptional, this.javaOptionalStringParameter);
    }

    public final ImmutableOptionalWithoutNullable withJavaOptionalInt(OptionalInt optional) {
        Integer value;
        Integer n = value = optional.isPresent() ? Integer.valueOf(optional.getAsInt()) : null;
        if (Objects.equals(this.javaOptionalInt, value)) {
            return this;
        }
        return new ImmutableOptionalWithoutNullable(this.javaOptional, value, this.guavaOptional, this.javaOptionalStringParameter);
    }

    public final ImmutableOptionalWithoutNullable withGuavaOptional(String value) {
        com.google.common.base.Optional newValue = com.google.common.base.Optional.of((Object)value);
        if (this.guavaOptional.equals((Object)newValue)) {
            return this;
        }
        return new ImmutableOptionalWithoutNullable(this.javaOptional, this.javaOptionalInt, (com.google.common.base.Optional<String>)newValue, this.javaOptionalStringParameter);
    }

    public final ImmutableOptionalWithoutNullable withGuavaOptional(com.google.common.base.Optional<String> optional) {
        com.google.common.base.Optional<String> value = optional;
        if (this.guavaOptional.equals(value)) {
            return this;
        }
        return new ImmutableOptionalWithoutNullable(this.javaOptional, this.javaOptionalInt, value, this.javaOptionalStringParameter);
    }

    public final ImmutableOptionalWithoutNullable withJavaOptionalStringParameter(String value) {
        String newValue = Objects.requireNonNull(value, "javaOptionalStringParameter");
        if (Objects.equals(this.javaOptionalStringParameter, newValue)) {
            return this;
        }
        return new ImmutableOptionalWithoutNullable(this.javaOptional, this.javaOptionalInt, this.guavaOptional, newValue);
    }

    public final ImmutableOptionalWithoutNullable withJavaOptionalStringParameter(Optional<String> optional) {
        String value = optional.orElse(null);
        if (Objects.equals(this.javaOptionalStringParameter, value)) {
            return this;
        }
        return new ImmutableOptionalWithoutNullable(this.javaOptional, this.javaOptionalInt, this.guavaOptional, value);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableOptionalWithoutNullable && this.equalTo(0, (ImmutableOptionalWithoutNullable)another);
    }

    private boolean equalTo(int synthetic, ImmutableOptionalWithoutNullable another) {
        return Objects.equals(this.javaOptional, another.javaOptional) && Objects.equals(this.javaOptionalInt, another.javaOptionalInt) && this.guavaOptional.equals(another.guavaOptional) && Objects.equals(this.javaOptionalStringParameter, another.javaOptionalStringParameter);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + Objects.hashCode(this.javaOptional);
        h += (h << 5) + Objects.hashCode(this.javaOptionalInt);
        h += (h << 5) + this.guavaOptional.hashCode();
        h += (h << 5) + Objects.hashCode(this.javaOptionalStringParameter);
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"OptionalWithoutNullable").omitNullValues().add("javaOptional", (Object)this.javaOptional).add("javaOptionalInt", (Object)this.javaOptionalInt).add("guavaOptional", this.guavaOptional.orNull()).add("javaOptionalStringParameter", (Object)this.javaOptionalStringParameter).toString();
    }

    public static ImmutableOptionalWithoutNullable of(Optional<String> javaOptionalStringParameter) {
        return new ImmutableOptionalWithoutNullable(javaOptionalStringParameter);
    }

    public static ImmutableOptionalWithoutNullable copyOf(OptionalWithoutNullable instance) {
        if (instance instanceof ImmutableOptionalWithoutNullable) {
            return (ImmutableOptionalWithoutNullable)instance;
        }
        return ImmutableOptionalWithoutNullable.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="OptionalWithoutNullable", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        @Nullable
        private String javaOptional;
        @Nullable
        private Integer javaOptionalInt;
        private com.google.common.base.Optional<String> guavaOptional = com.google.common.base.Optional.absent();
        @Nullable
        private String javaOptionalStringParameter;

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(OptionalWithoutNullable instance) {
            Optional<String> javaOptionalStringParameterOptional;
            com.google.common.base.Optional<String> guavaOptionalOptional;
            OptionalInt javaOptionalIntOptional;
            Objects.requireNonNull(instance, "instance");
            Optional<String> javaOptionalOptional = instance.getJavaOptional();
            if (javaOptionalOptional.isPresent()) {
                this.javaOptional(javaOptionalOptional);
            }
            if ((javaOptionalIntOptional = instance.getJavaOptionalInt()).isPresent()) {
                this.javaOptionalInt(javaOptionalIntOptional);
            }
            if ((guavaOptionalOptional = instance.getGuavaOptional()).isPresent()) {
                this.guavaOptional(guavaOptionalOptional);
            }
            if ((javaOptionalStringParameterOptional = instance.getJavaOptionalStringParameter()).isPresent()) {
                this.javaOptionalStringParameter(javaOptionalStringParameterOptional);
            }
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder javaOptional(String javaOptional) {
            this.javaOptional = Objects.requireNonNull(javaOptional, "javaOptional");
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder javaOptional(Optional<String> javaOptional) {
            this.javaOptional = javaOptional.orElse(null);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder javaOptionalInt(int javaOptionalInt) {
            this.javaOptionalInt = javaOptionalInt;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder javaOptionalInt(OptionalInt javaOptionalInt) {
            this.javaOptionalInt = javaOptionalInt.isPresent() ? Integer.valueOf(javaOptionalInt.getAsInt()) : null;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder guavaOptional(String guavaOptional) {
            this.guavaOptional = com.google.common.base.Optional.of((Object)guavaOptional);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder guavaOptional(com.google.common.base.Optional<String> guavaOptional) {
            this.guavaOptional = guavaOptional;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder javaOptionalStringParameter(String javaOptionalStringParameter) {
            this.javaOptionalStringParameter = Objects.requireNonNull(javaOptionalStringParameter, "javaOptionalStringParameter");
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder javaOptionalStringParameter(Optional<String> javaOptionalStringParameter) {
            this.javaOptionalStringParameter = javaOptionalStringParameter.orElse(null);
            return this;
        }

        public ImmutableOptionalWithoutNullable build() {
            return new ImmutableOptionalWithoutNullable(this.javaOptional, this.javaOptionalInt, this.guavaOptional, this.javaOptionalStringParameter);
        }
    }
}

