

import com.google.common.base.MoreObjects;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.errorprone.annotations.Var;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link InDefaultPackage}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableInDefaultPackage.builder()}.
 */
@Generated(from = "InDefaultPackage", generator = "Immutables")
@SuppressWarnings({"all"})
@ParametersAreNonnullByDefault
@javax.annotation.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
@CheckReturnValue
final class ImmutableInDefaultPackage implements InDefaultPackage {
  private final int attr;

  private ImmutableInDefaultPackage(int attr) {
    this.attr = attr;
  }

  /**
   * @return The value of the {@code attr} attribute
   */
  @Override
  public int attr() {
    return attr;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link InDefaultPackage#attr() attr} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for attr
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableInDefaultPackage withAttr(int value) {
    if (this.attr == value) return this;
    return new ImmutableInDefaultPackage(value);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableInDefaultPackage} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableInDefaultPackage
        && equalTo(0, (ImmutableInDefaultPackage) another);
  }

  private boolean equalTo(int synthetic, ImmutableInDefaultPackage another) {
    return attr == another.attr;
  }

  /**
   * Computes a hash code from attributes: {@code attr}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    @Var int h = 5381;
    h += (h << 5) + attr;
    return h;
  }

  /**
   * Prints the immutable value {@code InDefaultPackage} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return MoreObjects.toStringHelper("InDefaultPackage")
        .omitNullValues()
        .add("attr", attr)
        .toString();
  }

  /**
   * Creates an immutable copy of a {@link InDefaultPackage} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable InDefaultPackage instance
   */
  public static ImmutableInDefaultPackage copyOf(InDefaultPackage instance) {
    if (instance instanceof ImmutableInDefaultPackage) {
      return (ImmutableInDefaultPackage) instance;
    }
    return ImmutableInDefaultPackage.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableInDefaultPackage ImmutableInDefaultPackage}.
   * <pre>
   * ImmutableInDefaultPackage.builder()
   *    .attr(int) // required {@link InDefaultPackage#attr() attr}
   *    .build();
   * </pre>
   * @return A new ImmutableInDefaultPackage builder
   */
  public static ImmutableInDefaultPackage.Builder builder() {
    return new ImmutableInDefaultPackage.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableInDefaultPackage ImmutableInDefaultPackage}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "InDefaultPackage", generator = "Immutables")
  @NotThreadSafe
  public static final class Builder {
    private static final long INIT_BIT_ATTR = 0x1L;
    private long initBits = 0x1L;

    private int attr;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code InDefaultPackage} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder from(InDefaultPackage instance) {
      Objects.requireNonNull(instance, "instance");
      attr(instance.attr());
      return this;
    }

    /**
     * Initializes the value for the {@link InDefaultPackage#attr() attr} attribute.
     * @param attr The value for attr 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder attr(int attr) {
      this.attr = attr;
      initBits &= ~INIT_BIT_ATTR;
      return this;
    }

    /**
     * Builds a new {@link ImmutableInDefaultPackage ImmutableInDefaultPackage}.
     * @return An immutable instance of InDefaultPackage
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableInDefaultPackage build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new ImmutableInDefaultPackage(attr);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_ATTR) != 0) attributes.add("attr");
      return "Cannot build InDefaultPackage, some of required attributes are not set " + attributes;
    }
  }
}
