package nonimmutables;

import com.google.common.base.MoreObjects;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.errorprone.annotations.Var;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import nonimmutables._underscore.Parent;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link Child}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableChild.builder()}.
 */
@Generated(from = "Child", generator = "Immutables")
@SuppressWarnings({"all"})
@ParametersAreNonnullByDefault
@javax.annotation.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
@CheckReturnValue
public final class ImmutableChild implements Child {
  private final int a;
  private final int b;

  private ImmutableChild(int a, int b) {
    this.a = a;
    this.b = b;
  }

  /**
   * @return The value of the {@code a} attribute
   */
  @Override
  public int a() {
    return a;
  }

  /**
   * @return The value of the {@code b} attribute
   */
  @Override
  public int b() {
    return b;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link Child#a() a} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for a
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableChild withA(int value) {
    if (this.a == value) return this;
    return new ImmutableChild(value, this.b);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link Child#b() b} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for b
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableChild withB(int value) {
    if (this.b == value) return this;
    return new ImmutableChild(this.a, value);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableChild} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableChild
        && equalTo(0, (ImmutableChild) another);
  }

  private boolean equalTo(int synthetic, ImmutableChild another) {
    return a == another.a
        && b == another.b;
  }

  /**
   * Computes a hash code from attributes: {@code a}, {@code b}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    @Var int h = 5381;
    h += (h << 5) + a;
    h += (h << 5) + b;
    return h;
  }

  /**
   * Prints the immutable value {@code Child} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return MoreObjects.toStringHelper("Child")
        .omitNullValues()
        .add("a", a)
        .add("b", b)
        .toString();
  }

  /**
   * Creates an immutable copy of a {@link Child} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable Child instance
   */
  public static ImmutableChild copyOf(Child instance) {
    if (instance instanceof ImmutableChild) {
      return (ImmutableChild) instance;
    }
    return ImmutableChild.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableChild ImmutableChild}.
   * <pre>
   * ImmutableChild.builder()
   *    .a(int) // required {@link Child#a() a}
   *    .b(int) // required {@link Child#b() b}
   *    .build();
   * </pre>
   * @return A new ImmutableChild builder
   */
  public static ImmutableChild.Builder builder() {
    return new ImmutableChild.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableChild ImmutableChild}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "Child", generator = "Immutables")
  @NotThreadSafe
  public static final class Builder {
    private static final long INIT_BIT_A = 0x1L;
    private static final long INIT_BIT_B = 0x2L;
    private long initBits = 0x3L;

    private int a;
    private int b;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code nonimmutables._underscore.Parent} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder from(Parent instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    /**
     * Fill a builder with attribute values from the provided {@code nonimmutables.Child} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder from(Child instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    private void from(Object object) {
      @Var long bits = 0;
      if (object instanceof Parent) {
        Parent instance = (Parent) object;
        if ((bits & 0x1L) == 0) {
          a(instance.a());
          bits |= 0x1L;
        }
      }
      if (object instanceof Child) {
        Child instance = (Child) object;
        if ((bits & 0x1L) == 0) {
          a(instance.a());
          bits |= 0x1L;
        }
        b(instance.b());
      }
    }

    /**
     * Initializes the value for the {@link Child#a() a} attribute.
     * @param a The value for a 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder a(int a) {
      this.a = a;
      initBits &= ~INIT_BIT_A;
      return this;
    }

    /**
     * Initializes the value for the {@link Child#b() b} attribute.
     * @param b The value for b 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder b(int b) {
      this.b = b;
      initBits &= ~INIT_BIT_B;
      return this;
    }

    /**
     * Builds a new {@link ImmutableChild ImmutableChild}.
     * @return An immutable instance of Child
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableChild build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new ImmutableChild(a, b);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_A) != 0) attributes.add("a");
      if ((initBits & INIT_BIT_B) != 0) attributes.add("b");
      return "Cannot build Child, some of required attributes are not set " + attributes;
    }
  }
}
