package nonimmutables;

import com.google.common.base.MoreObjects;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.errorprone.annotations.Var;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link PassAnnsTargeting}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutablePassAnnsTargeting.builder()}.
 */
@Generated(from = "PassAnnsTargeting", generator = "Immutables")
@SuppressWarnings({"all"})
@ParametersAreNonnullByDefault
@javax.annotation.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
@CheckReturnValue
@A1
@A2
public final class ImmutablePassAnnsTargeting implements PassAnnsTargeting {
  private final int a;
  private final int b;
  private final String c;

  private ImmutablePassAnnsTargeting(ImmutablePassAnnsTargeting.Builder builder) {
    this.a = builder.a;
    if (builder.bIsSet()) {
      initShim.b(builder.b);
    }
    if (builder.c != null) {
      initShim.c(builder.c);
    }
    this.b = initShim.b();
    this.c = initShim.c();
    this.initShim = null;
  }

  private ImmutablePassAnnsTargeting(int a, int b, String c) {
    this.a = a;
    this.b = b;
    this.c = c;
    this.initShim = null;
  }

  private static final byte STAGE_INITIALIZING = -1;
  private static final byte STAGE_UNINITIALIZED = 0;
  private static final byte STAGE_INITIALIZED = 1;
  @SuppressWarnings("Immutable")
  private transient volatile InitShim initShim = new InitShim();

  @Generated(from = "PassAnnsTargeting", generator = "Immutables")
  private final class InitShim {
    private byte bBuildStage = STAGE_UNINITIALIZED;
    private int b;

    int b() {
      if (bBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (bBuildStage == STAGE_UNINITIALIZED) {
        bBuildStage = STAGE_INITIALIZING;
        this.b = bInitialize();
        bBuildStage = STAGE_INITIALIZED;
      }
      return this.b;
    }

    void b(int b) {
      this.b = b;
      bBuildStage = STAGE_INITIALIZED;
    }

    private byte cBuildStage = STAGE_UNINITIALIZED;
    private String c;

    String c() {
      if (cBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (cBuildStage == STAGE_UNINITIALIZED) {
        cBuildStage = STAGE_INITIALIZING;
        this.c = Objects.requireNonNull(cInitialize(), "c");
        cBuildStage = STAGE_INITIALIZED;
      }
      return this.c;
    }

    void c(String c) {
      this.c = c;
      cBuildStage = STAGE_INITIALIZED;
    }

    private String formatInitCycleMessage() {
      List<String> attributes = new ArrayList<>();
      if (bBuildStage == STAGE_INITIALIZING) attributes.add("b");
      if (cBuildStage == STAGE_INITIALIZING) attributes.add("c");
      return "Cannot build PassAnnsTargeting, attribute initializers form cycle " + attributes;
    }
  }

  private int bInitialize() {
    return PassAnnsTargeting.super.b();
  }

  private String cInitialize() {
    return PassAnnsTargeting.super.c();
  }

  /**
   * @return The value of the {@code a} attribute
   */
  @A1
  @Override
  public int a() {
    return a;
  }

  /**
   * @return The value of the {@code b} attribute
   */
  @A2
  @Override
  public int b() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.b()
        : this.b;
  }

  /**
   * @return The value of the {@code c} attribute
   */
  @A1
  @Override
  public String c() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.c()
        : this.c;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link PassAnnsTargeting#a() a} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for a
   * @return A modified copy of the {@code this} object
   */
  public final ImmutablePassAnnsTargeting withA(int value) {
    if (this.a == value) return this;
    return new ImmutablePassAnnsTargeting(value, this.b, this.c);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link PassAnnsTargeting#b() b} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for b
   * @return A modified copy of the {@code this} object
   */
  public final ImmutablePassAnnsTargeting withB(int value) {
    if (this.b == value) return this;
    return new ImmutablePassAnnsTargeting(this.a, value, this.c);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link PassAnnsTargeting#c() c} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for c
   * @return A modified copy of the {@code this} object
   */
  public final ImmutablePassAnnsTargeting withC(String value) {
    String newValue = Objects.requireNonNull(value, "c");
    if (this.c.equals(newValue)) return this;
    return new ImmutablePassAnnsTargeting(this.a, this.b, newValue);
  }

  /**
   * This instance is equal to all instances of {@code ImmutablePassAnnsTargeting} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutablePassAnnsTargeting
        && equalTo(0, (ImmutablePassAnnsTargeting) another);
  }

  private boolean equalTo(int synthetic, ImmutablePassAnnsTargeting another) {
    return a == another.a
        && b == another.b
        && c.equals(another.c);
  }

  /**
   * Computes a hash code from attributes: {@code a}, {@code b}, {@code c}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    @Var int h = 5381;
    h += (h << 5) + a;
    h += (h << 5) + b;
    h += (h << 5) + c.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code PassAnnsTargeting} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return MoreObjects.toStringHelper("PassAnnsTargeting")
        .omitNullValues()
        .add("a", a)
        .add("b", b)
        .add("c", c)
        .toString();
  }

  /**
   * Creates an immutable copy of a {@link PassAnnsTargeting} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable PassAnnsTargeting instance
   */
  public static ImmutablePassAnnsTargeting copyOf(PassAnnsTargeting instance) {
    if (instance instanceof ImmutablePassAnnsTargeting) {
      return (ImmutablePassAnnsTargeting) instance;
    }
    return ImmutablePassAnnsTargeting.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutablePassAnnsTargeting ImmutablePassAnnsTargeting}.
   * <pre>
   * ImmutablePassAnnsTargeting.builder()
   *    .a(int) // required {@link PassAnnsTargeting#a() a}
   *    .b(int) // optional {@link PassAnnsTargeting#b() b}
   *    .c(String) // optional {@link PassAnnsTargeting#c() c}
   *    .build();
   * </pre>
   * @return A new ImmutablePassAnnsTargeting builder
   */
  public static ImmutablePassAnnsTargeting.Builder builder() {
    return new ImmutablePassAnnsTargeting.Builder();
  }

  /**
   * Builds instances of type {@link ImmutablePassAnnsTargeting ImmutablePassAnnsTargeting}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "PassAnnsTargeting", generator = "Immutables")
  @NotThreadSafe
  public static final class Builder {
    private static final long INIT_BIT_A = 0x1L;
    private static final long OPT_BIT_B = 0x1L;
    private long initBits = 0x1L;
    private long optBits;

    private int a;
    private int b;
    private @Nullable String c;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code PassAnnsTargeting} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder from(PassAnnsTargeting instance) {
      Objects.requireNonNull(instance, "instance");
      a(instance.a());
      b(instance.b());
      c(instance.c());
      return this;
    }

    /**
     * Initializes the value for the {@link PassAnnsTargeting#a() a} attribute.
     * @param a The value for a 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder a(int a) {
      this.a = a;
      initBits &= ~INIT_BIT_A;
      return this;
    }

    /**
     * Initializes the value for the {@link PassAnnsTargeting#b() b} attribute.
     * <p><em>If not set, this attribute will have a default value as returned by the initializer of {@link PassAnnsTargeting#b() b}.</em>
     * @param b The value for b 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder b(int b) {
      this.b = b;
      optBits |= OPT_BIT_B;
      return this;
    }

    /**
     * Initializes the value for the {@link PassAnnsTargeting#c() c} attribute.
     * <p><em>If not set, this attribute will have a default value as returned by the initializer of {@link PassAnnsTargeting#c() c}.</em>
     * @param c The value for c 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder c(String c) {
      this.c = Objects.requireNonNull(c, "c");
      return this;
    }

    /**
     * Builds a new {@link ImmutablePassAnnsTargeting ImmutablePassAnnsTargeting}.
     * @return An immutable instance of PassAnnsTargeting
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutablePassAnnsTargeting build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new ImmutablePassAnnsTargeting(this);
    }

    private boolean bIsSet() {
      return (optBits & OPT_BIT_B) != 0;
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_A) != 0) attributes.add("a");
      return "Cannot build PassAnnsTargeting, some of required attributes are not set " + attributes;
    }
  }
}
