package nonimmutables.alpha;

import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link Delta}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableDelta.builder()}.
 */
@Generated(from = "Delta", generator = "Immutables")
@SuppressWarnings({"all"})
@ParametersAreNonnullByDefault
@javax.annotation.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
@CheckReturnValue
public final class ImmutableDelta implements Delta {

  private ImmutableDelta(ImmutableDelta.Builder builder) {
  }

  /**
   * This instance is equal to all instances of {@code ImmutableDelta} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableDelta
        && equalTo(0, (ImmutableDelta) another);
  }

  @SuppressWarnings("MethodCanBeStatic")
  private boolean equalTo(int synthetic, ImmutableDelta another) {
    return true;
  }

  /**
   * Returns a constant hash code value.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    return -1940006153;
  }

  /**
   * Prints the immutable value {@code Delta}.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "Delta{}";
  }

  /**
   * Creates an immutable copy of a {@link Delta} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable Delta instance
   */
  public static ImmutableDelta copyOf(Delta instance) {
    if (instance instanceof ImmutableDelta) {
      return (ImmutableDelta) instance;
    }
    return ImmutableDelta.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableDelta ImmutableDelta}.
   * <pre>
   * ImmutableDelta.builder()
   *    .build();
   * </pre>
   * @return A new ImmutableDelta builder
   */
  public static ImmutableDelta.Builder builder() {
    return new ImmutableDelta.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableDelta ImmutableDelta}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "Delta", generator = "Immutables")
  @NotThreadSafe
  public static final class Builder {

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code Delta} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder from(Delta instance) {
      Objects.requireNonNull(instance, "instance");
      return this;
    }

    /**
     * Builds a new {@link ImmutableDelta ImmutableDelta}.
     * @return An immutable instance of Delta
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableDelta build() {
      return new ImmutableDelta(this);
    }
  }
}
