package nonimmutables.recurs;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.MoreObjects;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.errorprone.annotations.Var;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link AbstractSomething}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code Something.builder()}.
 */
@Generated(from = "AbstractSomething", generator = "Immutables")
@SuppressWarnings({"all"})
@ParametersAreNonnullByDefault
@javax.annotation.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
@CheckReturnValue
public final class Something implements AbstractSomething {
  private final int id;
  private final MySomethingContent content;

  private Something(int id, MySomethingContent content) {
    this.id = id;
    this.content = content;
  }

  /**
   * @return The value of the {@code id} attribute
   */
  @JsonProperty("id")
  @Override
  public int getId() {
    return id;
  }

  /**
   * @return The value of the {@code content} attribute
   */
  @JsonProperty("content")
  @Override
  public MySomethingContent getContent() {
    return content;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link AbstractSomething#getId() id} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for id
   * @return A modified copy of the {@code this} object
   */
  public final Something withId(int value) {
    if (this.id == value) return this;
    return new Something(value, this.content);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link AbstractSomething#getContent() content} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for content
   * @return A modified copy of the {@code this} object
   */
  public final Something withContent(MySomethingContent value) {
    if (this.content == value) return this;
    MySomethingContent newValue = Objects.requireNonNull(value, "content");
    return new Something(this.id, newValue);
  }

  /**
   * This instance is equal to all instances of {@code Something} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof Something
        && equalTo(0, (Something) another);
  }

  private boolean equalTo(int synthetic, Something another) {
    return id == another.id
        && content.equals(another.content);
  }

  /**
   * Computes a hash code from attributes: {@code id}, {@code content}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    @Var int h = 5381;
    h += (h << 5) + id;
    h += (h << 5) + content.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code Something} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return MoreObjects.toStringHelper("Something")
        .omitNullValues()
        .add("id", id)
        .add("content", content)
        .toString();
  }

  /**
   * Utility type used to correctly read immutable object from JSON representation.
   * @deprecated Do not use this type directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Generated(from = "AbstractSomething", generator = "Immutables")
  @Deprecated
  @SuppressWarnings("Immutable")
  @JsonAutoDetect(fieldVisibility = JsonAutoDetect.Visibility.NONE)
  static final class Json implements AbstractSomething {
    int id;
    boolean idIsSet;
    @Nullable MySomethingContent content;
    @JsonProperty("id")
    public void setId(int id) {
      this.id = id;
      this.idIsSet = true;
    }
    @JsonProperty("content")
    public void setContent(MySomethingContent content) {
      this.content = content;
    }
    @Override
    public Something withId(int id) { throw new UnsupportedOperationException(); }
    @Override
    public int getId() { throw new UnsupportedOperationException(); }
    @Override
    public MySomethingContent getContent() { throw new UnsupportedOperationException(); }
  }

  /**
   * @param json A JSON-bindable data structure
   * @return An immutable value type
   * @deprecated Do not use this method directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonCreator(mode = JsonCreator.Mode.DELEGATING)
  static Something fromJson(Json json) {
    Something.Builder builder = Something.builder();
    if (json.idIsSet) {
      builder.id(json.id);
    }
    if (json.content != null) {
      builder.content(json.content);
    }
    return builder.build();
  }

  /**
   * Creates an immutable copy of a {@link AbstractSomething} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable Something instance
   */
  public static Something copyOf(AbstractSomething instance) {
    if (instance instanceof Something) {
      return (Something) instance;
    }
    return Something.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link Something Something}.
   * <pre>
   * Something.builder()
   *    .id(int) // required {@link AbstractSomething#getId() id}
   *    .content(MySomethingContent) // required {@link AbstractSomething#getContent() content}
   *    .build();
   * </pre>
   * @return A new Something builder
   */
  public static Something.Builder builder() {
    return new Something.Builder();
  }

  /**
   * Builds instances of type {@link Something Something}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "AbstractSomething", generator = "Immutables")
  @NotThreadSafe
  public static final class Builder {
    private static final long INIT_BIT_ID = 0x1L;
    private static final long INIT_BIT_CONTENT = 0x2L;
    private long initBits = 0x3L;

    private int id;
    private @Nullable MySomethingContent content;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code nonimmutables.recurs.MyBase} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder from(MyBase instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    /**
     * Fill a builder with attribute values from the provided {@code nonimmutables.recurs.AbstractSomething} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder from(AbstractSomething instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    private void from(Object object) {
      @Var long bits = 0;
      if (object instanceof MyBase) {
        MyBase instance = (MyBase) object;
        if ((bits & 0x1L) == 0) {
          id(instance.getId());
          bits |= 0x1L;
        }
      }
      if (object instanceof AbstractSomething) {
        AbstractSomething instance = (AbstractSomething) object;
        content(instance.getContent());
        if ((bits & 0x1L) == 0) {
          id(instance.getId());
          bits |= 0x1L;
        }
      }
    }

    /**
     * Initializes the value for the {@link AbstractSomething#getId() id} attribute.
     * @param id The value for id 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder id(int id) {
      this.id = id;
      initBits &= ~INIT_BIT_ID;
      return this;
    }

    /**
     * Initializes the value for the {@link AbstractSomething#getContent() content} attribute.
     * @param content The value for content 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder content(MySomethingContent content) {
      this.content = Objects.requireNonNull(content, "content");
      initBits &= ~INIT_BIT_CONTENT;
      return this;
    }

    /**
     * Builds a new {@link Something Something}.
     * @return An immutable instance of Something
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public Something build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new Something(id, content);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_ID) != 0) attributes.add("id");
      if ((initBits & INIT_BIT_CONTENT) != 0) attributes.add("content");
      return "Cannot build Something, some of required attributes are not set " + attributes;
    }
  }
}
