package nonimmutables.shallow.deep;

import com.google.common.base.MoreObjects;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.errorprone.annotations.Var;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import nonimmutables.shallow.*;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link AbstractAlpha}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableAlpha.builder()}.
 */
@Generated(from = "AbstractAlpha", generator = "Immutables")
@SuppressWarnings({"all"})
@ParametersAreNonnullByDefault
@javax.annotation.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
@CheckReturnValue
final class ImmutableAlpha extends AbstractAlpha {
  private final ImmutableCharlie entity;

  private ImmutableAlpha(ImmutableCharlie entity) {
    this.entity = entity;
  }

  /**
   * @return The value of the {@code entity} attribute
   */
  @Override
  public ImmutableCharlie getEntity() {
    return entity;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link AbstractAlpha#getEntity() entity} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for entity
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableAlpha withEntity(ImmutableCharlie value) {
    if (this.entity == value) return this;
    ImmutableCharlie newValue = Objects.requireNonNull(value, "entity");
    return new ImmutableAlpha(newValue);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableAlpha} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableAlpha
        && equalTo(0, (ImmutableAlpha) another);
  }

  private boolean equalTo(int synthetic, ImmutableAlpha another) {
    return entity.equals(another.entity);
  }

  /**
   * Computes a hash code from attributes: {@code entity}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    @Var int h = 5381;
    h += (h << 5) + entity.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code Alpha} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return MoreObjects.toStringHelper("Alpha")
        .omitNullValues()
        .add("entity", entity)
        .toString();
  }

  /**
   * Creates an immutable copy of a {@link AbstractAlpha} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable Alpha instance
   */
  public static ImmutableAlpha copyOf(AbstractAlpha instance) {
    if (instance instanceof ImmutableAlpha) {
      return (ImmutableAlpha) instance;
    }
    return ImmutableAlpha.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableAlpha ImmutableAlpha}.
   * <pre>
   * ImmutableAlpha.builder()
   *    .entity(ImmutableCharlie) // required {@link AbstractAlpha#getEntity() entity}
   *    .build();
   * </pre>
   * @return A new ImmutableAlpha builder
   */
  public static ImmutableAlpha.Builder builder() {
    return new ImmutableAlpha.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableAlpha ImmutableAlpha}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "AbstractAlpha", generator = "Immutables")
  @NotThreadSafe
  public static final class Builder {
    private static final long INIT_BIT_ENTITY = 0x1L;
    private long initBits = 0x1L;

    private @Nullable ImmutableCharlie entity;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code AbstractAlpha} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder from(AbstractAlpha instance) {
      Objects.requireNonNull(instance, "instance");
      entity(instance.getEntity());
      return this;
    }

    /**
     * Initializes the value for the {@link AbstractAlpha#getEntity() entity} attribute.
     * @param entity The value for entity 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder entity(ImmutableCharlie entity) {
      this.entity = Objects.requireNonNull(entity, "entity");
      initBits &= ~INIT_BIT_ENTITY;
      return this;
    }

    /**
     * Builds a new {@link ImmutableAlpha ImmutableAlpha}.
     * @return An immutable instance of Alpha
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableAlpha build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new ImmutableAlpha(entity);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_ENTITY) != 0) attributes.add("entity");
      return "Cannot build Alpha, some of required attributes are not set " + attributes;
    }
  }
}
