package org.immutables.fixture;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.errorprone.annotations.Var;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

/**
 * Builds instances of type {@link ExtendingInnerBuilderValue ExtendingInnerBuilderValue}.
 * Initialize attributes and then invoke the {@link #build()} method to create an
 * immutable instance.
 * <p><em>{@code ExtendingInnerBuilderValue_Builder} is not thread-safe and generally should not be stored in a field or collection,
 * but instead used immediately to create instances.</em>
 */
@Generated(from = "ExtendingInnerBuilderValue", generator = "Immutables")
@SuppressWarnings({"all"})
@ParametersAreNonnullByDefault
@javax.annotation.Generated("org.immutables.processor.ProxyProcessor")
@NotThreadSafe
public class ExtendingInnerBuilderValue_Builder {
  private static final long INIT_BIT_ATTRIBUTE = 0x1L;
  private long initBits = 0x1L;

  private int attribute;
  private ImmutableList.Builder<String> list = ImmutableList.builder();

  /**
   * Creates a builder for {@link ExtendingInnerBuilderValue ExtendingInnerBuilderValue} instances.
   * <pre>
   * new ExtendingInnerBuilderValue.Builder()
   *    .attribute(int) // required {@link ExtendingInnerBuilderValue#attribute() attribute}
   *    .addList|addAllList(String) // {@link ExtendingInnerBuilderValue#list() list} elements
   *    .build();
   * </pre>
   */
  public ExtendingInnerBuilderValue_Builder() {
    if (!(this instanceof ExtendingInnerBuilderValue.Builder)) {
      throw new UnsupportedOperationException("Use: new ExtendingInnerBuilderValue.Builder()");
    }
  }

  /**
   * Fill a builder with attribute values from the provided {@code ExtendingInnerBuilderValue} instance.
   * Regular attribute values will be replaced with those from the given instance.
   * Absent optional values will not replace present values.
   * Collection elements and entries will be added, not replaced.
   * @param instance The instance from which to copy values
   * @return {@code this} builder for use in a chained invocation
   */
  @CanIgnoreReturnValue 
  public final ExtendingInnerBuilderValue.Builder from(ExtendingInnerBuilderValue instance) {
    Objects.requireNonNull(instance, "instance");
    attribute(instance.attribute());
    addAllList(instance.list());
    return (ExtendingInnerBuilderValue.Builder) this;
  }

  /**
   * Initializes the value for the {@link ExtendingInnerBuilderValue#attribute() attribute} attribute.
   * @param attribute The value for attribute 
   * @return {@code this} builder for use in a chained invocation
   */
  @CanIgnoreReturnValue 
  public final ExtendingInnerBuilderValue.Builder attribute(int attribute) {
    this.attribute = attribute;
    initBits &= ~INIT_BIT_ATTRIBUTE;
    return (ExtendingInnerBuilderValue.Builder) this;
  }

  /**
   * Adds one element to {@link ExtendingInnerBuilderValue#list() list} list.
   * @param element A list element
   * @return {@code this} builder for use in a chained invocation
   */
  @CanIgnoreReturnValue 
  public final ExtendingInnerBuilderValue.Builder addList(String element) {
    this.list.add(element);
    return (ExtendingInnerBuilderValue.Builder) this;
  }

  /**
   * Adds elements to {@link ExtendingInnerBuilderValue#list() list} list.
   * @param elements An array of list elements
   * @return {@code this} builder for use in a chained invocation
   */
  @CanIgnoreReturnValue 
  public final ExtendingInnerBuilderValue.Builder addList(String... elements) {
    this.list.add(elements);
    return (ExtendingInnerBuilderValue.Builder) this;
  }


  /**
   * Sets or replaces all elements for {@link ExtendingInnerBuilderValue#list() list} list.
   * @param elements An iterable of list elements
   * @return {@code this} builder for use in a chained invocation
   */
  @CanIgnoreReturnValue 
  public final ExtendingInnerBuilderValue.Builder list(Iterable<String> elements) {
    this.list = ImmutableList.builder();
    return addAllList(elements);
  }

  /**
   * Adds elements to {@link ExtendingInnerBuilderValue#list() list} list.
   * @param elements An iterable of list elements
   * @return {@code this} builder for use in a chained invocation
   */
  @CanIgnoreReturnValue 
  public final ExtendingInnerBuilderValue.Builder addAllList(Iterable<String> elements) {
    this.list.addAll(elements);
    return (ExtendingInnerBuilderValue.Builder) this;
  }

  /**
   * Builds a new {@link ExtendingInnerBuilderValue ExtendingInnerBuilderValue}.
   * @return An immutable instance of ExtendingInnerBuilderValue
   * @throws java.lang.IllegalStateException if any required attributes are missing
   */
  public ExtendingInnerBuilderValue build() {
    if (initBits != 0) {
      throw new IllegalStateException(formatRequiredAttributesMessage());
    }
    return new ExtendingInnerBuilderValue_Builder.ImmutableExtendingInnerBuilderValue(this);
  }

  private String formatRequiredAttributesMessage() {
    List<String> attributes = new ArrayList<>();
    if ((initBits & INIT_BIT_ATTRIBUTE) != 0) attributes.add("attribute");
    return "Cannot build ExtendingInnerBuilderValue, some of required attributes are not set " + attributes;
  }

  /**
   * Immutable implementation of {@link ExtendingInnerBuilderValue}.
   * <p>
   * Use the builder to create immutable instances:
   * {@code new ExtendingInnerBuilderValue.Builder()}.
   */
  @Generated(from = "ExtendingInnerBuilderValue", generator = "Immutables")
  @Immutable
  @CheckReturnValue
  private static final class ImmutableExtendingInnerBuilderValue
      extends ExtendingInnerBuilderValue {
    private final int attribute;
    private final ImmutableList<String> list;

    private ImmutableExtendingInnerBuilderValue(ExtendingInnerBuilderValue_Builder builder) {
      this.attribute = builder.attribute;
      this.list = builder.list.build();
    }

    /**
     * @return The value of the {@code attribute} attribute
     */
    @Override
    int attribute() {
      return attribute;
    }

    /**
     * @return The value of the {@code list} attribute
     */
    @Override
    ImmutableList<String> list() {
      return list;
    }

    /**
     * This instance is equal to all instances of {@code ImmutableExtendingInnerBuilderValue} that have equal attribute values.
     * @return {@code true} if {@code this} is equal to {@code another} instance
     */
    @Override
    public boolean equals(@Nullable Object another) {
      if (this == another) return true;
      return another instanceof ExtendingInnerBuilderValue_Builder.ImmutableExtendingInnerBuilderValue
          && equalTo(0, (ExtendingInnerBuilderValue_Builder.ImmutableExtendingInnerBuilderValue) another);
    }

    private boolean equalTo(int synthetic, ExtendingInnerBuilderValue_Builder.ImmutableExtendingInnerBuilderValue another) {
      return attribute == another.attribute
          && list.equals(another.list);
    }

    /**
     * Computes a hash code from attributes: {@code attribute}, {@code list}.
     * @return hashCode value
     */
    @Override
    public int hashCode() {
      @Var int h = 5381;
      h += (h << 5) + attribute;
      h += (h << 5) + list.hashCode();
      return h;
    }

    /**
     * Prints the immutable value {@code ExtendingInnerBuilderValue} with attribute values.
     * @return A string representation of the value
     */
    @Override
    public String toString() {
      return MoreObjects.toStringHelper("ExtendingInnerBuilderValue")
          .omitNullValues()
          .add("attribute", attribute)
          .add("list", list)
          .toString();
    }
  }
}
