package org.immutables.fixture;

import com.google.gson.*;
import com.google.gson.reflect.*;
import com.google.gson.stream.*;
import java.io.IOException;
import javax.annotation.Generated;
import javax.annotation.ParametersAreNonnullByDefault;

/**
 * A {@code TypeAdapterFactory} that handles all of the immutable types generated under {@code JsonIgnore}.
 * @see ImmutableJsonIgnore
 */
@SuppressWarnings({"all", "MethodCanBeStatic"})
@ParametersAreNonnullByDefault
@Generated("org.immutables.processor.ProxyProcessor")
@org.immutables.value.Generated(from = "org.immutables.fixture", generator = "Gsons")
public final class GsonAdaptersJsonIgnore implements TypeAdapterFactory {
  @SuppressWarnings({"unchecked", "rawtypes"}) // safe unchecked, types are verified in runtime
  @Override
  public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
    if (JsonIgnoreTypeAdapter.adapts(type)) {
      return (TypeAdapter<T>) new JsonIgnoreTypeAdapter(gson);
    }
    return null;
  }

  @Override
  public String toString() {
    return "GsonAdaptersJsonIgnore(JsonIgnore)";
  }

  @org.immutables.value.Generated(from = "JsonIgnore", generator = "Gsons")
  @SuppressWarnings({"unchecked", "rawtypes"}) // safe unchecked, types are verified in runtime
  private static class JsonIgnoreTypeAdapter extends TypeAdapter<JsonIgnore> {

    JsonIgnoreTypeAdapter(Gson gson) {
    } 

    static boolean adapts(TypeToken<?> type) {
      return JsonIgnore.class == type.getRawType()
          || ImmutableJsonIgnore.class == type.getRawType();
    }

    @Override
    public void write(JsonWriter out, JsonIgnore value) throws IOException {
      if (value == null) {
        out.nullValue();
      } else {
        writeJsonIgnore(out, value);
      }
    }

    @Override
    public JsonIgnore read(JsonReader in) throws IOException {
      return readJsonIgnore(in);
    }

    private void writeJsonIgnore(JsonWriter out, JsonIgnore instance)
        throws IOException {
      out.beginObject();
      out.name("value");
      out.value(instance.value());
      out.endObject();
    }

    private  JsonIgnore readJsonIgnore(JsonReader in)
        throws IOException {
      if (in.peek() == JsonToken.NULL) {
        in.nextNull();
        return null;
      }
      ImmutableJsonIgnore.Builder builder = ImmutableJsonIgnore.builder();
      in.beginObject();
      while (in.hasNext()) {
        eachAttribute(in, builder);
      }
      in.endObject();
      return builder.build();
    }

    private void eachAttribute(JsonReader in, ImmutableJsonIgnore.Builder builder)
        throws IOException {
      String attributeName = in.nextName();
      switch (attributeName.charAt(0)) {
      case 'v':
        if ("value".equals(attributeName)) {
          readInValue(in, builder);
          return;
        }
        break;
      default:
      }
      in.skipValue();
    }

    private void readInValue(JsonReader in, ImmutableJsonIgnore.Builder builder)
        throws IOException {
      builder.value(in.nextInt());
    }
  }
}
