package org.immutables.fixture;

import com.google.common.primitives.UnsignedInteger;
import com.google.gson.*;
import com.google.gson.reflect.*;
import com.google.gson.stream.*;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import javax.annotation.Generated;
import javax.annotation.ParametersAreNonnullByDefault;

/**
 * A {@code TypeAdapterFactory} that handles all of the immutable types generated under {@code SillyEntity}.
 * @see ImmutableSillyEntity
 */
@SuppressWarnings({"all", "MethodCanBeStatic"})
@ParametersAreNonnullByDefault
@Generated("org.immutables.processor.ProxyProcessor")
@org.immutables.value.Generated(from = "org.immutables.fixture", generator = "Gsons")
public final class GsonAdaptersSillyEntity implements TypeAdapterFactory {
  @SuppressWarnings({"unchecked", "rawtypes"}) // safe unchecked, types are verified in runtime
  @Override
  public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
    if (SillyEntityTypeAdapter.adapts(type)) {
      return (TypeAdapter<T>) new SillyEntityTypeAdapter(gson);
    }
    return null;
  }

  @Override
  public String toString() {
    return "GsonAdaptersSillyEntity(SillyEntity)";
  }

  @org.immutables.value.Generated(from = "SillyEntity", generator = "Gsons")
  @SuppressWarnings({"unchecked", "rawtypes"}) // safe unchecked, types are verified in runtime
  private static class SillyEntityTypeAdapter extends TypeAdapter<SillyEntity> {
    public final Integer payloadSecondaryTypeSample = null;
    public final Integer intsTypeSample = null;
    public final UnsignedInteger derTypeSample = null;
    private final TypeAdapter<Integer> payloadSecondaryTypeAdapter;
    private final TypeAdapter<Integer> intsTypeAdapter;
    private final TypeAdapter<UnsignedInteger> derTypeAdapter;

    SillyEntityTypeAdapter(Gson gson) {
      this.payloadSecondaryTypeAdapter = gson.getAdapter( Integer.class);
      this.intsTypeAdapter = gson.getAdapter( Integer.class);
      this.derTypeAdapter = gson.getAdapter( UnsignedInteger.class);
    } 

    static boolean adapts(TypeToken<?> type) {
      return SillyEntity.class == type.getRawType()
          || ImmutableSillyEntity.class == type.getRawType();
    }

    @Override
    public void write(JsonWriter out, SillyEntity value) throws IOException {
      if (value == null) {
        out.nullValue();
      } else {
        writeSillyEntity(out, value);
      }
    }

    @Override
    public SillyEntity read(JsonReader in) throws IOException {
      return readSillyEntity(in);
    }

    private void writeSillyEntity(JsonWriter out, SillyEntity instance)
        throws IOException {
      out.beginObject();
      out.name("_id");
      out.value(instance.id());
      out.name("v");
      out.value(instance.val());
      Map<String, Integer> payloadMapping = instance.payload();
      out.name("p");
      out.beginObject();
      for (Map.Entry<String, Integer> e : payloadMapping.entrySet()) {
        String key = e.getKey();
        out.name(key);
        int value = e.getValue();
        payloadSecondaryTypeAdapter.write(out, value);
      }
      out.endObject();
      List<Integer> intsElements = instance.ints();
      out.name("i");
      out.beginArray();
      for (Integer e : intsElements) {
        intsTypeAdapter.write(out, e);
      }
      out.endArray();
      out.name("der");
      derTypeAdapter.write(out, instance.der());
      out.endObject();
    }

    private  SillyEntity readSillyEntity(JsonReader in)
        throws IOException {
      if (in.peek() == JsonToken.NULL) {
        in.nextNull();
        return null;
      }
      ImmutableSillyEntity.Builder builder = ImmutableSillyEntity.builder();
      in.beginObject();
      while (in.hasNext()) {
        eachAttribute(in, builder);
      }
      in.endObject();
      return builder.build();
    }

    private void eachAttribute(JsonReader in, ImmutableSillyEntity.Builder builder)
        throws IOException {
      String attributeName = in.nextName();
      switch (attributeName.charAt(0)) {
      case '_':
        if ("_id".equals(attributeName)) {
          readInId(in, builder);
          return;
        }
        break;
      case 'v':
        if ("v".equals(attributeName)) {
          readInVal(in, builder);
          return;
        }
        break;
      case 'p':
        if ("p".equals(attributeName)) {
          readInPayload(in, builder);
          return;
        }
        break;
      case 'i':
        if ("i".equals(attributeName)) {
          readInInts(in, builder);
          return;
        }
        break;
      default:
      }
      in.skipValue();
    }

    private void readInId(JsonReader in, ImmutableSillyEntity.Builder builder)
        throws IOException {
      builder.id(in.nextInt());
    }

    private void readInVal(JsonReader in, ImmutableSillyEntity.Builder builder)
        throws IOException {
      builder.val(in.nextString());
    }

    private void readInPayload(JsonReader in, ImmutableSillyEntity.Builder builder)
        throws IOException {
      if (in.peek() == JsonToken.NULL) {
        in.nextNull();
      } else {
        in.beginObject();
        while(in.hasNext()) {
          String rawKey = in.nextName();
          String key = rawKey;
          Integer value = payloadSecondaryTypeAdapter.read(in);
          builder.putPayload(key, value);
        }
        in.endObject();
      }
    }

    private void readInInts(JsonReader in, ImmutableSillyEntity.Builder builder)
        throws IOException {
      if (in.peek() == JsonToken.BEGIN_ARRAY) {
        in.beginArray();
        while(in.hasNext()) {
          builder.addInts(in.nextInt());
        }
        in.endArray();
      } else if (in.peek() == JsonToken.NULL) {
        in.nextNull();
      } else {
        builder.addInts(in.nextInt());
      }
    }
  }
}
