package org.immutables.fixture;

import com.google.common.collect.ImmutableMap;
import com.google.gson.*;
import com.google.gson.reflect.*;
import com.google.gson.stream.*;
import java.io.IOException;
import java.lang.annotation.RetentionPolicy;
import java.util.Map;
import javax.annotation.Generated;
import javax.annotation.ParametersAreNonnullByDefault;

/**
 * A {@code TypeAdapterFactory} that handles all of the immutable types generated under {@code SillyMapTup}.
 * @see ImmutableSillyMapTup
 */
@SuppressWarnings({"all", "MethodCanBeStatic"})
@ParametersAreNonnullByDefault
@Generated("org.immutables.processor.ProxyProcessor")
@org.immutables.value.Generated(from = "org.immutables.fixture", generator = "Gsons")
public final class GsonAdaptersSillyMapTup implements TypeAdapterFactory {
  @SuppressWarnings({"unchecked", "rawtypes"}) // safe unchecked, types are verified in runtime
  @Override
  public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
    if (SillyMapTupTypeAdapter.adapts(type)) {
      return (TypeAdapter<T>) new SillyMapTupTypeAdapter(gson);
    }
    return null;
  }

  @Override
  public String toString() {
    return "GsonAdaptersSillyMapTup(SillyMapTup)";
  }

  @org.immutables.value.Generated(from = "SillyMapTup", generator = "Gsons")
  @SuppressWarnings({"unchecked", "rawtypes"}) // safe unchecked, types are verified in runtime
  private static class SillyMapTupTypeAdapter extends TypeAdapter<SillyMapTup> {
    public final RetentionPolicy holder1TypeSample = null;
    public final Integer holder1SecondaryTypeSample = null;
    private final TypeAdapter<RetentionPolicy> holder1TypeAdapter;
    private final TypeAdapter<Integer> holder1SecondaryTypeAdapter;

    SillyMapTupTypeAdapter(Gson gson) {
      this.holder1TypeAdapter = gson.getAdapter( RetentionPolicy.class);
      this.holder1SecondaryTypeAdapter = gson.getAdapter( Integer.class);
    } 

    static boolean adapts(TypeToken<?> type) {
      return SillyMapTup.class == type.getRawType()
          || ImmutableSillyMapTup.class == type.getRawType();
    }

    @Override
    public void write(JsonWriter out, SillyMapTup value) throws IOException {
      if (value == null) {
        out.nullValue();
      } else {
        writeSillyMapTup(out, value);
      }
    }

    @Override
    public SillyMapTup read(JsonReader in) throws IOException {
      return readSillyMapTup(in);
    }

    private void writeSillyMapTup(JsonWriter out, SillyMapTup instance)
        throws IOException {
      out.beginArray();
      Map<RetentionPolicy, Integer> holder1Mapping = instance.holder1();
      out.beginObject();
      for (Map.Entry<RetentionPolicy, Integer> e : holder1Mapping.entrySet()) {
        String key = holder1TypeAdapter.toJsonTree(e.getKey()).getAsString();
        out.name(key);
        int value = e.getValue();
        holder1SecondaryTypeAdapter.write(out, value);
      }
      out.endObject();
      out.value(instance.value());
      out.endArray();
    }

    private  SillyMapTup readSillyMapTup(JsonReader in)
        throws IOException {
      if (in.peek() == JsonToken.NULL) {
        in.nextNull();
        return null;
      }
      in.beginArray();
      SillyMapTup instance = ImmutableSillyMapTup.of(
        readParameterHolder1(in),
        readParameterValue(in));
      in.endArray();
      return instance;
    }

    private  Map<RetentionPolicy, Integer> readParameterHolder1(JsonReader in)
        throws IOException {
      ImmutableMap.Builder<RetentionPolicy, Integer> mappings = ImmutableMap.builder();
      if (in.peek() == JsonToken.NULL) {
        in.nextNull();
      } else {
        in.beginObject();
        while(in.hasNext()) {
          String rawKey = in.nextName();
          RetentionPolicy key = holder1TypeAdapter.fromJsonTree(new JsonPrimitive(rawKey));
          Integer value = holder1SecondaryTypeAdapter.read(in);
          mappings.put(key, value);
        }
        in.endObject();
      }
      return mappings.build();
    }

    private static int readParameterValue(JsonReader in)
        throws IOException {
      return in.nextInt();
    }
  }
}
