package org.immutables.fixture;

import com.google.gson.*;
import com.google.gson.reflect.*;
import com.google.gson.stream.*;
import java.io.IOException;
import java.util.List;
import javax.annotation.Generated;
import javax.annotation.ParametersAreNonnullByDefault;
import org.immutables.gson.adapter.ExpectedSubtypesAdapter;

/**
 * A {@code TypeAdapterFactory} that handles all of the immutable types generated under {@code SillyPolyHost}.
 * @see ImmutableSillyPolyHost
 */
@SuppressWarnings({"all", "MethodCanBeStatic"})
@ParametersAreNonnullByDefault
@Generated("org.immutables.processor.ProxyProcessor")
@org.immutables.value.Generated(from = "org.immutables.fixture", generator = "Gsons")
public final class GsonAdaptersSillyPolyHost implements TypeAdapterFactory {
  @SuppressWarnings({"unchecked", "rawtypes"}) // safe unchecked, types are verified in runtime
  @Override
  public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
    if (SillyPolyHostTypeAdapter.adapts(type)) {
      return (TypeAdapter<T>) new SillyPolyHostTypeAdapter(gson);
    }
    return null;
  }

  @Override
  public String toString() {
    return "GsonAdaptersSillyPolyHost(SillyPolyHost)";
  }

  @org.immutables.value.Generated(from = "SillyPolyHost", generator = "Gsons")
  @SuppressWarnings({"unchecked", "rawtypes"}) // safe unchecked, types are verified in runtime
  private static class SillyPolyHostTypeAdapter extends TypeAdapter<SillyPolyHost> {
    public final SillyAbstract sTypeSample = null;
    private final TypeAdapter<SillyAbstract> sTypeAdapter;

    SillyPolyHostTypeAdapter(Gson gson) {
      this.sTypeAdapter = ExpectedSubtypesAdapter.create(gson,
          SillyAbstract.class,
          TypeToken.get(SillySub1.class),
          TypeToken.get(SillySub2.class));
    } 

    static boolean adapts(TypeToken<?> type) {
      return SillyPolyHost.class == type.getRawType()
          || ImmutableSillyPolyHost.class == type.getRawType();
    }

    @Override
    public void write(JsonWriter out, SillyPolyHost value) throws IOException {
      if (value == null) {
        out.nullValue();
      } else {
        writeSillyPolyHost(out, value);
      }
    }

    @Override
    public SillyPolyHost read(JsonReader in) throws IOException {
      return readSillyPolyHost(in);
    }

    private void writeSillyPolyHost(JsonWriter out, SillyPolyHost instance)
        throws IOException {
      out.beginObject();
      List<SillyAbstract> sElements = instance.s();
      out.name("s");
      out.beginArray();
      for (SillyAbstract e : sElements) {
        sTypeAdapter.write(out, e);
      }
      out.endArray();
      out.endObject();
    }

    private  SillyPolyHost readSillyPolyHost(JsonReader in)
        throws IOException {
      if (in.peek() == JsonToken.NULL) {
        in.nextNull();
        return null;
      }
      ImmutableSillyPolyHost.Builder builder = ImmutableSillyPolyHost.builder();
      in.beginObject();
      while (in.hasNext()) {
        eachAttribute(in, builder);
      }
      in.endObject();
      return builder.build();
    }

    private void eachAttribute(JsonReader in, ImmutableSillyPolyHost.Builder builder)
        throws IOException {
      String attributeName = in.nextName();
      switch (attributeName.charAt(0)) {
      case 's':
        if ("s".equals(attributeName)) {
          readInS(in, builder);
          return;
        }
        break;
      default:
      }
      in.skipValue();
    }

    private void readInS(JsonReader in, ImmutableSillyPolyHost.Builder builder)
        throws IOException {
      if (in.peek() == JsonToken.BEGIN_ARRAY) {
        in.beginArray();
        while(in.hasNext()) {
          SillyAbstract value = sTypeAdapter.read(in);
          builder.addS(value);
        }
        in.endArray();
      } else if (in.peek() == JsonToken.NULL) {
        in.nextNull();
      } else {
        SillyAbstract value = sTypeAdapter.read(in);
        builder.addS(value);
      }
    }
  }
}
