package org.immutables.fixture;

import com.google.common.base.Optional;
import com.google.gson.*;
import com.google.gson.reflect.*;
import com.google.gson.stream.*;
import io.atlassian.fugue.Option;
import java.io.IOException;
import java.util.List;
import javax.annotation.Generated;
import javax.annotation.ParametersAreNonnullByDefault;
import org.immutables.fixture.subpack.SillySubstructure;

/**
 * A {@code TypeAdapterFactory} that handles all of the immutable types generated under {@code SillyStructureWithId}.
 * @see ImmutableSillyStructureWithId
 */
@SuppressWarnings({"all", "MethodCanBeStatic"})
@ParametersAreNonnullByDefault
@Generated("org.immutables.processor.ProxyProcessor")
@org.immutables.value.Generated(from = "org.immutables.fixture", generator = "Gsons")
public final class GsonAdaptersSillyStructureWithId implements TypeAdapterFactory {
  @SuppressWarnings({"unchecked", "rawtypes"}) // safe unchecked, types are verified in runtime
  @Override
  public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
    if (SillyStructureWithIdTypeAdapter.adapts(type)) {
      return (TypeAdapter<T>) new SillyStructureWithIdTypeAdapter(gson);
    }
    return null;
  }

  @Override
  public String toString() {
    return "GsonAdaptersSillyStructureWithId(SillyStructureWithId)";
  }

  @org.immutables.value.Generated(from = "SillyStructureWithId", generator = "Gsons")
  @SuppressWarnings({"unchecked", "rawtypes"}) // safe unchecked, types are verified in runtime
  private static class SillyStructureWithIdTypeAdapter extends TypeAdapter<SillyStructureWithId> {
    public final Integer opt3TypeSample = null;
    public final Integer opt5TypeSample = null;
    public final SillySubstructure subs6TypeSample = null;
    public final SillySubstructure nest7TypeSample = null;
    public final SillyTuplie tup3TypeSample = null;
    private final TypeAdapter<Integer> opt3TypeAdapter;
    private final TypeAdapter<Integer> opt5TypeAdapter;
    private final TypeAdapter<SillySubstructure> subs6TypeAdapter;
    private final TypeAdapter<SillySubstructure> nest7TypeAdapter;
    private final TypeAdapter<SillyTuplie> tup3TypeAdapter;

    SillyStructureWithIdTypeAdapter(Gson gson) {
      this.opt3TypeAdapter = gson.getAdapter( Integer.class);
      this.opt5TypeAdapter = gson.getAdapter( Integer.class);
      this.subs6TypeAdapter = gson.getAdapter( SillySubstructure.class);
      this.nest7TypeAdapter = gson.getAdapter( SillySubstructure.class);
      this.tup3TypeAdapter = gson.getAdapter( SillyTuplie.class);
    } 

    static boolean adapts(TypeToken<?> type) {
      return SillyStructureWithId.class == type.getRawType()
          || ImmutableSillyStructureWithId.class == type.getRawType();
    }

    @Override
    public void write(JsonWriter out, SillyStructureWithId value) throws IOException {
      if (value == null) {
        out.nullValue();
      } else {
        writeSillyStructureWithId(out, value);
      }
    }

    @Override
    public SillyStructureWithId read(JsonReader in) throws IOException {
      return readSillyStructureWithId(in);
    }

    private void writeSillyStructureWithId(JsonWriter out, SillyStructureWithId instance)
        throws IOException {
      out.beginObject();
      out.name("_id");
      out.value(instance.id());
      out.name("attr1");
      out.value(instance.attr1());
      out.name("flag2");
      out.value(instance.flag2());
      Optional<Integer> opt3Optional = instance.opt3();
      if (opt3Optional.isPresent()) {
        out.name("opt3");
        Integer opt3Value = opt3Optional.get();
        opt3TypeAdapter.write(out, opt3Value);
      } else if (out.getSerializeNulls()) {
        out.name("opt3");
        out.nullValue();
      }
      Option<Integer> opt5Optional = instance.opt5();
      if (opt5Optional.isDefined()) {
        out.name("opt5");
        Integer opt5Value = opt5Optional.get();
        opt5TypeAdapter.write(out, opt5Value);
      } else if (out.getSerializeNulls()) {
        out.name("opt5");
        out.nullValue();
      }
      out.name("very4");
      out.value(instance.very4());
      out.name("wet5");
      out.value(instance.wet5());
      List<SillySubstructure> subs6Elements = instance.subs6();
      out.name("subs6");
      out.beginArray();
      for (SillySubstructure e : subs6Elements) {
        subs6TypeAdapter.write(out, e);
      }
      out.endArray();
      out.name("nest7");
      nest7TypeAdapter.write(out, instance.nest7());
      Optional<SillyTuplie> tup3Optional = instance.tup3();
      if (tup3Optional.isPresent()) {
        out.name("tup3");
        SillyTuplie tup3Value = tup3Optional.get();
        tup3TypeAdapter.write(out, tup3Value);
      } else if (out.getSerializeNulls()) {
        out.name("tup3");
        out.nullValue();
      }
      out.name("int9");
      out.value(instance.int9());
      out.endObject();
    }

    private  SillyStructureWithId readSillyStructureWithId(JsonReader in)
        throws IOException {
      if (in.peek() == JsonToken.NULL) {
        in.nextNull();
        return null;
      }
      ImmutableSillyStructureWithId.Builder builder = ImmutableSillyStructureWithId.builder();
      in.beginObject();
      while (in.hasNext()) {
        eachAttribute(in, builder);
      }
      in.endObject();
      return builder.build();
    }

    private void eachAttribute(JsonReader in, ImmutableSillyStructureWithId.Builder builder)
        throws IOException {
      String attributeName = in.nextName();
      switch (attributeName.charAt(0)) {
      case '_':
        if ("_id".equals(attributeName)) {
          readInId(in, builder);
          return;
        }
        break;
      case 'a':
        if ("attr1".equals(attributeName)) {
          readInAttr1(in, builder);
          return;
        }
        break;
      case 'f':
        if ("flag2".equals(attributeName)) {
          readInFlag2(in, builder);
          return;
        }
        break;
      case 'o':
        if ("opt3".equals(attributeName)) {
          readInOpt3(in, builder);
          return;
        }
        if ("opt5".equals(attributeName)) {
          readInOpt5(in, builder);
          return;
        }
        break;
      case 'v':
        if ("very4".equals(attributeName)) {
          readInVery4(in, builder);
          return;
        }
        break;
      case 'w':
        if ("wet5".equals(attributeName)) {
          readInWet5(in, builder);
          return;
        }
        break;
      case 's':
        if ("subs6".equals(attributeName)) {
          readInSubs6(in, builder);
          return;
        }
        break;
      case 'n':
        if ("nest7".equals(attributeName)) {
          readInNest7(in, builder);
          return;
        }
        break;
      case 't':
        if ("tup3".equals(attributeName)) {
          readInTup3(in, builder);
          return;
        }
        break;
      case 'i':
        if ("int9".equals(attributeName)) {
          readInInt9(in, builder);
          return;
        }
        break;
      default:
      }
      in.skipValue();
    }

    private void readInId(JsonReader in, ImmutableSillyStructureWithId.Builder builder)
        throws IOException {
      builder.id(in.nextString());
    }

    private void readInAttr1(JsonReader in, ImmutableSillyStructureWithId.Builder builder)
        throws IOException {
      builder.attr1(in.nextString());
    }

    private void readInFlag2(JsonReader in, ImmutableSillyStructureWithId.Builder builder)
        throws IOException {
      builder.flag2(in.nextBoolean());
    }

    private void readInOpt3(JsonReader in, ImmutableSillyStructureWithId.Builder builder)
        throws IOException {
      if (in.peek() == JsonToken.NULL) {
        in.nextNull();
      } else {
        Integer value = opt3TypeAdapter.read(in);
        builder.opt3(value);
      }
    }

    private void readInOpt5(JsonReader in, ImmutableSillyStructureWithId.Builder builder)
        throws IOException {
      if (in.peek() == JsonToken.NULL) {
        in.nextNull();
      } else {
        Integer value = opt5TypeAdapter.read(in);
        builder.opt5(value);
      }
    }

    private void readInVery4(JsonReader in, ImmutableSillyStructureWithId.Builder builder)
        throws IOException {
      builder.very4(in.nextLong());
    }

    private void readInWet5(JsonReader in, ImmutableSillyStructureWithId.Builder builder)
        throws IOException {
      builder.wet5(in.nextDouble());
    }

    private void readInSubs6(JsonReader in, ImmutableSillyStructureWithId.Builder builder)
        throws IOException {
      if (in.peek() == JsonToken.BEGIN_ARRAY) {
        in.beginArray();
        while(in.hasNext()) {
          SillySubstructure value = subs6TypeAdapter.read(in);
          builder.addSubs6(value);
        }
        in.endArray();
      } else if (in.peek() == JsonToken.NULL) {
        in.nextNull();
      } else {
        SillySubstructure value = subs6TypeAdapter.read(in);
        builder.addSubs6(value);
      }
    }

    private void readInNest7(JsonReader in, ImmutableSillyStructureWithId.Builder builder)
        throws IOException {
      SillySubstructure value = nest7TypeAdapter.read(in);
      builder.nest7(value);
    }

    private void readInTup3(JsonReader in, ImmutableSillyStructureWithId.Builder builder)
        throws IOException {
      if (in.peek() == JsonToken.NULL) {
        in.nextNull();
      } else {
        SillyTuplie value = tup3TypeAdapter.read(in);
        builder.tup3(value);
      }
    }

    private void readInInt9(JsonReader in, ImmutableSillyStructureWithId.Builder builder)
        throws IOException {
      builder.int9(in.nextInt());
    }
  }
}
