package org.immutables.fixture;

import com.google.common.base.MoreObjects;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.errorprone.annotations.Var;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link NonAttributes.Abc}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableAbc.builder()}.
 */
@Generated(from = "NonAttributes.Abc", generator = "Immutables")
@SuppressWarnings({"all"})
@ParametersAreNonnullByDefault
@javax.annotation.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
@CheckReturnValue
public final class ImmutableAbc implements NonAttributes.Abc {
  private final int a;

  private ImmutableAbc(int a) {
    this.a = a;
  }

  /**
   * @return The value of the {@code a} attribute
   */
  @Override
  public int a() {
    return a;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link NonAttributes.Abc#a() a} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for a
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableAbc withA(int value) {
    if (this.a == value) return this;
    return new ImmutableAbc(value);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableAbc} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableAbc
        && equalTo(0, (ImmutableAbc) another);
  }

  private boolean equalTo(int synthetic, ImmutableAbc another) {
    return a == another.a;
  }

  /**
   * Computes a hash code from attributes: {@code a}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    @Var int h = 5381;
    h += (h << 5) + a;
    return h;
  }

  /**
   * Prints the immutable value {@code Abc} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return MoreObjects.toStringHelper("Abc")
        .omitNullValues()
        .add("a", a)
        .toString();
  }

  /**
   * Creates an immutable copy of a {@link NonAttributes.Abc} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable Abc instance
   */
  public static ImmutableAbc copyOf(NonAttributes.Abc instance) {
    if (instance instanceof ImmutableAbc) {
      return (ImmutableAbc) instance;
    }
    return ImmutableAbc.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableAbc ImmutableAbc}.
   * <pre>
   * ImmutableAbc.builder()
   *    .a(int) // required {@link NonAttributes.Abc#a() a}
   *    .build();
   * </pre>
   * @return A new ImmutableAbc builder
   */
  public static ImmutableAbc.Builder builder() {
    return new ImmutableAbc.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableAbc ImmutableAbc}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "NonAttributes.Abc", generator = "Immutables")
  @NotThreadSafe
  public static final class Builder {
    private static final long INIT_BIT_A = 0x1L;
    private long initBits = 0x1L;

    private int a;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code org.immutables.fixture.NonAttributes} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder from(NonAttributes instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    /**
     * Fill a builder with attribute values from the provided {@code org.immutables.fixture.NonAttributes.Abc} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder from(NonAttributes.Abc instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    private void from(Object object) {
      @Var long bits = 0;
      if (object instanceof NonAttributes) {
        NonAttributes instance = (NonAttributes) object;
        if ((bits & 0x1L) == 0) {
          a(instance.a());
          bits |= 0x1L;
        }
      }
      if (object instanceof NonAttributes.Abc) {
        NonAttributes.Abc instance = (NonAttributes.Abc) object;
        if ((bits & 0x1L) == 0) {
          a(instance.a());
          bits |= 0x1L;
        }
      }
    }

    /**
     * Initializes the value for the {@link NonAttributes.Abc#a() a} attribute.
     * @param a The value for a 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder a(int a) {
      this.a = a;
      initBits &= ~INIT_BIT_A;
      return this;
    }

    /**
     * Builds a new {@link ImmutableAbc ImmutableAbc}.
     * @return An immutable instance of Abc
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableAbc build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new ImmutableAbc(a);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_A) != 0) attributes.add("a");
      return "Cannot build Abc, some of required attributes are not set " + attributes;
    }
  }
}
