package org.immutables.fixture;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableSet;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.errorprone.annotations.Var;
import java.util.Objects;
import java.util.Set;
import javax.annotation.CheckForNull;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link CheckForNullAttributes}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableCheckForNullAttributes.builder()}.
 */
@Generated(from = "CheckForNullAttributes", generator = "Immutables")
@SuppressWarnings({"all"})
@ParametersAreNonnullByDefault
@javax.annotation.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
@CheckReturnValue
public final class ImmutableCheckForNullAttributes implements CheckForNullAttributes {
  private final @CheckForNull String a;
  private final @CheckForNull ImmutableSet<String> b;

  private ImmutableCheckForNullAttributes(
      @CheckForNull String a,
      @CheckForNull ImmutableSet<String> b) {
    this.a = a;
    this.b = b;
  }

  /**
   * @return The value of the {@code a} attribute
   */
  @Override
  public @CheckForNull String a() {
    return a;
  }

  /**
   * @return The value of the {@code b} attribute
   */
  @Override
  public @CheckForNull ImmutableSet<String> b() {
    return b;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link CheckForNullAttributes#a() a} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for a (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableCheckForNullAttributes withA(@CheckForNull String value) {
    if (Objects.equals(this.a, value)) return this;
    return new ImmutableCheckForNullAttributes(value, this.b);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link CheckForNullAttributes#b() b}.
   * @param elements The elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableCheckForNullAttributes withB(@CheckForNull String... elements) {
    if (elements == null) {
      return new ImmutableCheckForNullAttributes(this.a, null);
    }
    @CheckForNull ImmutableSet<String> newValue = elements == null ? null : ImmutableSet.copyOf(elements);
    return new ImmutableCheckForNullAttributes(this.a, newValue);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link CheckForNullAttributes#b() b}.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param elements An iterable of b elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableCheckForNullAttributes withB(@CheckForNull Iterable<String> elements) {
    if (this.b == elements) return this;
    @CheckForNull ImmutableSet<String> newValue = elements == null ? null : ImmutableSet.copyOf(elements);
    return new ImmutableCheckForNullAttributes(this.a, newValue);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableCheckForNullAttributes} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableCheckForNullAttributes
        && equalTo(0, (ImmutableCheckForNullAttributes) another);
  }

  private boolean equalTo(int synthetic, ImmutableCheckForNullAttributes another) {
    return Objects.equals(a, another.a)
        && Objects.equals(b, another.b);
  }

  /**
   * Computes a hash code from attributes: {@code a}, {@code b}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    @Var int h = 5381;
    h += (h << 5) + Objects.hashCode(a);
    h += (h << 5) + Objects.hashCode(b);
    return h;
  }

  /**
   * Prints the immutable value {@code CheckForNullAttributes} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return MoreObjects.toStringHelper("CheckForNullAttributes")
        .omitNullValues()
        .add("a", a)
        .add("b", b)
        .toString();
  }

  /**
   * Creates an immutable copy of a {@link CheckForNullAttributes} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable CheckForNullAttributes instance
   */
  public static ImmutableCheckForNullAttributes copyOf(CheckForNullAttributes instance) {
    if (instance instanceof ImmutableCheckForNullAttributes) {
      return (ImmutableCheckForNullAttributes) instance;
    }
    return ImmutableCheckForNullAttributes.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableCheckForNullAttributes ImmutableCheckForNullAttributes}.
   * <pre>
   * ImmutableCheckForNullAttributes.builder()
   *    .a(String | null) // nullable {@link CheckForNullAttributes#a() a}
   *    .b(Set&amp;lt;String&amp;gt; | null) // nullable {@link CheckForNullAttributes#b() b}
   *    .build();
   * </pre>
   * @return A new ImmutableCheckForNullAttributes builder
   */
  public static ImmutableCheckForNullAttributes.Builder builder() {
    return new ImmutableCheckForNullAttributes.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableCheckForNullAttributes ImmutableCheckForNullAttributes}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "CheckForNullAttributes", generator = "Immutables")
  @NotThreadSafe
  public static final class Builder {
    private @Nullable String a;
    private ImmutableSet.Builder<String> b = null;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code CheckForNullAttributes} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * Collection elements and entries will be added, not replaced.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder from(CheckForNullAttributes instance) {
      Objects.requireNonNull(instance, "instance");
      @CheckForNull String aValue = instance.a();
      if (aValue != null) {
        a(aValue);
      }
      @CheckForNull Set<String> bValue = instance.b();
      if (bValue != null) {
        addAllB(bValue);
      }
      return this;
    }

    /**
     * Initializes the value for the {@link CheckForNullAttributes#a() a} attribute.
     * @param a The value for a (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder a(@CheckForNull String a) {
      this.a = a;
      return this;
    }

    /**
     * Adds one element to {@link CheckForNullAttributes#b() b} set.
     * @param element A b element
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addB(String element) {
      if (this.b == null) {
        this.b = ImmutableSet.builder();
      }
      this.b.add(element);
      return this;
    }

    /**
     * Adds elements to {@link CheckForNullAttributes#b() b} set.
     * @param elements An array of b elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addB(String... elements) {
      if (this.b == null) {
        this.b = ImmutableSet.builder();
      }
      this.b.add(elements);
      return this;
    }


    /**
     * Sets or replaces all elements for {@link CheckForNullAttributes#b() b} set.
     * @param elements An iterable of b elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder b(@CheckForNull Iterable<String> elements) {
      if (elements == null) {
        this.b = null;
        return this;
      }
      this.b = ImmutableSet.builder();
      return addAllB(elements);
    }

    /**
     * Adds elements to {@link CheckForNullAttributes#b() b} set.
     * @param elements An iterable of b elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addAllB(Iterable<String> elements) {
      Objects.requireNonNull(elements, "b element");
      if (this.b == null) {
        this.b = ImmutableSet.builder();
      }
      this.b.addAll(elements);
      return this;
    }

    /**
     * Builds a new {@link ImmutableCheckForNullAttributes ImmutableCheckForNullAttributes}.
     * @return An immutable instance of CheckForNullAttributes
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableCheckForNullAttributes build() {
      return new ImmutableCheckForNullAttributes(a, b == null ? null : b.build());
    }
  }
}
