package org.immutables.fixture;

import com.google.common.base.MoreObjects;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link AbstractToStringHashCode.CustomEquals}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableCustomEquals.builder()}.
 */
@Generated(from = "AbstractToStringHashCode.CustomEquals", generator = "Immutables")
@SuppressWarnings({"all"})
@ParametersAreNonnullByDefault
@javax.annotation.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
@CheckReturnValue
final class ImmutableCustomEquals extends AbstractToStringHashCode.CustomEquals {
  private final int a;

  private ImmutableCustomEquals(int a) {
    this.a = a;
  }

  /**
   * @return The value of the {@code a} attribute
   */
  @Override
  int a() {
    return a;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link AbstractToStringHashCode.CustomEquals#a() a} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for a
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableCustomEquals withA(int value) {
    if (this.a == value) return this;
    return new ImmutableCustomEquals(value);
  }

  /**
   * Prints the immutable value {@code CustomEquals} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return MoreObjects.toStringHelper("CustomEquals")
        .omitNullValues()
        .add("a", a)
        .toString();
  }

  /**
   * Creates an immutable copy of a {@link AbstractToStringHashCode.CustomEquals} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable CustomEquals instance
   */
  public static ImmutableCustomEquals copyOf(AbstractToStringHashCode.CustomEquals instance) {
    if (instance instanceof ImmutableCustomEquals) {
      return (ImmutableCustomEquals) instance;
    }
    return ImmutableCustomEquals.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableCustomEquals ImmutableCustomEquals}.
   * <pre>
   * ImmutableCustomEquals.builder()
   *    .a(int) // required {@link AbstractToStringHashCode.CustomEquals#a() a}
   *    .build();
   * </pre>
   * @return A new ImmutableCustomEquals builder
   */
  public static ImmutableCustomEquals.Builder builder() {
    return new ImmutableCustomEquals.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableCustomEquals ImmutableCustomEquals}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "AbstractToStringHashCode.CustomEquals", generator = "Immutables")
  @NotThreadSafe
  public static final class Builder {
    private static final long INIT_BIT_A = 0x1L;
    private long initBits = 0x1L;

    private int a;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code CustomEquals} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder from(AbstractToStringHashCode.CustomEquals instance) {
      Objects.requireNonNull(instance, "instance");
      a(instance.a());
      return this;
    }

    /**
     * Initializes the value for the {@link AbstractToStringHashCode.CustomEquals#a() a} attribute.
     * @param a The value for a 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder a(int a) {
      this.a = a;
      initBits &= ~INIT_BIT_A;
      return this;
    }

    /**
     * Builds a new {@link ImmutableCustomEquals ImmutableCustomEquals}.
     * @return An immutable instance of CustomEquals
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableCustomEquals build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new ImmutableCustomEquals(a);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_A) != 0) attributes.add("a");
      return "Cannot build CustomEquals, some of required attributes are not set " + attributes;
    }
  }
}
