package org.immutables.fixture;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.errorprone.annotations.Var;
import java.util.List;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link DerivedNotInConstructor}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableDerivedNotInConstructor.builder()}.
 * Use the static factory method to create immutable instances:
 * {@code ImmutableDerivedNotInConstructor.of()}.
 */
@Generated(from = "DerivedNotInConstructor", generator = "Immutables")
@SuppressWarnings({"all"})
@ParametersAreNonnullByDefault
@javax.annotation.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
@CheckReturnValue
public final class ImmutableDerivedNotInConstructor extends DerivedNotInConstructor {
  private final ImmutableList<String> items;
  private transient final int totalLength;

  private ImmutableDerivedNotInConstructor(Iterable<String> items) {
    this.items = ImmutableList.copyOf(items);
    this.totalLength = super.totalLength();
  }

  private ImmutableDerivedNotInConstructor(
      ImmutableDerivedNotInConstructor original,
      ImmutableList<String> items) {
    this.items = items;
    this.totalLength = super.totalLength();
  }

  /**
   * @return The value of the {@code items} attribute
   */
  @Override
  public ImmutableList<String> items() {
    return items;
  }

  /**
   * @return The computed-at-construction value of the {@code totalLength} attribute
   */
  @Override
  public int totalLength() {
    return totalLength;
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link DerivedNotInConstructor#items() items}.
   * @param elements The elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableDerivedNotInConstructor withItems(String... elements) {
    ImmutableList<String> newValue = ImmutableList.copyOf(elements);
    return new ImmutableDerivedNotInConstructor(this, newValue);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link DerivedNotInConstructor#items() items}.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param elements An iterable of items elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableDerivedNotInConstructor withItems(Iterable<String> elements) {
    if (this.items == elements) return this;
    ImmutableList<String> newValue = ImmutableList.copyOf(elements);
    return new ImmutableDerivedNotInConstructor(this, newValue);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableDerivedNotInConstructor} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableDerivedNotInConstructor
        && equalTo(0, (ImmutableDerivedNotInConstructor) another);
  }

  private boolean equalTo(int synthetic, ImmutableDerivedNotInConstructor another) {
    return items.equals(another.items)
        && totalLength == another.totalLength;
  }

  /**
   * Computes a hash code from attributes: {@code items}, {@code totalLength}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    @Var int h = 5381;
    h += (h << 5) + items.hashCode();
    h += (h << 5) + totalLength;
    return h;
  }

  /**
   * Prints the immutable value {@code DerivedNotInConstructor} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return MoreObjects.toStringHelper("DerivedNotInConstructor")
        .omitNullValues()
        .add("items", items)
        .add("totalLength", totalLength)
        .toString();
  }

  /**
   * Construct a new immutable {@code DerivedNotInConstructor} instance.
   * @param items The value for the {@code items} attribute
   * @return An immutable DerivedNotInConstructor instance
   */
  public static ImmutableDerivedNotInConstructor of(List<String> items) {
    return of((Iterable<String>) items);
  }

  /**
   * Construct a new immutable {@code DerivedNotInConstructor} instance.
   * @param items The value for the {@code items} attribute
   * @return An immutable DerivedNotInConstructor instance
   */
  public static ImmutableDerivedNotInConstructor of(Iterable<String> items) {
    return new ImmutableDerivedNotInConstructor(items);
  }

  /**
   * Creates an immutable copy of a {@link DerivedNotInConstructor} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable DerivedNotInConstructor instance
   */
  public static ImmutableDerivedNotInConstructor copyOf(DerivedNotInConstructor instance) {
    if (instance instanceof ImmutableDerivedNotInConstructor) {
      return (ImmutableDerivedNotInConstructor) instance;
    }
    return ImmutableDerivedNotInConstructor.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableDerivedNotInConstructor ImmutableDerivedNotInConstructor}.
   * <pre>
   * ImmutableDerivedNotInConstructor.builder()
   *    .addItems|addAllItems(String) // {@link DerivedNotInConstructor#items() items} elements
   *    .build();
   * </pre>
   * @return A new ImmutableDerivedNotInConstructor builder
   */
  public static ImmutableDerivedNotInConstructor.Builder builder() {
    return new ImmutableDerivedNotInConstructor.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableDerivedNotInConstructor ImmutableDerivedNotInConstructor}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "DerivedNotInConstructor", generator = "Immutables")
  @NotThreadSafe
  public static final class Builder {
    private ImmutableList.Builder<String> items = ImmutableList.builder();

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code DerivedNotInConstructor} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * Collection elements and entries will be added, not replaced.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder from(DerivedNotInConstructor instance) {
      Objects.requireNonNull(instance, "instance");
      addAllItems(instance.items());
      return this;
    }

    /**
     * Adds one element to {@link DerivedNotInConstructor#items() items} list.
     * @param element A items element
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addItems(String element) {
      this.items.add(element);
      return this;
    }

    /**
     * Adds elements to {@link DerivedNotInConstructor#items() items} list.
     * @param elements An array of items elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addItems(String... elements) {
      this.items.add(elements);
      return this;
    }


    /**
     * Sets or replaces all elements for {@link DerivedNotInConstructor#items() items} list.
     * @param elements An iterable of items elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder items(Iterable<String> elements) {
      this.items = ImmutableList.builder();
      return addAllItems(elements);
    }

    /**
     * Adds elements to {@link DerivedNotInConstructor#items() items} list.
     * @param elements An iterable of items elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addAllItems(Iterable<String> elements) {
      this.items.addAll(elements);
      return this;
    }

    /**
     * Builds a new {@link ImmutableDerivedNotInConstructor ImmutableDerivedNotInConstructor}.
     * @return An immutable instance of DerivedNotInConstructor
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableDerivedNotInConstructor build() {
      return new ImmutableDerivedNotInConstructor(null, items.build());
    }
  }
}
