package org.immutables.fixture;

import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.errorprone.annotations.Var;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link EntityWithMap}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableEntityWithMap.builder()}.
 */
@Generated(from = "EntityWithMap", generator = "Immutables")
@SuppressWarnings({"all"})
@ParametersAreNonnullByDefault
@javax.annotation.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
@CheckReturnValue
public final class ImmutableEntityWithMap implements EntityWithMap {
  private final Map<String, String> properties;

  private ImmutableEntityWithMap(Map<String, String> properties) {
    this.properties = properties;
  }

  /**
   * @return The value of the {@code properties} attribute
   */
  @Override
  public Map<String, String> properties() {
    return properties;
  }

  /**
   * Copy the current immutable object by replacing the {@link EntityWithMap#properties() properties} map with the specified map.
   * Nulls are not permitted as keys or values.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param entries The entries to be added to the properties map
   * @return A modified copy of {@code this} object
   */
  public final ImmutableEntityWithMap withProperties(Map<String, ? extends String> entries) {
    if (this.properties == entries) return this;
    Map<String, String> newValue = createUnmodifiableMap(true, false, entries);
    return new ImmutableEntityWithMap(newValue);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableEntityWithMap} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableEntityWithMap
        && equalTo(0, (ImmutableEntityWithMap) another);
  }

  private boolean equalTo(int synthetic, ImmutableEntityWithMap another) {
    return properties.equals(another.properties);
  }

  /**
   * Computes a hash code from attributes: {@code properties}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    @Var int h = 5381;
    h += (h << 5) + properties.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code EntityWithMap} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "EntityWithMap{"
        + "properties=" + properties
        + "}";
  }

  /**
   * Creates an immutable copy of a {@link EntityWithMap} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable EntityWithMap instance
   */
  public static ImmutableEntityWithMap copyOf(EntityWithMap instance) {
    if (instance instanceof ImmutableEntityWithMap) {
      return (ImmutableEntityWithMap) instance;
    }
    return ImmutableEntityWithMap.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableEntityWithMap ImmutableEntityWithMap}.
   * <pre>
   * ImmutableEntityWithMap.builder()
   *    .putProperties|putAllProperties(String =&gt; String) // {@link EntityWithMap#properties() properties} mappings
   *    .build();
   * </pre>
   * @return A new ImmutableEntityWithMap builder
   */
  public static ImmutableEntityWithMap.Builder builder() {
    return new ImmutableEntityWithMap.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableEntityWithMap ImmutableEntityWithMap}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "EntityWithMap", generator = "Immutables")
  @NotThreadSafe
  public static final class Builder {
    private Map<String, String> properties = new LinkedHashMap<String, String>();

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code EntityWithMap} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * Collection elements and entries will be added, not replaced.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder from(EntityWithMap instance) {
      Objects.requireNonNull(instance, "instance");
      putAllProperties(instance.properties());
      return this;
    }

    /**
     * Put one entry to the {@link EntityWithMap#properties() properties} map.
     * @param key The key in the properties map
     * @param value The associated value in the properties map
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder putProperties(String key, String value) {
      this.properties.put(
          Objects.requireNonNull(key, "properties key"),
          value == null ? Objects.requireNonNull(value, "properties value for key: " + key) : value);
      return this;
    }

    /**
     * Put one entry to the {@link EntityWithMap#properties() properties} map. Nulls are not permitted
     * @param entry The key and value entry
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder putProperties(Map.Entry<String, ? extends String> entry) {
      String k = entry.getKey();
      String v = entry.getValue();
      this.properties.put(
          Objects.requireNonNull(k, "properties key"),
          v == null ? Objects.requireNonNull(v, "properties value for key: " + k) : v);
      return this;
    }

    /**
     * Sets or replaces all mappings from the specified map as entries for the {@link EntityWithMap#properties() properties} map. Nulls are not permitted
     * @param entries The entries that will be added to the properties map
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder properties(Map<String, ? extends String> entries) {
      this.properties.clear();
      return putAllProperties(entries);
    }

    /**
     * Put all mappings from the specified map as entries to {@link EntityWithMap#properties() properties} map. Nulls are not permitted
     * @param entries The entries that will be added to the properties map
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder putAllProperties(Map<String, ? extends String> entries) {
      for (Map.Entry<String, ? extends String> e : entries.entrySet()) {
        String k = e.getKey();
        String v = e.getValue();
        this.properties.put(
            Objects.requireNonNull(k, "properties key"),
            v == null ? Objects.requireNonNull(v, "properties value for key: " + k) : v);
      }
      return this;
    }

    /**
     * Builds a new {@link ImmutableEntityWithMap ImmutableEntityWithMap}.
     * @return An immutable instance of EntityWithMap
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableEntityWithMap build() {
      return new ImmutableEntityWithMap(createUnmodifiableMap(false, false, properties));
    }
  }

  private static <K, V> Map<K, V> createUnmodifiableMap(boolean checkNulls, boolean skipNulls, Map<? extends K, ? extends V> map) {
    switch (map.size()) {
    case 0: return Collections.emptyMap();
    case 1: {
      Map.Entry<? extends K, ? extends V> e = map.entrySet().iterator().next();
      K k = e.getKey();
      V v = e.getValue();
      if (checkNulls) {
        Objects.requireNonNull(k, "key");
        if (v == null) Objects.requireNonNull(v, "value for key: " + k);
      }
      if (skipNulls && (k == null || v == null)) {
        return Collections.emptyMap();
      }
      return Collections.singletonMap(k, v);
    }
    default: {
      Map<K, V> linkedMap = new LinkedHashMap<>(map.size());
      if (skipNulls || checkNulls) {
        for (Map.Entry<? extends K, ? extends V> e : map.entrySet()) {
          K k = e.getKey();
          V v = e.getValue();
          if (skipNulls) {
            if (k == null || v == null) continue;
          } else if (checkNulls) {
            Objects.requireNonNull(k, "key");
            if (v == null) Objects.requireNonNull(v, "value for key: " + k);
          }
          linkedMap.put(k, v);
        }
      } else {
        linkedMap.putAll(map);
      }
      return Collections.unmodifiableMap(linkedMap);
    }
    }
  }
}
