package org.immutables.fixture;

import com.google.common.base.MoreObjects;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.errorprone.annotations.Var;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link InheritConstructorParameter.ExtendsIt}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableExtendsIt.builder()}.
 * Use the static factory method to create immutable instances:
 * {@code ImmutableExtendsIt.of()}.
 */
@Generated(from = "InheritConstructorParameter.ExtendsIt", generator = "Immutables")
@SuppressWarnings({"all"})
@ParametersAreNonnullByDefault
@javax.annotation.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
@CheckReturnValue
public final class ImmutableExtendsIt extends InheritConstructorParameter.ExtendsIt {
  private final int i;

  private ImmutableExtendsIt(int i) {
    this.i = i;
  }

  /**
   * @return The value of the {@code i} attribute
   */
  @Override
  int i() {
    return i;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link InheritConstructorParameter.ExtendsIt#i() i} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for i
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableExtendsIt withI(int value) {
    if (this.i == value) return this;
    return new ImmutableExtendsIt(value);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableExtendsIt} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableExtendsIt
        && equalTo(0, (ImmutableExtendsIt) another);
  }

  private boolean equalTo(int synthetic, ImmutableExtendsIt another) {
    return i == another.i;
  }

  /**
   * Computes a hash code from attributes: {@code i}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    @Var int h = 5381;
    h += (h << 5) + i;
    return h;
  }

  /**
   * Prints the immutable value {@code ExtendsIt} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return MoreObjects.toStringHelper("ExtendsIt")
        .omitNullValues()
        .add("i", i)
        .toString();
  }

  /**
   * Construct a new immutable {@code ExtendsIt} instance.
   * @param i The value for the {@code i} attribute
   * @return An immutable ExtendsIt instance
   */
  public static ImmutableExtendsIt of(int i) {
    return new ImmutableExtendsIt(i);
  }

  /**
   * Creates an immutable copy of a {@link InheritConstructorParameter.ExtendsIt} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable ExtendsIt instance
   */
  public static ImmutableExtendsIt copyOf(InheritConstructorParameter.ExtendsIt instance) {
    if (instance instanceof ImmutableExtendsIt) {
      return (ImmutableExtendsIt) instance;
    }
    return ImmutableExtendsIt.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableExtendsIt ImmutableExtendsIt}.
   * <pre>
   * ImmutableExtendsIt.builder()
   *    .i(int) // required {@link InheritConstructorParameter.ExtendsIt#i() i}
   *    .build();
   * </pre>
   * @return A new ImmutableExtendsIt builder
   */
  public static ImmutableExtendsIt.Builder builder() {
    return new ImmutableExtendsIt.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableExtendsIt ImmutableExtendsIt}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "InheritConstructorParameter.ExtendsIt", generator = "Immutables")
  @NotThreadSafe
  public static final class Builder {
    private static final long INIT_BIT_I = 0x1L;
    private long initBits = 0x1L;

    private int i;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code org.immutables.fixture.InheritConstructorParameter.HasParam} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder from(InheritConstructorParameter.HasParam instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    /**
     * Fill a builder with attribute values from the provided {@code org.immutables.fixture.InheritConstructorParameter.ExtendsIt} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder from(InheritConstructorParameter.ExtendsIt instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    private void from(Object object) {
      if (object instanceof InheritConstructorParameter.HasParam) {
        InheritConstructorParameter.HasParam instance = (InheritConstructorParameter.HasParam) object;
        i(instance.i());
      }
    }

    /**
     * Initializes the value for the {@link InheritConstructorParameter.ExtendsIt#i() i} attribute.
     * @param i The value for i 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder i(int i) {
      this.i = i;
      initBits &= ~INIT_BIT_I;
      return this;
    }

    /**
     * Builds a new {@link ImmutableExtendsIt ImmutableExtendsIt}.
     * @return An immutable instance of ExtendsIt
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableExtendsIt build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new ImmutableExtendsIt(i);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_I) != 0) attributes.add("i");
      return "Cannot build ExtendsIt, some of required attributes are not set " + attributes;
    }
  }
}
