package org.immutables.fixture;

import com.google.common.base.MoreObjects;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.errorprone.annotations.Var;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link HasNullable}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableHasNullable.builder()}.
 * Use the static factory method to create immutable instances:
 * {@code ImmutableHasNullable.of()}.
 * Use the static factory method to get the default singleton instance:
 * {@code ImmutableHasNullable.of()}.
 */
@Generated(from = "HasNullable", generator = "Immutables")
@SuppressWarnings({"all"})
@ParametersAreNonnullByDefault
@javax.annotation.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
@CheckReturnValue
public final class ImmutableHasNullable extends HasNullable {
  private final @Nullable Integer in;
  private final @Nullable String def;
  private transient final @Nullable String der;

  private ImmutableHasNullable() {
    this.in = null;
    this.def = initShim.def();
    this.der = initShim.der();
    this.initShim = null;
  }

  private ImmutableHasNullable(@Nullable Integer in) {
    this.in = in;
    this.def = initShim.def();
    this.der = initShim.der();
    this.initShim = null;
  }

  private ImmutableHasNullable(ImmutableHasNullable.Builder builder) {
    this.in = builder.in;
    if (builder.defIsSet()) {
      initShim.def(builder.def);
    }
    this.def = initShim.def();
    this.der = initShim.der();
    this.initShim = null;
  }

  private ImmutableHasNullable(@Nullable Integer in, @Nullable String def) {
    this.in = in;
    initShim.def(def);
    this.def = initShim.def();
    this.der = initShim.der();
    this.initShim = null;
  }

  private static final byte STAGE_INITIALIZING = -1;
  private static final byte STAGE_UNINITIALIZED = 0;
  private static final byte STAGE_INITIALIZED = 1;
  @SuppressWarnings("Immutable")
  private transient volatile InitShim initShim = new InitShim();

  @Generated(from = "HasNullable", generator = "Immutables")
  private final class InitShim {
    private byte defBuildStage = STAGE_UNINITIALIZED;
    private String def;

    String def() {
      if (defBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (defBuildStage == STAGE_UNINITIALIZED) {
        defBuildStage = STAGE_INITIALIZING;
        this.def = ImmutableHasNullable.super.def();
        defBuildStage = STAGE_INITIALIZED;
      }
      return this.def;
    }

    void def(String def) {
      this.def = def;
      defBuildStage = STAGE_INITIALIZED;
    }

    private byte derBuildStage = STAGE_UNINITIALIZED;
    private String der;

    String der() {
      if (derBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (derBuildStage == STAGE_UNINITIALIZED) {
        derBuildStage = STAGE_INITIALIZING;
        this.der = ImmutableHasNullable.super.der();
        derBuildStage = STAGE_INITIALIZED;
      }
      return this.der;
    }

    private String formatInitCycleMessage() {
      List<String> attributes = new ArrayList<>();
      if (defBuildStage == STAGE_INITIALIZING) attributes.add("def");
      if (derBuildStage == STAGE_INITIALIZING) attributes.add("der");
      return "Cannot build HasNullable, attribute initializers form cycle " + attributes;
    }
  }

  /**
   * @return The value of the {@code in} attribute
   */
  @Override
  public @Nullable Integer in() {
    return in;
  }

  /**
   * @return The value of the {@code def} attribute
   */
  @Override
  public @Nullable String def() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.def()
        : this.def;
  }

  /**
   * @return The computed-at-construction value of the {@code der} attribute
   */
  @Override
  public @Nullable String der() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.der()
        : this.der;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link HasNullable#in() in} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for in (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableHasNullable withIn(@Nullable Integer value) {
    if (Objects.equals(this.in, value)) return this;
    return validate(new ImmutableHasNullable(value, this.def));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link HasNullable#def() def} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for def (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableHasNullable withDef(@Nullable String value) {
    if (Objects.equals(this.def, value)) return this;
    return validate(new ImmutableHasNullable(this.in, value));
  }

  /**
   * This instance is equal to all instances of {@code ImmutableHasNullable} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableHasNullable
        && equalTo(0, (ImmutableHasNullable) another);
  }

  private boolean equalTo(int synthetic, ImmutableHasNullable another) {
    return Objects.equals(in, another.in)
        && Objects.equals(def, another.def)
        && Objects.equals(der, another.der);
  }

  /**
   * Computes a hash code from attributes: {@code in}, {@code def}, {@code der}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    @Var int h = 5381;
    h += (h << 5) + Objects.hashCode(in);
    h += (h << 5) + Objects.hashCode(def);
    h += (h << 5) + Objects.hashCode(der);
    return h;
  }

  /**
   * Prints the immutable value {@code HasNullable} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return MoreObjects.toStringHelper("HasNullable")
        .omitNullValues()
        .add("in", in)
        .add("def", def)
        .add("der", der)
        .toString();
  }

  private static final ImmutableHasNullable INSTANCE = validate(new ImmutableHasNullable());

  /**
   * Returns the default immutable singleton value of {@code HasNullable}
   * @return An immutable instance of HasNullable
   */
  public static ImmutableHasNullable of() {
    return INSTANCE;
  }

  /**
   * Construct a new immutable {@code HasNullable} instance.
   * @param in The value for the {@code in} attribute
   * @return An immutable HasNullable instance
   */
  public static ImmutableHasNullable of(@Nullable Integer in) {
    return validate(new ImmutableHasNullable(in));
  }

  private static ImmutableHasNullable validate(ImmutableHasNullable instance) {
    return INSTANCE != null && INSTANCE.equalTo(0, instance) ? INSTANCE : instance;
  }

  /**
   * Creates an immutable copy of a {@link HasNullable} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable HasNullable instance
   */
  public static ImmutableHasNullable copyOf(HasNullable instance) {
    if (instance instanceof ImmutableHasNullable) {
      return (ImmutableHasNullable) instance;
    }
    return ImmutableHasNullable.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableHasNullable ImmutableHasNullable}.
   * <pre>
   * ImmutableHasNullable.builder()
   *    .in(Integer | null) // nullable {@link HasNullable#in() in}
   *    .def(String | null) // nullable {@link HasNullable#def() def}
   *    .build();
   * </pre>
   * @return A new ImmutableHasNullable builder
   */
  public static ImmutableHasNullable.Builder builder() {
    return new ImmutableHasNullable.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableHasNullable ImmutableHasNullable}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "HasNullable", generator = "Immutables")
  @NotThreadSafe
  public static final class Builder {
    private static final long OPT_BIT_DEF = 0x1L;
    private long optBits;

    private @Nullable Integer in;
    private @Nullable String def;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code HasNullable} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder from(HasNullable instance) {
      Objects.requireNonNull(instance, "instance");
      @Nullable Integer inValue = instance.in();
      if (inValue != null) {
        in(inValue);
      }
      @Nullable String defValue = instance.def();
      if (defValue != null) {
        def(defValue);
      }
      return this;
    }

    /**
     * Initializes the value for the {@link HasNullable#in() in} attribute.
     * @param in The value for in (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder in(@Nullable Integer in) {
      this.in = in;
      return this;
    }

    /**
     * Initializes the value for the {@link HasNullable#def() def} attribute.
     * <p><em>If not set, this attribute will have a default value as returned by the initializer of {@link HasNullable#def() def}.</em>
     * @param def The value for def (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder def(@Nullable String def) {
      this.def = def;
      optBits |= OPT_BIT_DEF;
      return this;
    }

    /**
     * Builds a new {@link ImmutableHasNullable ImmutableHasNullable}.
     * @return An immutable instance of HasNullable
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableHasNullable build() {
      return ImmutableHasNullable.validate(new ImmutableHasNullable(this));
    }

    private boolean defIsSet() {
      return (optBits & OPT_BIT_DEF) != 0;
    }
  }
}
