package org.immutables.fixture;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableMap;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.errorprone.annotations.Var;
import java.util.Arrays;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link HasTypeAnnotation}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableHasTypeAnnotation.builder()}.
 */
@Generated(from = "HasTypeAnnotation", generator = "Immutables")
@SuppressWarnings({"all"})
@ParametersAreNonnullByDefault
@javax.annotation.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
@CheckReturnValue
public final class ImmutableHasTypeAnnotation extends HasTypeAnnotation {
  private final @Nullable java.lang.@TypeA @TypeB String str;
  private final @Nullable byte[] bte;
  private final @Nullable ImmutableMap<String, String> map;

  private ImmutableHasTypeAnnotation(
      @Nullable java.lang.@TypeA @TypeB String str,
      @Nullable byte[] bte,
      @Nullable ImmutableMap<String, String> map) {
    this.str = str;
    this.bte = bte;
    this.map = map;
  }

  /**
   * @return The value of the {@code str} attribute
   */
  @Override
  public @Nullable java.lang.@TypeA @TypeB String str() {
    return str;
  }

  /**
   * @return A cloned {@code bte} array
   */
  @Override
  public @Nullable byte[] bte() {
    return bte;
  }

  /**
   * @return The value of the {@code map} attribute
   */
  @Override
  public @Nullable ImmutableMap<String, String> map() {
    return map;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link HasTypeAnnotation#str() str} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for str (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableHasTypeAnnotation withStr(@Nullable java.lang.@TypeA @TypeB String value) {
    if (Objects.equals(this.str, value)) return this;
    return new ImmutableHasTypeAnnotation(value, this.bte, this.map);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link HasTypeAnnotation#bte() bte}.
   * The array is cloned before being saved as attribute values.
   * @param elements The non-null elements for bte
   * @return A modified copy of {@code this} object
   */
  public final ImmutableHasTypeAnnotation withBte(@Nullable byte... elements) {
    @Nullable byte[] newValue = elements == null ? null : elements.clone();
    return new ImmutableHasTypeAnnotation(this.str, newValue, this.map);
  }

  /**
   * Copy the current immutable object by replacing the {@link HasTypeAnnotation#map() map} map with the specified map.
   * Nulls are not permitted as keys or values.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param entries The entries to be added to the map map
   * @return A modified copy of {@code this} object
   */
  public final ImmutableHasTypeAnnotation withMap(@Nullable java.util.Map<String, ? extends String> entries) {
    if (this.map == entries) return this;
    @Nullable ImmutableMap<String, String> newValue = entries == null ? null : ImmutableMap.copyOf(entries);
    return new ImmutableHasTypeAnnotation(this.str, this.bte, newValue);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableHasTypeAnnotation} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableHasTypeAnnotation
        && equalTo(0, (ImmutableHasTypeAnnotation) another);
  }

  private boolean equalTo(int synthetic, ImmutableHasTypeAnnotation another) {
    return Objects.equals(str, another.str)
        && Arrays.equals(bte, another.bte)
        && Objects.equals(map, another.map);
  }

  /**
   * Computes a hash code from attributes: {@code str}, {@code bte}, {@code map}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    @Var int h = 5381;
    h += (h << 5) + Objects.hashCode(str);
    h += (h << 5) + Arrays.hashCode(bte);
    h += (h << 5) + Objects.hashCode(map);
    return h;
  }

  /**
   * Prints the immutable value {@code HasTypeAnnotation} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return MoreObjects.toStringHelper("HasTypeAnnotation")
        .omitNullValues()
        .add("str", str)
        .add("bte", Arrays.toString(bte))
        .add("map", map)
        .toString();
  }

  /**
   * Creates an immutable copy of a {@link HasTypeAnnotation} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable HasTypeAnnotation instance
   */
  public static ImmutableHasTypeAnnotation copyOf(HasTypeAnnotation instance) {
    if (instance instanceof ImmutableHasTypeAnnotation) {
      return (ImmutableHasTypeAnnotation) instance;
    }
    return ImmutableHasTypeAnnotation.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableHasTypeAnnotation ImmutableHasTypeAnnotation}.
   * <pre>
   * ImmutableHasTypeAnnotation.builder()
   *    .str(@org.immutables.fixture.TypeA @org.immutables.fixture.TypeB String | null) // nullable {@link HasTypeAnnotation#str() str}
   *    .bte(byte[] | null) // nullable {@link HasTypeAnnotation#bte() bte}
   *    .map(@org.immutables.fixture.TypeA @org.immutables.fixture.TypeB Map&amp;lt;String, String&amp;gt; | null) // nullable {@link HasTypeAnnotation#map() map}
   *    .build();
   * </pre>
   * @return A new ImmutableHasTypeAnnotation builder
   */
  public static ImmutableHasTypeAnnotation.Builder builder() {
    return new ImmutableHasTypeAnnotation.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableHasTypeAnnotation ImmutableHasTypeAnnotation}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "HasTypeAnnotation", generator = "Immutables")
  @NotThreadSafe
  public static final class Builder {
    private @Nullable java.lang.@TypeA @TypeB String str;
    private @Nullable byte[] bte;
    private ImmutableMap.Builder<String, String> map = null;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code HasTypeAnnotation} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * Collection elements and entries will be added, not replaced.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder from(HasTypeAnnotation instance) {
      Objects.requireNonNull(instance, "instance");
      @Nullable java.lang.@TypeA @TypeB String strValue = instance.str();
      if (strValue != null) {
        str(strValue);
      }
      @Nullable byte[] bteValue = instance.bte();
      if (bteValue != null) {
        bte(bteValue);
      }
      @Nullable java.util.@TypeA @TypeB Map<String, String> mapValue = instance.map();
      if (mapValue != null) {
        putAllMap(mapValue);
      }
      return this;
    }

    /**
     * Initializes the value for the {@link HasTypeAnnotation#str() str} attribute.
     * @param str The value for str (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder str(@Nullable java.lang.@TypeA @TypeB String str) {
      this.str = str;
      return this;
    }

    /**
     * Initializes the value for the {@link HasTypeAnnotation#bte() bte} attribute.
     * @param bte The elements for bte
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder bte(byte... bte) {
      this.bte = bte;
      return this;
    }

    /**
     * Put one entry to the {@link HasTypeAnnotation#map() map} map.
     * @param key The key in the map map
     * @param value The associated value in the map map
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder putMap(String key, String value) {
      if (this.map == null) {
        this.map = ImmutableMap.builder();
      }
      this.map.put(key, value);
      return this;
    }

    /**
     * Put one entry to the {@link HasTypeAnnotation#map() map} map. Nulls are not permitted
     * @param entry The key and value entry
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder putMap(java.util.Map.Entry<String, ? extends String> entry) {
      if (this.map == null) {
        this.map = ImmutableMap.builder();
      }
      this.map.put(entry);
      return this;
    }

    /**
     * Sets or replaces all mappings from the specified map as entries for the {@link HasTypeAnnotation#map() map} map. Nulls are not permitted as keys or values, but parameter itself can be null
     * @param entries The entries that will be added to the map map
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder map(@Nullable java.util.Map<String, ? extends String> entries) {
      if (entries == null) {
        this.map = null;
        return this;
      }
      this.map = ImmutableMap.builder();
      return putAllMap(entries);
    }

    /**
     * Put all mappings from the specified map as entries to {@link HasTypeAnnotation#map() map} map. Nulls are not permitted
     * @param entries The entries that will be added to the map map
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder putAllMap(java.util.Map<String, ? extends String> entries) {
      if (this.map == null) {
        this.map = ImmutableMap.builder();
      }
      this.map.putAll(entries);
      return this;
    }

    /**
     * Builds a new {@link ImmutableHasTypeAnnotation ImmutableHasTypeAnnotation}.
     * @return An immutable instance of HasTypeAnnotation
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableHasTypeAnnotation build() {
      return new ImmutableHasTypeAnnotation(str, bte, map == null ? null : map.build());
    }
  }
}
