package org.immutables.fixture;

import com.google.common.base.MoreObjects;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.errorprone.annotations.Var;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

/**
 * {@code ImmutableMultipleChecks} contains immutable implementation classes generated from
 * abstract value types defined as nested inside {@link MultipleChecks}.
 * @see ImmutableMultipleChecks.C
 */
@Generated(from = "MultipleChecks", generator = "Immutables")
@SuppressWarnings({"all"})
@ParametersAreNonnullByDefault
@javax.annotation.Generated("org.immutables.processor.ProxyProcessor")
public final class ImmutableMultipleChecks {
  private ImmutableMultipleChecks() {}

  /**
   * Immutable implementation of {@link MultipleChecks.C}.
   * <p>
   * Use the builder to create immutable instances:
   * {@code ImmutableMultipleChecks.C.builder()}.
   */
  @Generated(from = "MultipleChecks.C", generator = "Immutables")
  @Immutable
  @CheckReturnValue
  public static final class C implements MultipleChecks.C {
    private final int a;
    private final int b;

    private C(int a, int b) {
      this.a = a;
      this.b = b;
    }

    /**
     * @return The value of the {@code a} attribute
     */
    @Override
    public int a() {
      return a;
    }

    /**
     * @return The value of the {@code b} attribute
     */
    @Override
    public int b() {
      return b;
    }

    /**
     * Copy the current immutable object by setting a value for the {@link MultipleChecks.C#a() a} attribute.
     * A value equality check is used to prevent copying of the same value by returning {@code this}.
     * @param value A new value for a
     * @return A modified copy of the {@code this} object
     */
    public final ImmutableMultipleChecks.C withA(int value) {
      if (this.a == value) return this;
      return validate(new ImmutableMultipleChecks.C(value, this.b));
    }

    /**
     * Copy the current immutable object by setting a value for the {@link MultipleChecks.C#b() b} attribute.
     * A value equality check is used to prevent copying of the same value by returning {@code this}.
     * @param value A new value for b
     * @return A modified copy of the {@code this} object
     */
    public final ImmutableMultipleChecks.C withB(int value) {
      if (this.b == value) return this;
      return validate(new ImmutableMultipleChecks.C(this.a, value));
    }

    /**
     * This instance is equal to all instances of {@code C} that have equal attribute values.
     * @return {@code true} if {@code this} is equal to {@code another} instance
     */
    @Override
    public boolean equals(@Nullable Object another) {
      if (this == another) return true;
      return another instanceof ImmutableMultipleChecks.C
          && equalTo(0, (ImmutableMultipleChecks.C) another);
    }

    private boolean equalTo(int synthetic, ImmutableMultipleChecks.C another) {
      return a == another.a
          && b == another.b;
    }

    /**
     * Computes a hash code from attributes: {@code a}, {@code b}.
     * @return hashCode value
     */
    @Override
    public int hashCode() {
      @Var int h = 5381;
      h += (h << 5) + a;
      h += (h << 5) + b;
      return h;
    }

    /**
     * Prints the immutable value {@code C} with attribute values.
     * @return A string representation of the value
     */
    @Override
    public String toString() {
      return MoreObjects.toStringHelper("C")
          .omitNullValues()
          .add("a", a)
          .add("b", b)
          .toString();
    }

    private static ImmutableMultipleChecks.C validate(ImmutableMultipleChecks.C instance) {
      instance.checkB();
      instance.checkA();
      return instance;
    }

    /**
     * Creates an immutable copy of a {@link MultipleChecks.C} value.
     * Uses accessors to get values to initialize the new immutable instance.
     * If an instance is already immutable, it is returned as is.
     * @param instance The instance to copy
     * @return A copied immutable C instance
     */
    public static ImmutableMultipleChecks.C copyOf(MultipleChecks.C instance) {
      if (instance instanceof ImmutableMultipleChecks.C) {
        return (ImmutableMultipleChecks.C) instance;
      }
      return ImmutableMultipleChecks.C.builder()
          .from(instance)
          .build();
    }

    /**
     * Creates a builder for {@link ImmutableMultipleChecks.C C}.
     * <pre>
     * ImmutableMultipleChecks.C.builder()
     *    .a(int) // required {@link MultipleChecks.C#a() a}
     *    .b(int) // required {@link MultipleChecks.C#b() b}
     *    .build();
     * </pre>
     * @return A new C builder
     */
    public static ImmutableMultipleChecks.C.Builder builder() {
      return new ImmutableMultipleChecks.C.Builder();
    }

    /**
     * Builds instances of type {@link ImmutableMultipleChecks.C C}.
     * Initialize attributes and then invoke the {@link #build()} method to create an
     * immutable instance.
     * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
     * but instead used immediately to create instances.</em>
     */
    @Generated(from = "MultipleChecks.C", generator = "Immutables")
    @NotThreadSafe
    public static final class Builder {
      private static final long INIT_BIT_A = 0x1L;
      private static final long INIT_BIT_B = 0x2L;
      private long initBits = 0x3L;

      private int a;
      private int b;

      private Builder() {
      }

      /**
       * Fill a builder with attribute values from the provided {@code org.immutables.fixture.MultipleChecks.A} instance.
       * @param instance The instance from which to copy values
       * @return {@code this} builder for use in a chained invocation
       */
      @CanIgnoreReturnValue 
      public final Builder from(MultipleChecks.A instance) {
        Objects.requireNonNull(instance, "instance");
        from((Object) instance);
        return this;
      }

      /**
       * Fill a builder with attribute values from the provided {@code org.immutables.fixture.MultipleChecks.B} instance.
       * @param instance The instance from which to copy values
       * @return {@code this} builder for use in a chained invocation
       */
      @CanIgnoreReturnValue 
      public final Builder from(MultipleChecks.B instance) {
        Objects.requireNonNull(instance, "instance");
        from((Object) instance);
        return this;
      }

      /**
       * Fill a builder with attribute values from the provided {@code org.immutables.fixture.MultipleChecks.C} instance.
       * @param instance The instance from which to copy values
       * @return {@code this} builder for use in a chained invocation
       */
      @CanIgnoreReturnValue 
      public final Builder from(MultipleChecks.C instance) {
        Objects.requireNonNull(instance, "instance");
        from((Object) instance);
        return this;
      }

      private void from(Object object) {
        @Var long bits = 0;
        if (object instanceof MultipleChecks.A) {
          MultipleChecks.A instance = (MultipleChecks.A) object;
          if ((bits & 0x1L) == 0) {
            a(instance.a());
            bits |= 0x1L;
          }
        }
        if (object instanceof MultipleChecks.B) {
          MultipleChecks.B instance = (MultipleChecks.B) object;
          if ((bits & 0x2L) == 0) {
            b(instance.b());
            bits |= 0x2L;
          }
        }
        if (object instanceof MultipleChecks.C) {
          MultipleChecks.C instance = (MultipleChecks.C) object;
          if ((bits & 0x1L) == 0) {
            a(instance.a());
            bits |= 0x1L;
          }
          if ((bits & 0x2L) == 0) {
            b(instance.b());
            bits |= 0x2L;
          }
        }
      }

      /**
       * Initializes the value for the {@link MultipleChecks.C#a() a} attribute.
       * @param a The value for a 
       * @return {@code this} builder for use in a chained invocation
       */
      @CanIgnoreReturnValue 
      public final Builder a(int a) {
        this.a = a;
        initBits &= ~INIT_BIT_A;
        return this;
      }

      /**
       * Initializes the value for the {@link MultipleChecks.C#b() b} attribute.
       * @param b The value for b 
       * @return {@code this} builder for use in a chained invocation
       */
      @CanIgnoreReturnValue 
      public final Builder b(int b) {
        this.b = b;
        initBits &= ~INIT_BIT_B;
        return this;
      }

      /**
       * Builds a new {@link ImmutableMultipleChecks.C C}.
       * @return An immutable instance of C
       * @throws java.lang.IllegalStateException if any required attributes are missing
       */
      public ImmutableMultipleChecks.C build() {
        if (initBits != 0) {
          throw new IllegalStateException(formatRequiredAttributesMessage());
        }
        return ImmutableMultipleChecks.C.validate(new ImmutableMultipleChecks.C(a, b));
      }

      private String formatRequiredAttributesMessage() {
        List<String> attributes = new ArrayList<>();
        if ((initBits & INIT_BIT_A) != 0) attributes.add("a");
        if ((initBits & INIT_BIT_B) != 0) attributes.add("b");
        return "Cannot build C, some of required attributes are not set " + attributes;
      }
    }
  }
}
