package org.immutables.fixture;

import com.google.common.base.MoreObjects;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.errorprone.annotations.Var;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link NewValueNamedWithCollission}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableNewValueNamedWithCollission.builder()}.
 */
@Generated(from = "NewValueNamedWithCollission", generator = "Immutables")
@SuppressWarnings({"all"})
@ParametersAreNonnullByDefault
@javax.annotation.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
@CheckReturnValue
public final class ImmutableNewValueNamedWithCollission
    implements NewValueNamedWithCollission {
  private final String newValue;
  private final String oldValue;

  private ImmutableNewValueNamedWithCollission(String newValue, String oldValue) {
    this.newValue = newValue;
    this.oldValue = oldValue;
  }

  /**
   * @return The value of the {@code newValue} attribute
   */
  @Override
  public String getNewValue() {
    return newValue;
  }

  /**
   * @return The value of the {@code oldValue} attribute
   */
  @Override
  public String getOldValue() {
    return oldValue;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link NewValueNamedWithCollission#getNewValue() newValue} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for newValue
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableNewValueNamedWithCollission withNewValue(String value) {
    String newValue = Objects.requireNonNull(value, "newValue");
    if (this.newValue.equals(newValue)) return this;
    return new ImmutableNewValueNamedWithCollission(newValue, this.oldValue);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link NewValueNamedWithCollission#getOldValue() oldValue} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for oldValue
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableNewValueNamedWithCollission withOldValue(String value) {
    String newValue = Objects.requireNonNull(value, "oldValue");
    if (this.oldValue.equals(newValue)) return this;
    return new ImmutableNewValueNamedWithCollission(this.newValue, newValue);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableNewValueNamedWithCollission} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableNewValueNamedWithCollission
        && equalTo(0, (ImmutableNewValueNamedWithCollission) another);
  }

  private boolean equalTo(int synthetic, ImmutableNewValueNamedWithCollission another) {
    return newValue.equals(another.newValue)
        && oldValue.equals(another.oldValue);
  }

  /**
   * Computes a hash code from attributes: {@code newValue}, {@code oldValue}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    @Var int h = 5381;
    h += (h << 5) + newValue.hashCode();
    h += (h << 5) + oldValue.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code NewValueNamedWithCollission} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return MoreObjects.toStringHelper("NewValueNamedWithCollission")
        .omitNullValues()
        .add("newValue", newValue)
        .add("oldValue", oldValue)
        .toString();
  }

  /**
   * Creates an immutable copy of a {@link NewValueNamedWithCollission} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable NewValueNamedWithCollission instance
   */
  public static ImmutableNewValueNamedWithCollission copyOf(NewValueNamedWithCollission instance) {
    if (instance instanceof ImmutableNewValueNamedWithCollission) {
      return (ImmutableNewValueNamedWithCollission) instance;
    }
    return ImmutableNewValueNamedWithCollission.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableNewValueNamedWithCollission ImmutableNewValueNamedWithCollission}.
   * <pre>
   * ImmutableNewValueNamedWithCollission.builder()
   *    .newValue(String) // required {@link NewValueNamedWithCollission#getNewValue() newValue}
   *    .oldValue(String) // required {@link NewValueNamedWithCollission#getOldValue() oldValue}
   *    .build();
   * </pre>
   * @return A new ImmutableNewValueNamedWithCollission builder
   */
  public static ImmutableNewValueNamedWithCollission.Builder builder() {
    return new ImmutableNewValueNamedWithCollission.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableNewValueNamedWithCollission ImmutableNewValueNamedWithCollission}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "NewValueNamedWithCollission", generator = "Immutables")
  @NotThreadSafe
  public static final class Builder {
    private static final long INIT_BIT_NEW_VALUE = 0x1L;
    private static final long INIT_BIT_OLD_VALUE = 0x2L;
    private long initBits = 0x3L;

    private @Nullable String newValue;
    private @Nullable String oldValue;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code NewValueNamedWithCollission} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder from(NewValueNamedWithCollission instance) {
      Objects.requireNonNull(instance, "instance");
      newValue(instance.getNewValue());
      oldValue(instance.getOldValue());
      return this;
    }

    /**
     * Initializes the value for the {@link NewValueNamedWithCollission#getNewValue() newValue} attribute.
     * @param newValue The value for newValue 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder newValue(String newValue) {
      this.newValue = Objects.requireNonNull(newValue, "newValue");
      initBits &= ~INIT_BIT_NEW_VALUE;
      return this;
    }

    /**
     * Initializes the value for the {@link NewValueNamedWithCollission#getOldValue() oldValue} attribute.
     * @param oldValue The value for oldValue 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder oldValue(String oldValue) {
      this.oldValue = Objects.requireNonNull(oldValue, "oldValue");
      initBits &= ~INIT_BIT_OLD_VALUE;
      return this;
    }

    /**
     * Builds a new {@link ImmutableNewValueNamedWithCollission ImmutableNewValueNamedWithCollission}.
     * @return An immutable instance of NewValueNamedWithCollission
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableNewValueNamedWithCollission build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new ImmutableNewValueNamedWithCollission(newValue, oldValue);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_NEW_VALUE) != 0) attributes.add("newValue");
      if ((initBits & INIT_BIT_OLD_VALUE) != 0) attributes.add("oldValue");
      return "Cannot build NewValueNamedWithCollission, some of required attributes are not set " + attributes;
    }
  }
}
