package org.immutables.fixture;

import com.google.common.base.MoreObjects;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.errorprone.annotations.Var;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link OptionalNonOptional}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableOptionalNonOptional.builder()}.
 */
@Generated(from = "OptionalNonOptional", generator = "Immutables")
@SuppressWarnings({"all"})
@ParametersAreNonnullByDefault
@javax.annotation.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
@CheckReturnValue
public final class ImmutableOptionalNonOptional extends OptionalNonOptional {
  private final Optional<Path> stubBinaryPath;
  private final com.google.common.base.Optional<? extends Path> stubBinaryPath2;
  private final @Nullable Optional<Path> stubBinaryPath3;

  private ImmutableOptionalNonOptional(ImmutableOptionalNonOptional.Builder builder) {
    this.stubBinaryPath2 = builder.stubBinaryPath2;
    this.stubBinaryPath3 = builder.stubBinaryPath3;
    this.stubBinaryPath = builder.stubBinaryPath != null
        ? builder.stubBinaryPath
        : Objects.requireNonNull(super.getStubBinaryPath(), "stubBinaryPath");
  }

  private ImmutableOptionalNonOptional(
      Optional<Path> stubBinaryPath,
      com.google.common.base.Optional<? extends Path> stubBinaryPath2,
      @Nullable Optional<Path> stubBinaryPath3) {
    this.stubBinaryPath = stubBinaryPath;
    this.stubBinaryPath2 = stubBinaryPath2;
    this.stubBinaryPath3 = stubBinaryPath3;
  }

  /**
   * @return The value of the {@code stubBinaryPath} attribute
   */
  @Override
  public Optional<Path> getStubBinaryPath() {
    return stubBinaryPath;
  }

  /**
   * @return The value of the {@code stubBinaryPath2} attribute
   */
  @Override
  public com.google.common.base.Optional<? extends Path> stubBinaryPath2() {
    return stubBinaryPath2;
  }

  /**
   * @return The value of the {@code stubBinaryPath3} attribute
   */
  @Override
  public @Nullable Optional<Path> stubBinaryPath3() {
    return stubBinaryPath3;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link OptionalNonOptional#getStubBinaryPath() stubBinaryPath} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for stubBinaryPath
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableOptionalNonOptional withStubBinaryPath(Optional<Path> value) {
    Optional<Path> newValue = Objects.requireNonNull(value, "stubBinaryPath");
    if (this.stubBinaryPath.equals(newValue)) return this;
    return new ImmutableOptionalNonOptional(newValue, this.stubBinaryPath2, this.stubBinaryPath3);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link OptionalNonOptional#stubBinaryPath2() stubBinaryPath2} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for stubBinaryPath2
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableOptionalNonOptional withStubBinaryPath2(com.google.common.base.Optional<? extends Path> value) {
    com.google.common.base.Optional<? extends Path> newValue = Objects.requireNonNull(value, "stubBinaryPath2");
    if (this.stubBinaryPath2.equals(newValue)) return this;
    return new ImmutableOptionalNonOptional(this.stubBinaryPath, newValue, this.stubBinaryPath3);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link OptionalNonOptional#stubBinaryPath3() stubBinaryPath3} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for stubBinaryPath3 (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableOptionalNonOptional withStubBinaryPath3(@Nullable Optional<Path> value) {
    if (Objects.equals(this.stubBinaryPath3, value)) return this;
    return new ImmutableOptionalNonOptional(this.stubBinaryPath, this.stubBinaryPath2, value);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableOptionalNonOptional} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableOptionalNonOptional
        && equalTo(0, (ImmutableOptionalNonOptional) another);
  }

  private boolean equalTo(int synthetic, ImmutableOptionalNonOptional another) {
    return stubBinaryPath.equals(another.stubBinaryPath)
        && stubBinaryPath2.equals(another.stubBinaryPath2)
        && Objects.equals(stubBinaryPath3, another.stubBinaryPath3);
  }

  /**
   * Computes a hash code from attributes: {@code stubBinaryPath}, {@code stubBinaryPath2}, {@code stubBinaryPath3}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    @Var int h = 5381;
    h += (h << 5) + stubBinaryPath.hashCode();
    h += (h << 5) + stubBinaryPath2.hashCode();
    h += (h << 5) + Objects.hashCode(stubBinaryPath3);
    return h;
  }

  /**
   * Prints the immutable value {@code OptionalNonOptional} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return MoreObjects.toStringHelper("OptionalNonOptional")
        .omitNullValues()
        .add("stubBinaryPath", stubBinaryPath)
        .add("stubBinaryPath2", stubBinaryPath2)
        .add("stubBinaryPath3", stubBinaryPath3)
        .toString();
  }

  /**
   * Creates an immutable copy of a {@link OptionalNonOptional} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable OptionalNonOptional instance
   */
  public static ImmutableOptionalNonOptional copyOf(OptionalNonOptional instance) {
    if (instance instanceof ImmutableOptionalNonOptional) {
      return (ImmutableOptionalNonOptional) instance;
    }
    return ImmutableOptionalNonOptional.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableOptionalNonOptional ImmutableOptionalNonOptional}.
   * <pre>
   * ImmutableOptionalNonOptional.builder()
   *    .stubBinaryPath(Optional&amp;lt;java.nio.file.Path&amp;gt;) // optional {@link OptionalNonOptional#getStubBinaryPath() stubBinaryPath}
   *    .stubBinaryPath2(com.google.common.base.Optional&amp;lt;? extends java.nio.file.Path&amp;gt;) // required {@link OptionalNonOptional#stubBinaryPath2() stubBinaryPath2}
   *    .stubBinaryPath3(Optional&amp;lt;java.nio.file.Path&amp;gt; | null) // nullable {@link OptionalNonOptional#stubBinaryPath3() stubBinaryPath3}
   *    .build();
   * </pre>
   * @return A new ImmutableOptionalNonOptional builder
   */
  public static ImmutableOptionalNonOptional.Builder builder() {
    return new ImmutableOptionalNonOptional.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableOptionalNonOptional ImmutableOptionalNonOptional}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "OptionalNonOptional", generator = "Immutables")
  @NotThreadSafe
  public static final class Builder {
    private static final long INIT_BIT_STUB_BINARY_PATH2 = 0x1L;
    private long initBits = 0x1L;

    private @Nullable Optional<Path> stubBinaryPath;
    private @Nullable com.google.common.base.Optional<? extends Path> stubBinaryPath2;
    private @Nullable Optional<Path> stubBinaryPath3;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code OptionalNonOptional} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder from(OptionalNonOptional instance) {
      Objects.requireNonNull(instance, "instance");
      stubBinaryPath(instance.getStubBinaryPath());
      stubBinaryPath2(instance.stubBinaryPath2());
      @Nullable Optional<Path> stubBinaryPath3Value = instance.stubBinaryPath3();
      if (stubBinaryPath3Value != null) {
        stubBinaryPath3(stubBinaryPath3Value);
      }
      return this;
    }

    /**
     * Initializes the value for the {@link OptionalNonOptional#getStubBinaryPath() stubBinaryPath} attribute.
     * <p><em>If not set, this attribute will have a default value as returned by the initializer of {@link OptionalNonOptional#getStubBinaryPath() stubBinaryPath}.</em>
     * @param stubBinaryPath The value for stubBinaryPath 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder stubBinaryPath(Optional<Path> stubBinaryPath) {
      this.stubBinaryPath = Objects.requireNonNull(stubBinaryPath, "stubBinaryPath");
      return this;
    }

    /**
     * Initializes the value for the {@link OptionalNonOptional#stubBinaryPath2() stubBinaryPath2} attribute.
     * @param stubBinaryPath2 The value for stubBinaryPath2 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder stubBinaryPath2(com.google.common.base.Optional<? extends Path> stubBinaryPath2) {
      this.stubBinaryPath2 = Objects.requireNonNull(stubBinaryPath2, "stubBinaryPath2");
      initBits &= ~INIT_BIT_STUB_BINARY_PATH2;
      return this;
    }

    /**
     * Initializes the value for the {@link OptionalNonOptional#stubBinaryPath3() stubBinaryPath3} attribute.
     * @param stubBinaryPath3 The value for stubBinaryPath3 (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder stubBinaryPath3(@Nullable Optional<Path> stubBinaryPath3) {
      this.stubBinaryPath3 = stubBinaryPath3;
      return this;
    }

    /**
     * Builds a new {@link ImmutableOptionalNonOptional ImmutableOptionalNonOptional}.
     * @return An immutable instance of OptionalNonOptional
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableOptionalNonOptional build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new ImmutableOptionalNonOptional(this);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_STUB_BINARY_PATH2) != 0) attributes.add("stubBinaryPath2");
      return "Cannot build OptionalNonOptional, some of required attributes are not set " + attributes;
    }
  }
}
