package org.immutables.fixture;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableSortedMap;
import com.google.common.collect.ImmutableSortedMultiset;
import com.google.common.collect.ImmutableSortedSet;
import com.google.common.collect.Ordering;
import com.google.common.primitives.Ints;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.errorprone.annotations.Var;
import java.util.Arrays;
import java.util.Map;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link OrderAttributeValue}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableOrderAttributeValue.builder()}.
 */
@Generated(from = "OrderAttributeValue", generator = "Immutables")
@SuppressWarnings({"all"})
@ParametersAreNonnullByDefault
@javax.annotation.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
@CheckReturnValue
public final class ImmutableOrderAttributeValue extends OrderAttributeValue {
  private final ImmutableSortedSet<Integer> natural;
  private final ImmutableSortedSet<String> reverse;
  private final ImmutableSortedMap<String, String> reverseMap;
  private final ImmutableSortedMap<Integer, String> navigableMap;
  private final ImmutableSortedMultiset<Integer> naturalMultiset;
  private final ImmutableSortedMultiset<String> reverseMultiset;

  private ImmutableOrderAttributeValue(
      ImmutableSortedSet<Integer> natural,
      ImmutableSortedSet<String> reverse,
      ImmutableSortedMap<String, String> reverseMap,
      ImmutableSortedMap<Integer, String> navigableMap,
      ImmutableSortedMultiset<Integer> naturalMultiset,
      ImmutableSortedMultiset<String> reverseMultiset) {
    this.natural = natural;
    this.reverse = reverse;
    this.reverseMap = reverseMap;
    this.navigableMap = navigableMap;
    this.naturalMultiset = naturalMultiset;
    this.reverseMultiset = reverseMultiset;
  }

  /**
   * @return The value of the {@code natural} attribute
   */
  @Override
  public ImmutableSortedSet<Integer> natural() {
    return natural;
  }

  /**
   * @return The value of the {@code reverse} attribute
   */
  @Override
  public ImmutableSortedSet<String> reverse() {
    return reverse;
  }

  /**
   * @return The value of the {@code reverseMap} attribute
   */
  @Override
  public ImmutableSortedMap<String, String> reverseMap() {
    return reverseMap;
  }

  /**
   * @return The value of the {@code navigableMap} attribute
   */
  @Override
  public ImmutableSortedMap<Integer, String> navigableMap() {
    return navigableMap;
  }

  /**
   * @return The value of the {@code naturalMultiset} attribute
   */
  @Override
  public ImmutableSortedMultiset<Integer> naturalMultiset() {
    return naturalMultiset;
  }

  /**
   * @return The value of the {@code reverseMultiset} attribute
   */
  @Override
  public ImmutableSortedMultiset<String> reverseMultiset() {
    return reverseMultiset;
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link OrderAttributeValue#natural() natural}.
   * @param elements The elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableOrderAttributeValue withNatural(int... elements) {
    ImmutableSortedSet<Integer> newValue = ImmutableSortedSet.copyOf(
        Ordering.<Integer>natural(),
        Ints.asList(elements));
    return new ImmutableOrderAttributeValue(
        newValue,
        this.reverse,
        this.reverseMap,
        this.navigableMap,
        this.naturalMultiset,
        this.reverseMultiset);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link OrderAttributeValue#natural() natural}.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param elements An iterable of natural elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableOrderAttributeValue withNatural(Iterable<Integer> elements) {
    if (this.natural == elements) return this;
    ImmutableSortedSet<Integer> newValue = ImmutableSortedSet.copyOf(
        Ordering.<Integer>natural(),
        elements);
    return new ImmutableOrderAttributeValue(
        newValue,
        this.reverse,
        this.reverseMap,
        this.navigableMap,
        this.naturalMultiset,
        this.reverseMultiset);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link OrderAttributeValue#reverse() reverse}.
   * @param elements The elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableOrderAttributeValue withReverse(String... elements) {
    ImmutableSortedSet<String> newValue = ImmutableSortedSet.copyOf(
        Ordering.<String>natural().reverse(),
        Arrays.asList(elements));
    return new ImmutableOrderAttributeValue(
        this.natural,
        newValue,
        this.reverseMap,
        this.navigableMap,
        this.naturalMultiset,
        this.reverseMultiset);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link OrderAttributeValue#reverse() reverse}.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param elements An iterable of reverse elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableOrderAttributeValue withReverse(Iterable<String> elements) {
    if (this.reverse == elements) return this;
    ImmutableSortedSet<String> newValue = ImmutableSortedSet.copyOf(
        Ordering.<String>natural().reverse(),
        elements);
    return new ImmutableOrderAttributeValue(
        this.natural,
        newValue,
        this.reverseMap,
        this.navigableMap,
        this.naturalMultiset,
        this.reverseMultiset);
  }

  /**
   * Copy the current immutable object by replacing the {@link OrderAttributeValue#reverseMap() reverseMap} map with the specified map.
   * Nulls are not permitted as keys or values.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param entries The entries to be added to the reverseMap map
   * @return A modified copy of {@code this} object
   */
  public final ImmutableOrderAttributeValue withReverseMap(Map<String, ? extends String> entries) {
    if (this.reverseMap == entries) return this;
    ImmutableSortedMap<String, String> newValue = ImmutableSortedMap.copyOf(entries,
        Ordering.<String>natural().reverse()
    );
    return new ImmutableOrderAttributeValue(
        this.natural,
        this.reverse,
        newValue,
        this.navigableMap,
        this.naturalMultiset,
        this.reverseMultiset);
  }

  /**
   * Copy the current immutable object by replacing the {@link OrderAttributeValue#navigableMap() navigableMap} map with the specified map.
   * Nulls are not permitted as keys or values.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param entries The entries to be added to the navigableMap map
   * @return A modified copy of {@code this} object
   */
  public final ImmutableOrderAttributeValue withNavigableMap(Map<Integer, ? extends String> entries) {
    if (this.navigableMap == entries) return this;
    ImmutableSortedMap<Integer, String> newValue = ImmutableSortedMap.copyOf(entries,
        Ordering.<Integer>natural()
    );
    return new ImmutableOrderAttributeValue(
        this.natural,
        this.reverse,
        this.reverseMap,
        newValue,
        this.naturalMultiset,
        this.reverseMultiset);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link OrderAttributeValue#naturalMultiset() naturalMultiset}.
   * @param elements The elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableOrderAttributeValue withNaturalMultiset(int... elements) {
    ImmutableSortedMultiset<Integer> newValue = ImmutableSortedMultiset.copyOf(
        Ordering.<Integer>natural(),
        Ints.asList(elements));
    return new ImmutableOrderAttributeValue(this.natural, this.reverse, this.reverseMap, this.navigableMap, newValue, this.reverseMultiset);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link OrderAttributeValue#naturalMultiset() naturalMultiset}.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param elements An iterable of naturalMultiset elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableOrderAttributeValue withNaturalMultiset(Iterable<Integer> elements) {
    if (this.naturalMultiset == elements) return this;
    ImmutableSortedMultiset<Integer> newValue = ImmutableSortedMultiset.copyOf(
        Ordering.<Integer>natural(),
        elements);
    return new ImmutableOrderAttributeValue(this.natural, this.reverse, this.reverseMap, this.navigableMap, newValue, this.reverseMultiset);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link OrderAttributeValue#reverseMultiset() reverseMultiset}.
   * @param elements The elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableOrderAttributeValue withReverseMultiset(String... elements) {
    ImmutableSortedMultiset<String> newValue = ImmutableSortedMultiset.copyOf(
        Ordering.<String>natural().reverse(),
        Arrays.asList(elements));
    return new ImmutableOrderAttributeValue(this.natural, this.reverse, this.reverseMap, this.navigableMap, this.naturalMultiset, newValue);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link OrderAttributeValue#reverseMultiset() reverseMultiset}.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param elements An iterable of reverseMultiset elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableOrderAttributeValue withReverseMultiset(Iterable<String> elements) {
    if (this.reverseMultiset == elements) return this;
    ImmutableSortedMultiset<String> newValue = ImmutableSortedMultiset.copyOf(
        Ordering.<String>natural().reverse(),
        elements);
    return new ImmutableOrderAttributeValue(this.natural, this.reverse, this.reverseMap, this.navigableMap, this.naturalMultiset, newValue);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableOrderAttributeValue} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableOrderAttributeValue
        && equalTo(0, (ImmutableOrderAttributeValue) another);
  }

  private boolean equalTo(int synthetic, ImmutableOrderAttributeValue another) {
    return natural.equals(another.natural)
        && reverse.equals(another.reverse)
        && reverseMap.equals(another.reverseMap)
        && navigableMap.equals(another.navigableMap)
        && naturalMultiset.equals(another.naturalMultiset)
        && reverseMultiset.equals(another.reverseMultiset);
  }

  /**
   * Computes a hash code from attributes: {@code natural}, {@code reverse}, {@code reverseMap}, {@code navigableMap}, {@code naturalMultiset}, {@code reverseMultiset}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    @Var int h = 5381;
    h += (h << 5) + natural.hashCode();
    h += (h << 5) + reverse.hashCode();
    h += (h << 5) + reverseMap.hashCode();
    h += (h << 5) + navigableMap.hashCode();
    h += (h << 5) + naturalMultiset.hashCode();
    h += (h << 5) + reverseMultiset.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code OrderAttributeValue} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return MoreObjects.toStringHelper("OrderAttributeValue")
        .omitNullValues()
        .add("natural", natural)
        .add("reverse", reverse)
        .add("reverseMap", reverseMap)
        .add("navigableMap", navigableMap)
        .add("naturalMultiset", naturalMultiset)
        .add("reverseMultiset", reverseMultiset)
        .toString();
  }

  /**
   * Creates an immutable copy of a {@link OrderAttributeValue} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable OrderAttributeValue instance
   */
  public static ImmutableOrderAttributeValue copyOf(OrderAttributeValue instance) {
    if (instance instanceof ImmutableOrderAttributeValue) {
      return (ImmutableOrderAttributeValue) instance;
    }
    return ImmutableOrderAttributeValue.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableOrderAttributeValue ImmutableOrderAttributeValue}.
   * <pre>
   * ImmutableOrderAttributeValue.builder()
   *    .addNatural|addAllNatural(int) // {@link OrderAttributeValue#natural() natural} elements
   *    .addReverse|addAllReverse(String) // {@link OrderAttributeValue#reverse() reverse} elements
   *    .putReverseMap|putAllReverseMap(String =&gt; String) // {@link OrderAttributeValue#reverseMap() reverseMap} mappings
   *    .putNavigableMap|putAllNavigableMap(int =&gt; String) // {@link OrderAttributeValue#navigableMap() navigableMap} mappings
   *    .addNaturalMultiset|addAllNaturalMultiset(int) // {@link OrderAttributeValue#naturalMultiset() naturalMultiset} elements
   *    .addReverseMultiset|addAllReverseMultiset(String) // {@link OrderAttributeValue#reverseMultiset() reverseMultiset} elements
   *    .build();
   * </pre>
   * @return A new ImmutableOrderAttributeValue builder
   */
  public static ImmutableOrderAttributeValue.Builder builder() {
    return new ImmutableOrderAttributeValue.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableOrderAttributeValue ImmutableOrderAttributeValue}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "OrderAttributeValue", generator = "Immutables")
  @NotThreadSafe
  public static final class Builder {
    private ImmutableSortedSet.Builder<Integer> natural = ImmutableSortedSet.naturalOrder();
    private ImmutableSortedSet.Builder<String> reverse = ImmutableSortedSet.reverseOrder();
    private ImmutableSortedMap.Builder<String, String> reverseMap = ImmutableSortedMap.reverseOrder();
    private ImmutableSortedMap.Builder<Integer, String> navigableMap = ImmutableSortedMap.naturalOrder();
    private ImmutableSortedMultiset.Builder<Integer> naturalMultiset = ImmutableSortedMultiset.naturalOrder();
    private ImmutableSortedMultiset.Builder<String> reverseMultiset = ImmutableSortedMultiset.reverseOrder();

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code OrderAttributeValue} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * Collection elements and entries will be added, not replaced.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder from(OrderAttributeValue instance) {
      Objects.requireNonNull(instance, "instance");
      addAllNatural(instance.natural());
      addAllReverse(instance.reverse());
      putAllReverseMap(instance.reverseMap());
      putAllNavigableMap(instance.navigableMap());
      addAllNaturalMultiset(instance.naturalMultiset());
      addAllReverseMultiset(instance.reverseMultiset());
      return this;
    }

    /**
     * Adds one element to {@link OrderAttributeValue#natural() natural} sortedSet.
     * @param element A natural element
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addNatural(int element) {
      this.natural.add(element);
      return this;
    }

    /**
     * Adds elements to {@link OrderAttributeValue#natural() natural} sortedSet.
     * @param elements An array of natural elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addNatural(int... elements) {
      this.natural.addAll(Ints.asList(elements));
      return this;
    }


    /**
     * Sets or replaces all elements for {@link OrderAttributeValue#natural() natural} sortedSet.
     * @param elements An iterable of natural elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder natural(Iterable<Integer> elements) {
      this.natural = ImmutableSortedSet.naturalOrder();
      return addAllNatural(elements);
    }

    /**
     * Adds elements to {@link OrderAttributeValue#natural() natural} sortedSet.
     * @param elements An iterable of natural elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addAllNatural(Iterable<Integer> elements) {
      this.natural.addAll(elements);
      return this;
    }

    /**
     * Adds one element to {@link OrderAttributeValue#reverse() reverse} sortedSet.
     * @param element A reverse element
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addReverse(String element) {
      this.reverse.add(element);
      return this;
    }

    /**
     * Adds elements to {@link OrderAttributeValue#reverse() reverse} sortedSet.
     * @param elements An array of reverse elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addReverse(String... elements) {
      this.reverse.addAll(Arrays.asList(elements));
      return this;
    }


    /**
     * Sets or replaces all elements for {@link OrderAttributeValue#reverse() reverse} sortedSet.
     * @param elements An iterable of reverse elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder reverse(Iterable<String> elements) {
      this.reverse = ImmutableSortedSet.reverseOrder();
      return addAllReverse(elements);
    }

    /**
     * Adds elements to {@link OrderAttributeValue#reverse() reverse} sortedSet.
     * @param elements An iterable of reverse elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addAllReverse(Iterable<String> elements) {
      this.reverse.addAll(elements);
      return this;
    }

    /**
     * Put one entry to the {@link OrderAttributeValue#reverseMap() reverseMap} map.
     * @param key The key in the reverseMap map
     * @param value The associated value in the reverseMap map
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder putReverseMap(String key, String value) {
      this.reverseMap.put(key, value);
      return this;
    }

    /**
     * Put one entry to the {@link OrderAttributeValue#reverseMap() reverseMap} map. Nulls are not permitted
     * @param entry The key and value entry
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder putReverseMap(Map.Entry<String, ? extends String> entry) {
      this.reverseMap.put(entry);
      return this;
    }

    /**
     * Sets or replaces all mappings from the specified map as entries for the {@link OrderAttributeValue#reverseMap() reverseMap} map. Nulls are not permitted
     * @param entries The entries that will be added to the reverseMap map
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder reverseMap(Map<String, ? extends String> entries) {
      this.reverseMap = ImmutableSortedMap.reverseOrder();
      return putAllReverseMap(entries);
    }

    /**
     * Put all mappings from the specified map as entries to {@link OrderAttributeValue#reverseMap() reverseMap} map. Nulls are not permitted
     * @param entries The entries that will be added to the reverseMap map
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder putAllReverseMap(Map<String, ? extends String> entries) {
      this.reverseMap.putAll(entries);
      return this;
    }

    /**
     * Put one entry to the {@link OrderAttributeValue#navigableMap() navigableMap} map.
     * @param key The key in the navigableMap map
     * @param value The associated value in the navigableMap map
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder putNavigableMap(int key, String value) {
      this.navigableMap.put(key, value);
      return this;
    }

    /**
     * Put one entry to the {@link OrderAttributeValue#navigableMap() navigableMap} map. Nulls are not permitted
     * @param entry The key and value entry
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder putNavigableMap(Map.Entry<Integer, ? extends String> entry) {
      this.navigableMap.put(entry);
      return this;
    }

    /**
     * Sets or replaces all mappings from the specified map as entries for the {@link OrderAttributeValue#navigableMap() navigableMap} map. Nulls are not permitted
     * @param entries The entries that will be added to the navigableMap map
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder navigableMap(Map<Integer, ? extends String> entries) {
      this.navigableMap = ImmutableSortedMap.naturalOrder();
      return putAllNavigableMap(entries);
    }

    /**
     * Put all mappings from the specified map as entries to {@link OrderAttributeValue#navigableMap() navigableMap} map. Nulls are not permitted
     * @param entries The entries that will be added to the navigableMap map
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder putAllNavigableMap(Map<Integer, ? extends String> entries) {
      this.navigableMap.putAll(entries);
      return this;
    }

    /**
     * Adds one element to {@link OrderAttributeValue#naturalMultiset() naturalMultiset} sortedMultiset.
     * @param element A naturalMultiset element
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addNaturalMultiset(int element) {
      this.naturalMultiset.add(element);
      return this;
    }

    /**
     * Adds elements to {@link OrderAttributeValue#naturalMultiset() naturalMultiset} sortedMultiset.
     * @param elements An array of naturalMultiset elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addNaturalMultiset(int... elements) {
      this.naturalMultiset.addAll(Ints.asList(elements));
      return this;
    }


    /**
     * Sets or replaces all elements for {@link OrderAttributeValue#naturalMultiset() naturalMultiset} sortedMultiset.
     * @param elements An iterable of naturalMultiset elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder naturalMultiset(Iterable<Integer> elements) {
      this.naturalMultiset = ImmutableSortedMultiset.naturalOrder();
      return addAllNaturalMultiset(elements);
    }

    /**
     * Adds elements to {@link OrderAttributeValue#naturalMultiset() naturalMultiset} sortedMultiset.
     * @param elements An iterable of naturalMultiset elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addAllNaturalMultiset(Iterable<Integer> elements) {
      this.naturalMultiset.addAll(elements);
      return this;
    }

    /**
     * Adds one element to {@link OrderAttributeValue#reverseMultiset() reverseMultiset} sortedMultiset.
     * @param element A reverseMultiset element
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addReverseMultiset(String element) {
      this.reverseMultiset.add(element);
      return this;
    }

    /**
     * Adds elements to {@link OrderAttributeValue#reverseMultiset() reverseMultiset} sortedMultiset.
     * @param elements An array of reverseMultiset elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addReverseMultiset(String... elements) {
      this.reverseMultiset.addAll(Arrays.asList(elements));
      return this;
    }


    /**
     * Sets or replaces all elements for {@link OrderAttributeValue#reverseMultiset() reverseMultiset} sortedMultiset.
     * @param elements An iterable of reverseMultiset elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder reverseMultiset(Iterable<String> elements) {
      this.reverseMultiset = ImmutableSortedMultiset.reverseOrder();
      return addAllReverseMultiset(elements);
    }

    /**
     * Adds elements to {@link OrderAttributeValue#reverseMultiset() reverseMultiset} sortedMultiset.
     * @param elements An iterable of reverseMultiset elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addAllReverseMultiset(Iterable<String> elements) {
      this.reverseMultiset.addAll(elements);
      return this;
    }

    /**
     * Builds a new {@link ImmutableOrderAttributeValue ImmutableOrderAttributeValue}.
     * @return An immutable instance of OrderAttributeValue
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableOrderAttributeValue build() {
      return new ImmutableOrderAttributeValue(
          natural.build(),
          reverse.build(),
          reverseMap.build(),
          navigableMap.build(),
          naturalMultiset.build(),
          reverseMultiset.build());
    }
  }
}
