package org.immutables.fixture;

import com.google.common.base.MoreObjects;
import com.google.common.primitives.Booleans;
import com.google.common.primitives.Bytes;
import com.google.common.primitives.Chars;
import com.google.common.primitives.Doubles;
import com.google.common.primitives.Floats;
import com.google.common.primitives.Longs;
import com.google.common.primitives.Shorts;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.errorprone.annotations.Var;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link PrivateNoargConstructorOptionFalseDoNotAffectPrehash}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutablePrivateNoargConstructorOptionFalseDoNotAffectPrehash.builder()}.
 */
@Generated(from = "PrivateNoargConstructorOptionFalseDoNotAffectPrehash", generator = "Immutables")
@SuppressWarnings({"all"})
@ParametersAreNonnullByDefault
@javax.annotation.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
@CheckReturnValue
final class ImmutablePrivateNoargConstructorOptionFalseDoNotAffectPrehash
    implements PrivateNoargConstructorOptionFalseDoNotAffectPrehash {
  private final boolean is;
  private final byte b;
  private final short s;
  private final int i;
  private final long l;
  private final char c;
  private final float f;
  private final double d;
  private final Object o;
  private final String z;
  private transient final int hashCode;

  private ImmutablePrivateNoargConstructorOptionFalseDoNotAffectPrehash(
      boolean is,
      byte b,
      short s,
      int i,
      long l,
      char c,
      float f,
      double d,
      Object o,
      String z) {
    this.is = is;
    this.b = b;
    this.s = s;
    this.i = i;
    this.l = l;
    this.c = c;
    this.f = f;
    this.d = d;
    this.o = o;
    this.z = z;
    this.hashCode = computeHashCode();
  }

  /**
   * @return The value of the {@code is} attribute
   */
  @Override
  public boolean is() {
    return is;
  }

  /**
   * @return The value of the {@code b} attribute
   */
  @Override
  public byte b() {
    return b;
  }

  /**
   * @return The value of the {@code s} attribute
   */
  @Override
  public short s() {
    return s;
  }

  /**
   * @return The value of the {@code i} attribute
   */
  @Override
  public int i() {
    return i;
  }

  /**
   * @return The value of the {@code l} attribute
   */
  @Override
  public long l() {
    return l;
  }

  /**
   * @return The value of the {@code c} attribute
   */
  @Override
  public char c() {
    return c;
  }

  /**
   * @return The value of the {@code f} attribute
   */
  @Override
  public float f() {
    return f;
  }

  /**
   * @return The value of the {@code d} attribute
   */
  @Override
  public double d() {
    return d;
  }

  /**
   * @return The value of the {@code o} attribute
   */
  @Override
  public Object o() {
    return o;
  }

  /**
   * @return The value of the {@code z} attribute
   */
  @Override
  public String z() {
    return z;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link PrivateNoargConstructorOptionFalseDoNotAffectPrehash#is() is} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for is
   * @return A modified copy of the {@code this} object
   */
  public final ImmutablePrivateNoargConstructorOptionFalseDoNotAffectPrehash withIs(boolean value) {
    if (this.is == value) return this;
    return new ImmutablePrivateNoargConstructorOptionFalseDoNotAffectPrehash(value, this.b, this.s, this.i, this.l, this.c, this.f, this.d, this.o, this.z);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link PrivateNoargConstructorOptionFalseDoNotAffectPrehash#b() b} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for b
   * @return A modified copy of the {@code this} object
   */
  public final ImmutablePrivateNoargConstructorOptionFalseDoNotAffectPrehash withB(byte value) {
    if (this.b == value) return this;
    return new ImmutablePrivateNoargConstructorOptionFalseDoNotAffectPrehash(this.is, value, this.s, this.i, this.l, this.c, this.f, this.d, this.o, this.z);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link PrivateNoargConstructorOptionFalseDoNotAffectPrehash#s() s} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for s
   * @return A modified copy of the {@code this} object
   */
  public final ImmutablePrivateNoargConstructorOptionFalseDoNotAffectPrehash withS(short value) {
    if (this.s == value) return this;
    return new ImmutablePrivateNoargConstructorOptionFalseDoNotAffectPrehash(this.is, this.b, value, this.i, this.l, this.c, this.f, this.d, this.o, this.z);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link PrivateNoargConstructorOptionFalseDoNotAffectPrehash#i() i} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for i
   * @return A modified copy of the {@code this} object
   */
  public final ImmutablePrivateNoargConstructorOptionFalseDoNotAffectPrehash withI(int value) {
    if (this.i == value) return this;
    return new ImmutablePrivateNoargConstructorOptionFalseDoNotAffectPrehash(this.is, this.b, this.s, value, this.l, this.c, this.f, this.d, this.o, this.z);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link PrivateNoargConstructorOptionFalseDoNotAffectPrehash#l() l} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for l
   * @return A modified copy of the {@code this} object
   */
  public final ImmutablePrivateNoargConstructorOptionFalseDoNotAffectPrehash withL(long value) {
    if (this.l == value) return this;
    return new ImmutablePrivateNoargConstructorOptionFalseDoNotAffectPrehash(this.is, this.b, this.s, this.i, value, this.c, this.f, this.d, this.o, this.z);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link PrivateNoargConstructorOptionFalseDoNotAffectPrehash#c() c} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for c
   * @return A modified copy of the {@code this} object
   */
  public final ImmutablePrivateNoargConstructorOptionFalseDoNotAffectPrehash withC(char value) {
    if (this.c == value) return this;
    return new ImmutablePrivateNoargConstructorOptionFalseDoNotAffectPrehash(this.is, this.b, this.s, this.i, this.l, value, this.f, this.d, this.o, this.z);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link PrivateNoargConstructorOptionFalseDoNotAffectPrehash#f() f} attribute.
   * A value strict bits equality used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for f
   * @return A modified copy of the {@code this} object
   */
  public final ImmutablePrivateNoargConstructorOptionFalseDoNotAffectPrehash withF(float value) {
    if (Float.floatToIntBits(this.f) == Float.floatToIntBits(value)) return this;
    return new ImmutablePrivateNoargConstructorOptionFalseDoNotAffectPrehash(this.is, this.b, this.s, this.i, this.l, this.c, value, this.d, this.o, this.z);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link PrivateNoargConstructorOptionFalseDoNotAffectPrehash#d() d} attribute.
   * A value strict bits equality used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for d
   * @return A modified copy of the {@code this} object
   */
  public final ImmutablePrivateNoargConstructorOptionFalseDoNotAffectPrehash withD(double value) {
    if (Double.doubleToLongBits(this.d) == Double.doubleToLongBits(value)) return this;
    return new ImmutablePrivateNoargConstructorOptionFalseDoNotAffectPrehash(this.is, this.b, this.s, this.i, this.l, this.c, this.f, value, this.o, this.z);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link PrivateNoargConstructorOptionFalseDoNotAffectPrehash#o() o} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for o
   * @return A modified copy of the {@code this} object
   */
  public final ImmutablePrivateNoargConstructorOptionFalseDoNotAffectPrehash withO(Object value) {
    if (this.o == value) return this;
    Object newValue = Objects.requireNonNull(value, "o");
    return new ImmutablePrivateNoargConstructorOptionFalseDoNotAffectPrehash(this.is, this.b, this.s, this.i, this.l, this.c, this.f, this.d, newValue, this.z);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link PrivateNoargConstructorOptionFalseDoNotAffectPrehash#z() z} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for z
   * @return A modified copy of the {@code this} object
   */
  public final ImmutablePrivateNoargConstructorOptionFalseDoNotAffectPrehash withZ(String value) {
    String newValue = Objects.requireNonNull(value, "z");
    if (this.z.equals(newValue)) return this;
    return new ImmutablePrivateNoargConstructorOptionFalseDoNotAffectPrehash(this.is, this.b, this.s, this.i, this.l, this.c, this.f, this.d, this.o, newValue);
  }

  /**
   * This instance is equal to all instances of {@code ImmutablePrivateNoargConstructorOptionFalseDoNotAffectPrehash} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutablePrivateNoargConstructorOptionFalseDoNotAffectPrehash
        && equalTo(0, (ImmutablePrivateNoargConstructorOptionFalseDoNotAffectPrehash) another);
  }

  private boolean equalTo(int synthetic, ImmutablePrivateNoargConstructorOptionFalseDoNotAffectPrehash another) {
    if (hashCode != another.hashCode) return false;
    return is == another.is
        && b == another.b
        && s == another.s
        && i == another.i
        && l == another.l
        && c == another.c
        && Float.floatToIntBits(f) == Float.floatToIntBits(another.f)
        && Double.doubleToLongBits(d) == Double.doubleToLongBits(another.d)
        && o.equals(another.o)
        && z.equals(another.z);
  }

  /**
   * Returns a precomputed-on-construction hash code from attributes: {@code is}, {@code b}, {@code s}, {@code i}, {@code l}, {@code c}, {@code f}, {@code d}, {@code o}, {@code z}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    return hashCode;
  }

  private int computeHashCode() {
    @Var int h = 5381;
    h += (h << 5) + Booleans.hashCode(is);
    h += (h << 5) + Bytes.hashCode(b);
    h += (h << 5) + Shorts.hashCode(s);
    h += (h << 5) + i;
    h += (h << 5) + Longs.hashCode(l);
    h += (h << 5) + Chars.hashCode(c);
    h += (h << 5) + Floats.hashCode(f);
    h += (h << 5) + Doubles.hashCode(d);
    h += (h << 5) + o.hashCode();
    h += (h << 5) + z.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code PrivateNoargConstructorOptionFalseDoNotAffectPrehash} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return MoreObjects.toStringHelper("PrivateNoargConstructorOptionFalseDoNotAffectPrehash")
        .omitNullValues()
        .add("is", is)
        .add("b", b)
        .add("s", s)
        .add("i", i)
        .add("l", l)
        .add("c", c)
        .add("f", f)
        .add("d", d)
        .add("o", o)
        .add("z", z)
        .toString();
  }

  /**
   * Creates an immutable copy of a {@link PrivateNoargConstructorOptionFalseDoNotAffectPrehash} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable PrivateNoargConstructorOptionFalseDoNotAffectPrehash instance
   */
  public static ImmutablePrivateNoargConstructorOptionFalseDoNotAffectPrehash copyOf(PrivateNoargConstructorOptionFalseDoNotAffectPrehash instance) {
    if (instance instanceof ImmutablePrivateNoargConstructorOptionFalseDoNotAffectPrehash) {
      return (ImmutablePrivateNoargConstructorOptionFalseDoNotAffectPrehash) instance;
    }
    return ImmutablePrivateNoargConstructorOptionFalseDoNotAffectPrehash.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutablePrivateNoargConstructorOptionFalseDoNotAffectPrehash ImmutablePrivateNoargConstructorOptionFalseDoNotAffectPrehash}.
   * <pre>
   * ImmutablePrivateNoargConstructorOptionFalseDoNotAffectPrehash.builder()
   *    .is(boolean) // required {@link PrivateNoargConstructorOptionFalseDoNotAffectPrehash#is() is}
   *    .b(byte) // required {@link PrivateNoargConstructorOptionFalseDoNotAffectPrehash#b() b}
   *    .s(short) // required {@link PrivateNoargConstructorOptionFalseDoNotAffectPrehash#s() s}
   *    .i(int) // required {@link PrivateNoargConstructorOptionFalseDoNotAffectPrehash#i() i}
   *    .l(long) // required {@link PrivateNoargConstructorOptionFalseDoNotAffectPrehash#l() l}
   *    .c(char) // required {@link PrivateNoargConstructorOptionFalseDoNotAffectPrehash#c() c}
   *    .f(float) // required {@link PrivateNoargConstructorOptionFalseDoNotAffectPrehash#f() f}
   *    .d(double) // required {@link PrivateNoargConstructorOptionFalseDoNotAffectPrehash#d() d}
   *    .o(Object) // required {@link PrivateNoargConstructorOptionFalseDoNotAffectPrehash#o() o}
   *    .z(String) // required {@link PrivateNoargConstructorOptionFalseDoNotAffectPrehash#z() z}
   *    .build();
   * </pre>
   * @return A new ImmutablePrivateNoargConstructorOptionFalseDoNotAffectPrehash builder
   */
  public static ImmutablePrivateNoargConstructorOptionFalseDoNotAffectPrehash.Builder builder() {
    return new ImmutablePrivateNoargConstructorOptionFalseDoNotAffectPrehash.Builder();
  }

  /**
   * Builds instances of type {@link ImmutablePrivateNoargConstructorOptionFalseDoNotAffectPrehash ImmutablePrivateNoargConstructorOptionFalseDoNotAffectPrehash}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "PrivateNoargConstructorOptionFalseDoNotAffectPrehash", generator = "Immutables")
  @NotThreadSafe
  public static final class Builder {
    private static final long INIT_BIT_IS = 0x1L;
    private static final long INIT_BIT_B = 0x2L;
    private static final long INIT_BIT_S = 0x4L;
    private static final long INIT_BIT_I = 0x8L;
    private static final long INIT_BIT_L = 0x10L;
    private static final long INIT_BIT_C = 0x20L;
    private static final long INIT_BIT_F = 0x40L;
    private static final long INIT_BIT_D = 0x80L;
    private static final long INIT_BIT_O = 0x100L;
    private static final long INIT_BIT_Z = 0x200L;
    private long initBits = 0x3ffL;

    private boolean is;
    private byte b;
    private short s;
    private int i;
    private long l;
    private char c;
    private float f;
    private double d;
    private @Nullable Object o;
    private @Nullable String z;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code PrivateNoargConstructorOptionFalseDoNotAffectPrehash} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder from(PrivateNoargConstructorOptionFalseDoNotAffectPrehash instance) {
      Objects.requireNonNull(instance, "instance");
      is(instance.is());
      b(instance.b());
      s(instance.s());
      i(instance.i());
      l(instance.l());
      c(instance.c());
      f(instance.f());
      d(instance.d());
      o(instance.o());
      z(instance.z());
      return this;
    }

    /**
     * Initializes the value for the {@link PrivateNoargConstructorOptionFalseDoNotAffectPrehash#is() is} attribute.
     * @param is The value for is 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder is(boolean is) {
      this.is = is;
      initBits &= ~INIT_BIT_IS;
      return this;
    }

    /**
     * Initializes the value for the {@link PrivateNoargConstructorOptionFalseDoNotAffectPrehash#b() b} attribute.
     * @param b The value for b 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder b(byte b) {
      this.b = b;
      initBits &= ~INIT_BIT_B;
      return this;
    }

    /**
     * Initializes the value for the {@link PrivateNoargConstructorOptionFalseDoNotAffectPrehash#s() s} attribute.
     * @param s The value for s 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder s(short s) {
      this.s = s;
      initBits &= ~INIT_BIT_S;
      return this;
    }

    /**
     * Initializes the value for the {@link PrivateNoargConstructorOptionFalseDoNotAffectPrehash#i() i} attribute.
     * @param i The value for i 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder i(int i) {
      this.i = i;
      initBits &= ~INIT_BIT_I;
      return this;
    }

    /**
     * Initializes the value for the {@link PrivateNoargConstructorOptionFalseDoNotAffectPrehash#l() l} attribute.
     * @param l The value for l 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder l(long l) {
      this.l = l;
      initBits &= ~INIT_BIT_L;
      return this;
    }

    /**
     * Initializes the value for the {@link PrivateNoargConstructorOptionFalseDoNotAffectPrehash#c() c} attribute.
     * @param c The value for c 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder c(char c) {
      this.c = c;
      initBits &= ~INIT_BIT_C;
      return this;
    }

    /**
     * Initializes the value for the {@link PrivateNoargConstructorOptionFalseDoNotAffectPrehash#f() f} attribute.
     * @param f The value for f 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder f(float f) {
      this.f = f;
      initBits &= ~INIT_BIT_F;
      return this;
    }

    /**
     * Initializes the value for the {@link PrivateNoargConstructorOptionFalseDoNotAffectPrehash#d() d} attribute.
     * @param d The value for d 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder d(double d) {
      this.d = d;
      initBits &= ~INIT_BIT_D;
      return this;
    }

    /**
     * Initializes the value for the {@link PrivateNoargConstructorOptionFalseDoNotAffectPrehash#o() o} attribute.
     * @param o The value for o 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder o(Object o) {
      this.o = Objects.requireNonNull(o, "o");
      initBits &= ~INIT_BIT_O;
      return this;
    }

    /**
     * Initializes the value for the {@link PrivateNoargConstructorOptionFalseDoNotAffectPrehash#z() z} attribute.
     * @param z The value for z 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder z(String z) {
      this.z = Objects.requireNonNull(z, "z");
      initBits &= ~INIT_BIT_Z;
      return this;
    }

    /**
     * Builds a new {@link ImmutablePrivateNoargConstructorOptionFalseDoNotAffectPrehash ImmutablePrivateNoargConstructorOptionFalseDoNotAffectPrehash}.
     * @return An immutable instance of PrivateNoargConstructorOptionFalseDoNotAffectPrehash
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutablePrivateNoargConstructorOptionFalseDoNotAffectPrehash build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new ImmutablePrivateNoargConstructorOptionFalseDoNotAffectPrehash(is, b, s, i, l, c, f, d, o, z);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_IS) != 0) attributes.add("is");
      if ((initBits & INIT_BIT_B) != 0) attributes.add("b");
      if ((initBits & INIT_BIT_S) != 0) attributes.add("s");
      if ((initBits & INIT_BIT_I) != 0) attributes.add("i");
      if ((initBits & INIT_BIT_L) != 0) attributes.add("l");
      if ((initBits & INIT_BIT_C) != 0) attributes.add("c");
      if ((initBits & INIT_BIT_F) != 0) attributes.add("f");
      if ((initBits & INIT_BIT_D) != 0) attributes.add("d");
      if ((initBits & INIT_BIT_O) != 0) attributes.add("o");
      if ((initBits & INIT_BIT_Z) != 0) attributes.add("z");
      return "Cannot build PrivateNoargConstructorOptionFalseDoNotAffectPrehash, some of required attributes are not set " + attributes;
    }
  }
}
