package org.immutables.fixture;

import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.errorprone.annotations.Var;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link Redacted.RedactedMaskJdkOnlyOpt}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableRedactedMaskJdkOnlyOpt.builder()}.
 */
@Generated(from = "Redacted.RedactedMaskJdkOnlyOpt", generator = "Immutables")
@SuppressWarnings({"all"})
@ParametersAreNonnullByDefault
@javax.annotation.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
@CheckReturnValue
public final class ImmutableRedactedMaskJdkOnlyOpt
    implements Redacted.RedactedMaskJdkOnlyOpt {
  private final int code;
  private final @Nullable String opt;

  private ImmutableRedactedMaskJdkOnlyOpt(int code, @Nullable String opt) {
    this.code = code;
    this.opt = opt;
  }

  /**
   * @return The value of the {@code code} attribute
   */
  @Override
  public int code() {
    return code;
  }

  /**
   * @return The value of the {@code opt} attribute
   */
  @Override
  public Optional<String> opt() {
    return Optional.ofNullable(opt);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link Redacted.RedactedMaskJdkOnlyOpt#code() code} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for code
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableRedactedMaskJdkOnlyOpt withCode(int value) {
    if (this.code == value) return this;
    return new ImmutableRedactedMaskJdkOnlyOpt(value, this.opt);
  }

  /**
   * Copy the current immutable object by setting a <i>present</i> value for the optional {@link Redacted.RedactedMaskJdkOnlyOpt#opt() opt} attribute.
   * @param value The value for opt
   * @return A modified copy of {@code this} object
   */
  public final ImmutableRedactedMaskJdkOnlyOpt withOpt(String value) {
    String newValue = Objects.requireNonNull(value, "opt");
    if (Objects.equals(this.opt, newValue)) return this;
    return new ImmutableRedactedMaskJdkOnlyOpt(this.code, newValue);
  }

  /**
   * Copy the current immutable object by setting an optional value for the {@link Redacted.RedactedMaskJdkOnlyOpt#opt() opt} attribute.
   * An equality check is used on inner nullable value to prevent copying of the same value by returning {@code this}.
   * @param optional A value for opt
   * @return A modified copy of {@code this} object
   */
  public final ImmutableRedactedMaskJdkOnlyOpt withOpt(Optional<String> optional) {
    @Nullable String value = optional.orElse(null);
    if (Objects.equals(this.opt, value)) return this;
    return new ImmutableRedactedMaskJdkOnlyOpt(this.code, value);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableRedactedMaskJdkOnlyOpt} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableRedactedMaskJdkOnlyOpt
        && equalTo(0, (ImmutableRedactedMaskJdkOnlyOpt) another);
  }

  private boolean equalTo(int synthetic, ImmutableRedactedMaskJdkOnlyOpt another) {
    return code == another.code
        && Objects.equals(opt, another.opt);
  }

  /**
   * Computes a hash code from attributes: {@code code}, {@code opt}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    @Var int h = 5381;
    h += (h << 5) + code;
    h += (h << 5) + Objects.hashCode(opt);
    return h;
  }

  /**
   * Prints the immutable value {@code RedactedMaskJdkOnlyOpt} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    StringBuilder builder = new StringBuilder("RedactedMaskJdkOnlyOpt{");
    builder.append("code=").append("????");
    if (opt != null) {
      builder.append(", ");
      builder.append("opt=").append(opt);
    }
    return builder.append("}").toString();
  }

  /**
   * Creates an immutable copy of a {@link Redacted.RedactedMaskJdkOnlyOpt} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable RedactedMaskJdkOnlyOpt instance
   */
  public static ImmutableRedactedMaskJdkOnlyOpt copyOf(Redacted.RedactedMaskJdkOnlyOpt instance) {
    if (instance instanceof ImmutableRedactedMaskJdkOnlyOpt) {
      return (ImmutableRedactedMaskJdkOnlyOpt) instance;
    }
    return ImmutableRedactedMaskJdkOnlyOpt.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableRedactedMaskJdkOnlyOpt ImmutableRedactedMaskJdkOnlyOpt}.
   * <pre>
   * ImmutableRedactedMaskJdkOnlyOpt.builder()
   *    .code(int) // required {@link Redacted.RedactedMaskJdkOnlyOpt#code() code}
   *    .opt(String) // optional {@link Redacted.RedactedMaskJdkOnlyOpt#opt() opt}
   *    .build();
   * </pre>
   * @return A new ImmutableRedactedMaskJdkOnlyOpt builder
   */
  public static ImmutableRedactedMaskJdkOnlyOpt.Builder builder() {
    return new ImmutableRedactedMaskJdkOnlyOpt.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableRedactedMaskJdkOnlyOpt ImmutableRedactedMaskJdkOnlyOpt}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "Redacted.RedactedMaskJdkOnlyOpt", generator = "Immutables")
  @NotThreadSafe
  public static final class Builder {
    private static final long INIT_BIT_CODE = 0x1L;
    private long initBits = 0x1L;

    private int code;
    private @Nullable String opt;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code RedactedMaskJdkOnlyOpt} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder from(Redacted.RedactedMaskJdkOnlyOpt instance) {
      Objects.requireNonNull(instance, "instance");
      code(instance.code());
      Optional<String> optOptional = instance.opt();
      if (optOptional.isPresent()) {
        opt(optOptional);
      }
      return this;
    }

    /**
     * Initializes the value for the {@link Redacted.RedactedMaskJdkOnlyOpt#code() code} attribute.
     * @param code The value for code 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder code(int code) {
      this.code = code;
      initBits &= ~INIT_BIT_CODE;
      return this;
    }

    /**
     * Initializes the optional value {@link Redacted.RedactedMaskJdkOnlyOpt#opt() opt} to opt.
     * @param opt The value for opt
     * @return {@code this} builder for chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder opt(String opt) {
      this.opt = Objects.requireNonNull(opt, "opt");
      return this;
    }

    /**
     * Initializes the optional value {@link Redacted.RedactedMaskJdkOnlyOpt#opt() opt} to opt.
     * @param opt The value for opt
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder opt(Optional<String> opt) {
      this.opt = opt.orElse(null);
      return this;
    }

    /**
     * Builds a new {@link ImmutableRedactedMaskJdkOnlyOpt ImmutableRedactedMaskJdkOnlyOpt}.
     * @return An immutable instance of RedactedMaskJdkOnlyOpt
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableRedactedMaskJdkOnlyOpt build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new ImmutableRedactedMaskJdkOnlyOpt(code, opt);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_CODE) != 0) attributes.add("code");
      return "Cannot build RedactedMaskJdkOnlyOpt, some of required attributes are not set " + attributes;
    }
  }
}
