package org.immutables.fixture;

import com.google.common.base.MoreObjects;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.errorprone.annotations.Var;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link SafeDerivedInit.SafeInitSingl}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableSafeInitSingl.builder()}.
 * Use the static factory method to get the default singleton instance:
 * {@code ImmutableSafeInitSingl.of()}.
 */
@Generated(from = "SafeDerivedInit.SafeInitSingl", generator = "Immutables")
@SuppressWarnings({"all"})
@ParametersAreNonnullByDefault
@javax.annotation.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
@CheckReturnValue
public final class ImmutableSafeInitSingl implements SafeDerivedInit.SafeInitSingl {
  private final int a;
  private transient final int b;

  private ImmutableSafeInitSingl() {
    this.a = initShim.a();
    this.b = initShim.b();
    this.initShim = null;
  }

  private ImmutableSafeInitSingl(ImmutableSafeInitSingl.Builder builder) {
    if (builder.aIsSet()) {
      initShim.a(builder.a);
    }
    this.a = initShim.a();
    this.b = initShim.b();
    this.initShim = null;
  }

  private ImmutableSafeInitSingl(int a) {
    initShim.a(a);
    this.a = initShim.a();
    this.b = initShim.b();
    this.initShim = null;
  }

  private static final byte STAGE_INITIALIZING = -1;
  private static final byte STAGE_UNINITIALIZED = 0;
  private static final byte STAGE_INITIALIZED = 1;
  @SuppressWarnings("Immutable")
  private transient volatile InitShim initShim = new InitShim();

  @Generated(from = "SafeDerivedInit.SafeInitSingl", generator = "Immutables")
  private final class InitShim {
    private byte aBuildStage = STAGE_UNINITIALIZED;
    private int a;

    int a() {
      if (aBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (aBuildStage == STAGE_UNINITIALIZED) {
        aBuildStage = STAGE_INITIALIZING;
        this.a = aInitialize();
        aBuildStage = STAGE_INITIALIZED;
      }
      return this.a;
    }

    void a(int a) {
      this.a = a;
      aBuildStage = STAGE_INITIALIZED;
    }

    private byte bBuildStage = STAGE_UNINITIALIZED;
    private int b;

    int b() {
      if (bBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (bBuildStage == STAGE_UNINITIALIZED) {
        bBuildStage = STAGE_INITIALIZING;
        this.b = bInitialize();
        bBuildStage = STAGE_INITIALIZED;
      }
      return this.b;
    }

    private String formatInitCycleMessage() {
      List<String> attributes = new ArrayList<>();
      if (aBuildStage == STAGE_INITIALIZING) attributes.add("a");
      if (bBuildStage == STAGE_INITIALIZING) attributes.add("b");
      return "Cannot build SafeInitSingl, attribute initializers form cycle " + attributes;
    }
  }

  private int aInitialize() {
    return SafeDerivedInit.SafeInitSingl.super.a();
  }

  private int bInitialize() {
    return SafeDerivedInit.SafeInitSingl.super.b();
  }

  /**
   * @return The value of the {@code a} attribute
   */
  @Override
  public int a() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.a()
        : this.a;
  }

  /**
   * @return The computed-at-construction value of the {@code b} attribute
   */
  @Override
  public int b() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.b()
        : this.b;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link SafeDerivedInit.SafeInitSingl#a() a} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for a
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableSafeInitSingl withA(int value) {
    if (this.a == value) return this;
    return validate(new ImmutableSafeInitSingl(value));
  }

  /**
   * This instance is equal to all instances of {@code ImmutableSafeInitSingl} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableSafeInitSingl
        && equalTo(0, (ImmutableSafeInitSingl) another);
  }

  private boolean equalTo(int synthetic, ImmutableSafeInitSingl another) {
    return a == another.a
        && b == another.b;
  }

  /**
   * Computes a hash code from attributes: {@code a}, {@code b}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    @Var int h = 5381;
    h += (h << 5) + a;
    h += (h << 5) + b;
    return h;
  }

  /**
   * Prints the immutable value {@code SafeInitSingl} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return MoreObjects.toStringHelper("SafeInitSingl")
        .omitNullValues()
        .add("a", a)
        .add("b", b)
        .toString();
  }

  private static final ImmutableSafeInitSingl INSTANCE = validate(new ImmutableSafeInitSingl());

  /**
   * Returns the default immutable singleton value of {@code SafeInitSingl}
   * @return An immutable instance of SafeInitSingl
   */
  public static ImmutableSafeInitSingl of() {
    return INSTANCE;
  }

  private static ImmutableSafeInitSingl validate(ImmutableSafeInitSingl instance) {
    return INSTANCE != null && INSTANCE.equalTo(0, instance) ? INSTANCE : instance;
  }

  /**
   * Creates an immutable copy of a {@link SafeDerivedInit.SafeInitSingl} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable SafeInitSingl instance
   */
  public static ImmutableSafeInitSingl copyOf(SafeDerivedInit.SafeInitSingl instance) {
    if (instance instanceof ImmutableSafeInitSingl) {
      return (ImmutableSafeInitSingl) instance;
    }
    return ImmutableSafeInitSingl.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableSafeInitSingl ImmutableSafeInitSingl}.
   * <pre>
   * ImmutableSafeInitSingl.builder()
   *    .a(int) // optional {@link SafeDerivedInit.SafeInitSingl#a() a}
   *    .build();
   * </pre>
   * @return A new ImmutableSafeInitSingl builder
   */
  public static ImmutableSafeInitSingl.Builder builder() {
    return new ImmutableSafeInitSingl.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableSafeInitSingl ImmutableSafeInitSingl}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "SafeDerivedInit.SafeInitSingl", generator = "Immutables")
  @NotThreadSafe
  public static final class Builder {
    private static final long OPT_BIT_A = 0x1L;
    private long optBits;

    private int a;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code SafeInitSingl} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder from(SafeDerivedInit.SafeInitSingl instance) {
      Objects.requireNonNull(instance, "instance");
      a(instance.a());
      return this;
    }

    /**
     * Initializes the value for the {@link SafeDerivedInit.SafeInitSingl#a() a} attribute.
     * <p><em>If not set, this attribute will have a default value as returned by the initializer of {@link SafeDerivedInit.SafeInitSingl#a() a}.</em>
     * @param a The value for a 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder a(int a) {
      this.a = a;
      optBits |= OPT_BIT_A;
      return this;
    }

    /**
     * Builds a new {@link ImmutableSafeInitSingl ImmutableSafeInitSingl}.
     * @return An immutable instance of SafeInitSingl
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableSafeInitSingl build() {
      return ImmutableSafeInitSingl.validate(new ImmutableSafeInitSingl(this));
    }

    private boolean aIsSet() {
      return (optBits & OPT_BIT_A) != 0;
    }
  }
}
