package org.immutables.fixture;

import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link SillyExtendedBuilder}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableSillyExtendedBuilder.builder()}.
 */
@Generated(from = "SillyExtendedBuilder", generator = "Immutables")
@SuppressWarnings({"all"})
@ParametersAreNonnullByDefault
@javax.annotation.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
@CheckReturnValue
final class ImmutableSillyExtendedBuilder extends SillyExtendedBuilder {

  private ImmutableSillyExtendedBuilder(ImmutableSillyExtendedBuilder.Builder builder) {
  }

  /**
   * This instance is equal to all instances of {@code ImmutableSillyExtendedBuilder} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableSillyExtendedBuilder
        && equalTo(0, (ImmutableSillyExtendedBuilder) another);
  }

  @SuppressWarnings("MethodCanBeStatic")
  private boolean equalTo(int synthetic, ImmutableSillyExtendedBuilder another) {
    return true;
  }

  /**
   * Returns a constant hash code value.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    return -1703863210;
  }

  /**
   * Prints the immutable value {@code SillyExtendedBuilder}.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "SillyExtendedBuilder{}";
  }

  /**
   * Creates an immutable copy of a {@link SillyExtendedBuilder} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable SillyExtendedBuilder instance
   */
  public static ImmutableSillyExtendedBuilder copyOf(SillyExtendedBuilder instance) {
    if (instance instanceof ImmutableSillyExtendedBuilder) {
      return (ImmutableSillyExtendedBuilder) instance;
    }
    return ImmutableSillyExtendedBuilder.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableSillyExtendedBuilder ImmutableSillyExtendedBuilder}.
   * <pre>
   * ImmutableSillyExtendedBuilder.builder()
   *    .build();
   * </pre>
   * @return A new ImmutableSillyExtendedBuilder builder
   */
  public static ImmutableSillyExtendedBuilder.Builder builder() {
    return new ImmutableSillyExtendedBuilder.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableSillyExtendedBuilder ImmutableSillyExtendedBuilder}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "SillyExtendedBuilder", generator = "Immutables")
  @NotThreadSafe
  public static final class Builder extends SillyExtendedBuilder.Builder {

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code SillyExtendedBuilder} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder from(SillyExtendedBuilder instance) {
      Objects.requireNonNull(instance, "instance");
      return this;
    }

    /**
     * Builds a new {@link ImmutableSillyExtendedBuilder ImmutableSillyExtendedBuilder}.
     * @return An immutable instance of SillyExtendedBuilder
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableSillyExtendedBuilder build() {
      return new ImmutableSillyExtendedBuilder(this);
    }
  }
}
