package org.immutables.fixture;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.errorprone.annotations.Var;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link SillyPolyHost}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableSillyPolyHost.builder()}.
 */
@Generated(from = "SillyPolyHost", generator = "Immutables")
@SuppressWarnings({"all"})
@ParametersAreNonnullByDefault
@javax.annotation.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
@CheckReturnValue
public final class ImmutableSillyPolyHost extends SillyPolyHost {
  private final ImmutableList<SillyAbstract> s;

  private ImmutableSillyPolyHost(ImmutableList<SillyAbstract> s) {
    this.s = s;
  }

  /**
   * @return The value of the {@code s} attribute
   */
  @Override
  public ImmutableList<SillyAbstract> s() {
    return s;
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link SillyPolyHost#s() s}.
   * @param elements The elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableSillyPolyHost withS(SillyAbstract... elements) {
    ImmutableList<SillyAbstract> newValue = ImmutableList.copyOf(elements);
    return new ImmutableSillyPolyHost(newValue);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link SillyPolyHost#s() s}.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param elements An iterable of s elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableSillyPolyHost withS(Iterable<? extends SillyAbstract> elements) {
    if (this.s == elements) return this;
    ImmutableList<SillyAbstract> newValue = ImmutableList.copyOf(elements);
    return new ImmutableSillyPolyHost(newValue);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableSillyPolyHost} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableSillyPolyHost
        && equalTo(0, (ImmutableSillyPolyHost) another);
  }

  private boolean equalTo(int synthetic, ImmutableSillyPolyHost another) {
    return s.equals(another.s);
  }

  /**
   * Computes a hash code from attributes: {@code s}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    @Var int h = 5381;
    h += (h << 5) + s.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code SillyPolyHost} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return MoreObjects.toStringHelper("SillyPolyHost")
        .omitNullValues()
        .add("s", s)
        .toString();
  }

  /**
   * Creates an immutable copy of a {@link SillyPolyHost} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable SillyPolyHost instance
   */
  public static ImmutableSillyPolyHost copyOf(SillyPolyHost instance) {
    if (instance instanceof ImmutableSillyPolyHost) {
      return (ImmutableSillyPolyHost) instance;
    }
    return ImmutableSillyPolyHost.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableSillyPolyHost ImmutableSillyPolyHost}.
   * <pre>
   * ImmutableSillyPolyHost.builder()
   *    .addS|addAllS(org.immutables.fixture.SillyAbstract) // {@link SillyPolyHost#s() s} elements
   *    .build();
   * </pre>
   * @return A new ImmutableSillyPolyHost builder
   */
  public static ImmutableSillyPolyHost.Builder builder() {
    return new ImmutableSillyPolyHost.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableSillyPolyHost ImmutableSillyPolyHost}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "SillyPolyHost", generator = "Immutables")
  @NotThreadSafe
  public static final class Builder {
    private ImmutableList.Builder<SillyAbstract> s = ImmutableList.builder();

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code SillyPolyHost} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * Collection elements and entries will be added, not replaced.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder from(SillyPolyHost instance) {
      Objects.requireNonNull(instance, "instance");
      addAllS(instance.s());
      return this;
    }

    /**
     * Adds one element to {@link SillyPolyHost#s() s} list.
     * @param element A s element
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addS(SillyAbstract element) {
      this.s.add(element);
      return this;
    }

    /**
     * Adds elements to {@link SillyPolyHost#s() s} list.
     * @param elements An array of s elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addS(SillyAbstract... elements) {
      this.s.add(elements);
      return this;
    }


    /**
     * Sets or replaces all elements for {@link SillyPolyHost#s() s} list.
     * @param elements An iterable of s elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder s(Iterable<? extends SillyAbstract> elements) {
      this.s = ImmutableList.builder();
      return addAllS(elements);
    }

    /**
     * Adds elements to {@link SillyPolyHost#s() s} list.
     * @param elements An iterable of s elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addAllS(Iterable<? extends SillyAbstract> elements) {
      this.s.addAll(elements);
      return this;
    }

    /**
     * Builds a new {@link ImmutableSillyPolyHost ImmutableSillyPolyHost}.
     * @return An immutable instance of SillyPolyHost
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableSillyPolyHost build() {
      return new ImmutableSillyPolyHost(s.build());
    }
  }
}
