package org.immutables.fixture;

import com.google.common.base.MoreObjects;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.errorprone.annotations.Var;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link GenericInheritence.Sub1}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableSub1.builder()}.
 */
@Generated(from = "GenericInheritence.Sub1", generator = "Immutables")
@SuppressWarnings({"all"})
@ParametersAreNonnullByDefault
@javax.annotation.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
@CheckReturnValue
public final class ImmutableSub1 implements GenericInheritence.Sub1 {
  private final String a;
  private final Integer b;

  private ImmutableSub1(String a, Integer b) {
    this.a = a;
    this.b = b;
  }

  /**
   * @return The value of the {@code a} attribute
   */
  @Override
  public String a() {
    return a;
  }

  /**
   * @return The value of the {@code b} attribute
   */
  @Override
  public Integer b() {
    return b;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link GenericInheritence.Sub1#a() a} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for a
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableSub1 withA(String value) {
    String newValue = Objects.requireNonNull(value, "a");
    if (this.a.equals(newValue)) return this;
    return new ImmutableSub1(newValue, this.b);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link GenericInheritence.Sub1#b() b} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for b
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableSub1 withB(Integer value) {
    Integer newValue = Objects.requireNonNull(value, "b");
    if (this.b.equals(newValue)) return this;
    return new ImmutableSub1(this.a, newValue);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableSub1} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableSub1
        && equalTo(0, (ImmutableSub1) another);
  }

  private boolean equalTo(int synthetic, ImmutableSub1 another) {
    return a.equals(another.a)
        && b.equals(another.b);
  }

  /**
   * Computes a hash code from attributes: {@code a}, {@code b}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    @Var int h = 5381;
    h += (h << 5) + a.hashCode();
    h += (h << 5) + b.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code Sub1} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return MoreObjects.toStringHelper("Sub1")
        .omitNullValues()
        .add("a", a)
        .add("b", b)
        .toString();
  }

  /**
   * Creates an immutable copy of a {@link GenericInheritence.Sub1} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable Sub1 instance
   */
  public static ImmutableSub1 copyOf(GenericInheritence.Sub1 instance) {
    if (instance instanceof ImmutableSub1) {
      return (ImmutableSub1) instance;
    }
    return ImmutableSub1.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableSub1 ImmutableSub1}.
   * <pre>
   * ImmutableSub1.builder()
   *    .a(String) // required {@link GenericInheritence.Sub1#a() a}
   *    .b(Integer) // required {@link GenericInheritence.Sub1#b() b}
   *    .build();
   * </pre>
   * @return A new ImmutableSub1 builder
   */
  public static ImmutableSub1.Builder builder() {
    return new ImmutableSub1.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableSub1 ImmutableSub1}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "GenericInheritence.Sub1", generator = "Immutables")
  @NotThreadSafe
  public static final class Builder {
    private static final long INIT_BIT_A = 0x1L;
    private static final long INIT_BIT_B = 0x2L;
    private long initBits = 0x3L;

    private @Nullable String a;
    private @Nullable Integer b;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code Sub1} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder from(GenericInheritence.Sub1 instance) {
      Objects.requireNonNull(instance, "instance");
      a(instance.a());
      b(instance.b());
      return this;
    }

    /**
     * Initializes the value for the {@link GenericInheritence.Sub1#a() a} attribute.
     * @param a The value for a 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder a(String a) {
      this.a = Objects.requireNonNull(a, "a");
      initBits &= ~INIT_BIT_A;
      return this;
    }

    /**
     * Initializes the value for the {@link GenericInheritence.Sub1#b() b} attribute.
     * @param b The value for b 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder b(Integer b) {
      this.b = Objects.requireNonNull(b, "b");
      initBits &= ~INIT_BIT_B;
      return this;
    }

    /**
     * Builds a new {@link ImmutableSub1 ImmutableSub1}.
     * @return An immutable instance of Sub1
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableSub1 build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new ImmutableSub1(a, b);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_A) != 0) attributes.add("a");
      if ((initBits & INIT_BIT_B) != 0) attributes.add("b");
      return "Cannot build Sub1, some of required attributes are not set " + attributes;
    }
  }
}
