package org.immutables.fixture;

import com.google.common.base.MoreObjects;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.errorprone.annotations.Var;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.ExecutionException;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link ThrowsClauses}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableThrowsClauses.builder()}.
 */
@Generated(from = "ThrowsClauses", generator = "Immutables")
@SuppressWarnings({"all"})
@ParametersAreNonnullByDefault
@javax.annotation.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
@CheckReturnValue
final class ImmutableThrowsClauses extends ThrowsClauses {
  private final int a;
  private final String b;

  private ImmutableThrowsClauses(ImmutableThrowsClauses.Builder builder) {
    this.a = builder.a;
    this.b = builder.b;
  }

  /**
   * @return The value of the {@code a} attribute
   */
  @Override
  int a() {
    return a;
  }

  /**
   * @return The value of the {@code b} attribute
   */
  @Override
  String b() {
    return b;
  }

  /**
   * This instance is equal to all instances of {@code ImmutableThrowsClauses} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableThrowsClauses
        && equalTo(0, (ImmutableThrowsClauses) another);
  }

  private boolean equalTo(int synthetic, ImmutableThrowsClauses another) {
    return a == another.a
        && b.equals(another.b);
  }

  /**
   * Computes a hash code from attributes: {@code a}, {@code b}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    @Var int h = 5381;
    h += (h << 5) + a;
    h += (h << 5) + b.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code ThrowsClauses} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return MoreObjects.toStringHelper("ThrowsClauses")
        .omitNullValues()
        .add("a", a)
        .add("b", b)
        .toString();
  }

  @SuppressWarnings("Immutable")
  private transient volatile long lazyInitBitmap;

  private static final long D_LAZY_INIT_BIT = 0x1L;

  @SuppressWarnings("Immutable")
  private transient boolean d;

  /**
   * {@inheritDoc}
   * <p>
   * Returns a lazily initialized value of the {@link ThrowsClauses#d() d} attribute.
   * Initialized once and only once and stored for subsequent access with proper synchronization.
   * In case of any exception or error thrown by the lazy value initializer,
   * the result will not be memoised (i.e. remembered) and on next call computation
   * will be attempted again.
   * @return A lazily initialized value of the {@code d} attribute
   * @throws java.util.concurrent.ExecutionException if undelying {@code d()} will throw it.
   * @throws java.io.IOException if undelying {@code d()} will throw it.
   */
  @Override
  boolean d() throws ExecutionException, IOException {
    if ((lazyInitBitmap & D_LAZY_INIT_BIT) == 0) {
      synchronized (this) {
        if ((lazyInitBitmap & D_LAZY_INIT_BIT) == 0) {
          this.d = super.d();
          lazyInitBitmap |= D_LAZY_INIT_BIT;
        }
      }
    }
    return d;
  }

  /**
   * Creates a builder for {@link ImmutableThrowsClauses ImmutableThrowsClauses}.
   * <pre>
   * ImmutableThrowsClauses.builder()
   *    .a(int) // required {@link ThrowsClauses#a() a}
   *    .b(String) // required {@link ThrowsClauses#b() b}
   *    .build();
   * </pre>
   * @return A new ImmutableThrowsClauses builder
   */
  public static ImmutableThrowsClauses.Builder builder() {
    return new ImmutableThrowsClauses.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableThrowsClauses ImmutableThrowsClauses}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "ThrowsClauses", generator = "Immutables")
  @NotThreadSafe
  public static final class Builder {
    private static final long INIT_BIT_A = 0x1L;
    private static final long INIT_BIT_B = 0x2L;
    private long initBits = 0x3L;

    private int a;
    private @Nullable String b;

    private Builder() {
    }

    /**
     * Initializes the value for the {@link ThrowsClauses#a() a} attribute.
     * @param a The value for a 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder a(int a) {
      checkNotIsSet(aIsSet(), "a");
      this.a = a;
      initBits &= ~INIT_BIT_A;
      return this;
    }

    /**
     * Initializes the value for the {@link ThrowsClauses#b() b} attribute.
     * @param b The value for b 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder b(String b) {
      checkNotIsSet(bIsSet(), "b");
      this.b = Objects.requireNonNull(b, "b");
      initBits &= ~INIT_BIT_B;
      return this;
    }

    /**
     * Builds a new {@link ImmutableThrowsClauses ImmutableThrowsClauses}.
     * @return An immutable instance of ThrowsClauses
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableThrowsClauses build() {
      checkRequiredAttributes();
      return new ImmutableThrowsClauses(this);
    }

    private boolean aIsSet() {
      return (initBits & INIT_BIT_A) == 0;
    }

    private boolean bIsSet() {
      return (initBits & INIT_BIT_B) == 0;
    }

    private static void checkNotIsSet(boolean isSet, String name) {
      if (isSet) throw new IllegalStateException("Builder of ThrowsClauses is strict, attribute is already set: ".concat(name));
    }

    private void checkRequiredAttributes() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if (!aIsSet()) attributes.add("a");
      if (!bIsSet()) attributes.add("b");
      return "Cannot build ThrowsClauses, some of required attributes are not set " + attributes;
    }
  }
}
