package org.immutables.fixture;

import com.google.common.base.MoreObjects;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.errorprone.annotations.Var;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import nonimmutables.NoNilType;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link WithThisCheckForNoNilString}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableWithThisCheckForNoNilString.builder()}.
 */
@Generated(from = "WithThisCheckForNoNilString", generator = "Immutables")
@SuppressWarnings({"all"})
@ParametersAreNonnullByDefault
@javax.annotation.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
@CheckReturnValue
public final class ImmutableWithThisCheckForNoNilString
    implements WithThisCheckForNoNilString {
  private final java.lang.@NoNilType String a;
  private final String b;

  private ImmutableWithThisCheckForNoNilString(java.lang.@NoNilType String a, String b) {
    this.a = a;
    this.b = b;
  }

  /**
   * @return The value of the {@code a} attribute
   */
  @Override
  public java.lang.@NoNilType String a() {
    return a;
  }

  /**
   * @return The value of the {@code b} attribute
   */
  @Override
  public String b() {
    return b;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link WithThisCheckForNoNilString#a() a} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for a
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableWithThisCheckForNoNilString withA(java.lang.@NoNilType String value) {
    java.lang.@NoNilType String newValue = Objects.requireNonNull(value, "a");
    if (this.a.equals(newValue)) return this;
    return new ImmutableWithThisCheckForNoNilString(newValue, this.b);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link WithThisCheckForNoNilString#b() b} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for b
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableWithThisCheckForNoNilString withB(String value) {
    String newValue = Objects.requireNonNull(value, "b");
    if (this.b.equals(newValue)) return this;
    return new ImmutableWithThisCheckForNoNilString(this.a, newValue);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableWithThisCheckForNoNilString} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableWithThisCheckForNoNilString
        && equalTo(0, (ImmutableWithThisCheckForNoNilString) another);
  }

  private boolean equalTo(int synthetic, ImmutableWithThisCheckForNoNilString another) {
    return a.equals(another.a)
        && b.equals(another.b);
  }

  /**
   * Computes a hash code from attributes: {@code a}, {@code b}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    @Var int h = 5381;
    h += (h << 5) + a.hashCode();
    h += (h << 5) + b.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code WithThisCheckForNoNilString} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return MoreObjects.toStringHelper("WithThisCheckForNoNilString")
        .omitNullValues()
        .add("a", a)
        .add("b", b)
        .toString();
  }

  /**
   * Creates an immutable copy of a {@link WithThisCheckForNoNilString} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable WithThisCheckForNoNilString instance
   */
  public static ImmutableWithThisCheckForNoNilString copyOf(WithThisCheckForNoNilString instance) {
    if (instance instanceof ImmutableWithThisCheckForNoNilString) {
      return (ImmutableWithThisCheckForNoNilString) instance;
    }
    return ImmutableWithThisCheckForNoNilString.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableWithThisCheckForNoNilString ImmutableWithThisCheckForNoNilString}.
   * <pre>
   * ImmutableWithThisCheckForNoNilString.builder()
   *    .a(@nonimmutables.NoNilType String) // required {@link WithThisCheckForNoNilString#a() a}
   *    .b(String) // required {@link WithThisCheckForNoNilString#b() b}
   *    .build();
   * </pre>
   * @return A new ImmutableWithThisCheckForNoNilString builder
   */
  public static ImmutableWithThisCheckForNoNilString.Builder builder() {
    return new ImmutableWithThisCheckForNoNilString.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableWithThisCheckForNoNilString ImmutableWithThisCheckForNoNilString}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "WithThisCheckForNoNilString", generator = "Immutables")
  @NotThreadSafe
  public static final class Builder {
    private static final long INIT_BIT_A = 0x1L;
    private static final long INIT_BIT_B = 0x2L;
    private long initBits = 0x3L;

    private @Nullable java.lang.@NoNilType String a;
    private @Nullable String b;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code WithThisCheckForNoNilString} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder from(WithThisCheckForNoNilString instance) {
      Objects.requireNonNull(instance, "instance");
      a(instance.a());
      b(instance.b());
      return this;
    }

    /**
     * Initializes the value for the {@link WithThisCheckForNoNilString#a() a} attribute.
     * @param a The value for a 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder a(java.lang.@NoNilType String a) {
      this.a = Objects.requireNonNull(a, "a");
      initBits &= ~INIT_BIT_A;
      return this;
    }

    /**
     * Initializes the value for the {@link WithThisCheckForNoNilString#b() b} attribute.
     * @param b The value for b 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder b(String b) {
      this.b = Objects.requireNonNull(b, "b");
      initBits &= ~INIT_BIT_B;
      return this;
    }

    /**
     * Builds a new {@link ImmutableWithThisCheckForNoNilString ImmutableWithThisCheckForNoNilString}.
     * @return An immutable instance of WithThisCheckForNoNilString
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableWithThisCheckForNoNilString build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new ImmutableWithThisCheckForNoNilString(a, b);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_A) != 0) attributes.add("a");
      if ((initBits & INIT_BIT_B) != 0) attributes.add("b");
      return "Cannot build WithThisCheckForNoNilString, some of required attributes are not set " + attributes;
    }
  }
}
