package org.immutables.fixture;

import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.util.Arrays;
import java.util.Objects;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

/**
 * A modifiable implementation of the {@link NullableRef NullableRef} type.
 * <p>Use the {@link #create()} static factory methods to create new instances.
 * Use the {@link #toImmutable()} method to convert to canonical immutable instances.
 * <p><em>ModifiableNullableRef is not thread-safe</em>
 * @see ImmutableNullableRef
 */
@Generated(from = "NullableRef", generator = "Modifiables")
@SuppressWarnings({"all"})
@ParametersAreNonnullByDefault
@javax.annotation.Generated({"Modifiables.generator", "NullableRef"})
@NotThreadSafe
final class ModifiableNullableRef extends NullableRef {
  private @Nullable Object[] refs;

  private ModifiableNullableRef() {}

  /**
   * Construct a modifiable instance of {@code NullableRef}.
   * @return A new modifiable instance
   */
  public static ModifiableNullableRef create() {
    return new ModifiableNullableRef();
  }

  /**
   * @return assigned modifiable {@code refs} array
   */
  @Override
  final @Nullable Object[] refs() {
    return refs;
  }

  /**
   * Clears the object by setting all attributes to their initial values.
   * @return {@code this} for use in a chained invocation
   */
  @CanIgnoreReturnValue
  public ModifiableNullableRef clear() {
    refs = null;
    return this;
  }

  /**
   * Fill this modifiable instance with attribute values from the provided {@link NullableRef} instance.
   * Regular attribute values will be overridden, i.e. replaced with ones of an instance.
   * Any of the instance's absent optional values will not be copied (will not override current values).
   * @param instance The instance from which to copy values
   * @return {@code this} for use in a chained invocation
   */
  public ModifiableNullableRef from(NullableRef instance) {
    Objects.requireNonNull(instance, "instance");
    if (instance instanceof ModifiableNullableRef) {
      from((ModifiableNullableRef) instance);
      return this;
    }
    @Nullable Object[] refsValue = instance.refs();
    if (refsValue != null) {
      setRefs(refsValue);
    }
    return this;
  }

  /**
   * Fill this modifiable instance with attribute values from the provided {@link NullableRef} instance.
   * Regular attribute values will be overridden, i.e. replaced with ones of an instance.
   * Any of the instance's absent optional values will not be copied (will not override current values).
   * @param instance The instance from which to copy values
   * @return {@code this} for use in a chained invocation
   */
  public ModifiableNullableRef from(ModifiableNullableRef instance) {
    Objects.requireNonNull(instance, "instance");
    @Nullable Object[] refsValue = instance.refs();
    if (refsValue != null) {
      setRefs(refsValue);
    }
    return this;
  }

  /**
   * Assigns a value to the {@link NullableRef#refs() refs} attribute.
   * @param elements The elements for refs
   * @return {@code this} for use in a chained invocation
   */
  @CanIgnoreReturnValue
  public final ModifiableNullableRef setRefs(Object... elements) {
    this.refs = elements == null ? null : elements.clone();
    return this;
  }


  /**
   * Returns {@code true} if all required attributes are set, indicating that the object is initialized.
   * @return {@code true} if set
   */
  public final boolean isInitialized() {
    return true;
  }

  /**
   * Converts to {@link ImmutableNullableRef ImmutableNullableRef}.
   * @return An immutable instance of NullableRef
   */
  public final ImmutableNullableRef toImmutable() {
    return ImmutableNullableRef.copyOf(this);
  }

  /**
   * This instance is equal to all instances of {@code ModifiableNullableRef} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    if (!(another instanceof ModifiableNullableRef)) return false;
    ModifiableNullableRef other = (ModifiableNullableRef) another;
    return equalTo(other);
  }

  private boolean equalTo(ModifiableNullableRef another) {
    return Arrays.equals(refs, another.refs);
  }

  /**
   * Computes a hash code from attributes: {@code refs}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + Arrays.hashCode(refs);
    return h;
  }

  /**
   * Generates a string representation of this {@code NullableRef}.
   * If uninitialized, some attribute values may appear as question marks.
   * @return A string representation
   */
  @Override
  public String toString() {
    return "ModifiableNullableRef{"
        + "refs=" + (Arrays.toString(refs()))
        + "}";
  }
}
