package org.immutables.fixture;

import com.google.common.annotations.Beta;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Range;
import com.google.common.primitives.UnsignedInteger;
import com.mongodb.DBCollection;
import com.mongodb.DBObject;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import javax.annotation.CheckReturnValue;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import javax.annotation.concurrent.ThreadSafe;
import org.bson.codecs.Encoder;
import org.bson.codecs.configuration.CodecRegistry;
import org.bson.conversions.Bson;
import org.immutables.mongo.concurrent.FluentFuture;
import org.immutables.mongo.repository.Repositories;
import org.immutables.mongo.repository.RepositorySetup;
import org.immutables.mongo.repository.internal.Constraints;
import org.immutables.mongo.repository.internal.Support;
import org.immutables.value.Generated;

/**
 * A {@code SillyEntityRepository} provides type-safe access for storing and retrieving documents
 * from the MongoDB collection {@code "sillyEntity"}.
 */
@Generated(from = "SillyEntity", generator = "Repositories")
@SuppressWarnings({"all"})
@ParametersAreNonnullByDefault
@javax.annotation.Generated("org.immutables.processor.ProxyProcessor")
@ThreadSafe
public class SillyEntityRepository extends Repositories.Repository<SillyEntity> {
  private static final String DOCUMENT_COLLECTION_NAME = "sillyEntity";

  private final Serialization serialization;
  private final Criteria anyCriteria;

  /**
   * Constructs a {@link SillyEntity} repository using {@link RepositorySetup configuration}.
   * @param configuration The repository configuration
   */
  public SillyEntityRepository(RepositorySetup configuration) {
    super(configuration, DOCUMENT_COLLECTION_NAME, SillyEntity.class);
    this.serialization = new Serialization(codecRegistry(), fieldNamingStrategy());
    this.anyCriteria = new Criteria(this.serialization, Constraints.nilConstraint());
  }

  /**
   * Inserts a single document into the collection.
   * @param document The sillyEntity to insert
   * @return A future representing the number of inserted documents (1) if WriteConcern allows the insertion.
   */
  public FluentFuture<Integer> insert(SillyEntity document) {
    return super.doInsert(ImmutableList.of(document));
  }

  /**
   * Insert documents into the collection.
   * @param documents The documents to insert
   * @return A future representing the number of inserted documents if WriteConcern allows the insertion.
   */
  public FluentFuture<Integer> insert(Iterable<? extends SillyEntity> documents) {
    return super.doInsert(ImmutableList.copyOf(documents));
  }

  /**
   * Finds all documents. Use the returned {@link Finder} object to complete
   * {@link Finder#fetchAll() fetch all} or other operations.
   * @return A finder object used to complete operations
   */
  @CheckReturnValue
  public Finder findAll() {
    return find(criteria());
  }

  /**
   * Find documents by the criteria expressed as a JSON string. Use the returned {@link Finder} object to complete
   * {@link Finder#fetchAll() fetch} or {@link Finder#fetchFirst() fetch} operations.
   * @param jsonCriteria A JSON string for native criteria
   * @return A finder object used to complete operations
   */
  @CheckReturnValue
  public Finder find(String jsonCriteria) {
    return new Finder(this, Support.jsonQuery(jsonCriteria));
  }

  /**
   * Find documents by the {@link SillyEntity#id() id} identity attribute. Use the returned {@link Finder} object to complete
   * {@link Finder#fetchFirst() fetch} or {@link Finder#fetchAll() fetchAll} read operations.
   * You can also use {@link Finder#andModifyFirst() modify}, {@link Finder#andReplaceFirst(SillyEntity) replace}
   * or {@link Finder#deleteFirst() delete} operations to update / delete the document.
   * @param id The exact {@code id} value
   * @return A finder object used to complete operations
   */
  @CheckReturnValue
  public Finder findById(int id) {
    return find(criteria().id(id));
  }

  /**
   * Update or insert a document, matched by the identifier value of the 'id' attribute.
   * @param document The sillyEntity to upsert
   * @return A future representing the of number of inserted documents (1) if WriteConcern allows the insertion.
   */
  public FluentFuture<Integer> upsert(SillyEntity document) {
    Criteria byId = criteria().id(document.id());
    return super.doUpsert(byId.constraint, document);
  }

  /**
   * Find a document by the given {@link SillyEntityRepository#criteria() criteria}. Use the returned {@link Finder} object to complete
   * {@link Finder#fetchAll() fetch}  operations.
   * You can also use {@link Finder#andModifyFirst() modify} or {@link Finder#deleteFirst() delete}
   * operations to update / delete the document(s).
   * @param criteria The search criteria
   * @return A finder object used to complete operations
   */
  @CheckReturnValue
  public Finder find(Criteria criteria) {
    return new Finder(this, criteria.constraint);
  }

  /**
   * The finder object used to proceed with find operations via the
   * {@link Finder#fetchAll()}, {@link Finder#fetchFirst()}, {@link Finder#andModifyFirst()}, or {@link Finder#deleteFirst()} methods.
   * Configure exclusion and sort ordering for results using the family of {@code exclude*()} and {@code orderBy*()} attribute-specific methods.
   * @see SillyEntityRepository#find(Criteria)
   */
  @Generated(from = "SillyEntity", generator = "Repositories")
  @NotThreadSafe
  public static final class Finder extends Repositories.FinderWithDelete<SillyEntity, Finder> {
    private final Serialization serialization;

    private Finder(SillyEntityRepository repository, Constraints.ConstraintHost criteria) {
      super(repository);
      this.criteria = criteria;
      this.serialization = repository.serialization;
    }

    /**
     * Order by {@link SillyEntity#id() id} in the ascending direction.
     * Specify that the next attribute to sort will be the {@link SillyEntity#id() id} attribute using ascending order
     * in the the chain of comparisons performed to sort results.
     * @return {@code this} finder for use in a chained invocation
     */
    public Finder orderById() {
      ordering = ordering.equal(serialization.idName, false, 1);
      return this;
    }

    /**
     * Order by {@link SillyEntity#id() id} in the descending direction.
     * Specify that the next attribute to sort will be the {@link SillyEntity#id() id} attribute using descending order
     * in the the chain of comparisons performed to sort results.
     * @return {@code this} finder for use in a chained invocation
     */
    public Finder orderByIdDesceding() {
      ordering = ordering.equal(serialization.idName, false, -1);
      return this;
    }

    /**
     * Order by {@link SillyEntity#val() val} in the ascending direction.
     * Specify that the next attribute to sort will be the {@link SillyEntity#val() val} attribute using ascending order
     * in the the chain of comparisons performed to sort results.
     * @return {@code this} finder for use in a chained invocation
     */
    public Finder orderByVal() {
      ordering = ordering.equal(serialization.valName, false, 1);
      return this;
    }

    /**
     * Order by {@link SillyEntity#val() val} in the descending direction.
     * Specify that the next attribute to sort will be the {@link SillyEntity#val() val} attribute using descending order
     * in the the chain of comparisons performed to sort results.
     * @return {@code this} finder for use in a chained invocation
     */
    public Finder orderByValDesceding() {
      ordering = ordering.equal(serialization.valName, false, -1);
      return this;
    }

    /**
     * Order by {@link SillyEntity#payload() payload} in the ascending direction.
     * Specify that the next attribute to sort will be the {@link SillyEntity#payload() payload} attribute using ascending order
     * in the the chain of comparisons performed to sort results.
     * @return {@code this} finder for use in a chained invocation
     */
    public Finder orderByPayload() {
      ordering = ordering.equal(serialization.payloadName, false, 1);
      return this;
    }

    /**
     * Order by {@link SillyEntity#payload() payload} in the descending direction.
     * Specify that the next attribute to sort will be the {@link SillyEntity#payload() payload} attribute using descending order
     * in the the chain of comparisons performed to sort results.
     * @return {@code this} finder for use in a chained invocation
     */
    public Finder orderByPayloadDesceding() {
      ordering = ordering.equal(serialization.payloadName, false, -1);
      return this;
    }

    /**
     * Order by {@link SillyEntity#ints() ints} in the ascending direction.
     * Specify that the next attribute to sort will be the {@link SillyEntity#ints() ints} attribute using ascending order
     * in the the chain of comparisons performed to sort results.
     * @return {@code this} finder for use in a chained invocation
     */
    public Finder orderByInts() {
      ordering = ordering.equal(serialization.intsName, false, 1);
      return this;
    }

    /**
     * Order by {@link SillyEntity#ints() ints} in the descending direction.
     * Specify that the next attribute to sort will be the {@link SillyEntity#ints() ints} attribute using descending order
     * in the the chain of comparisons performed to sort results.
     * @return {@code this} finder for use in a chained invocation
     */
    public Finder orderByIntsDesceding() {
      ordering = ordering.equal(serialization.intsName, false, -1);
      return this;
    }

    /**
     * Order by {@link SillyEntity#der() der} in the ascending direction.
     * Specify that the next attribute to sort will be the {@link SillyEntity#der() der} attribute using ascending order
     * in the the chain of comparisons performed to sort results.
     * @return {@code this} finder for use in a chained invocation
     */
    public Finder orderByDer() {
      ordering = ordering.equal(serialization.derName, false, 1);
      return this;
    }

    /**
     * Order by {@link SillyEntity#der() der} in the descending direction.
     * Specify that the next attribute to sort will be the {@link SillyEntity#der() der} attribute using descending order
     * in the the chain of comparisons performed to sort results.
     * @return {@code this} finder for use in a chained invocation
     */
    public Finder orderByDerDesceding() {
      ordering = ordering.equal(serialization.derName, false, -1);
      return this;
    }

    /**
     * Exclude the {@link SillyEntity#payload() payload} attribute from each document in the results.
     * @return {@code this} finder for use in a chained invocation
     */
    public Finder excludePayload() {
      exclusion = exclusion.equal(serialization.payloadName, false, -1);
      return this;
    }

    /**
     * Exclude the {@link SillyEntity#ints() ints} attribute from each document in the results.
     * @return {@code this} finder for use in a chained invocation
     */
    public Finder excludeInts() {
      exclusion = exclusion.equal(serialization.intsName, false, -1);
      return this;
    }

    /**
     * Turn a find operation into an atomic {@link DBCollection#findAndModify(DBObject, DBObject, DBObject, boolean, DBObject, boolean, boolean) findAndModify}
     * operation. Use the family of {@code set*()}, {@code unset*()}, {@code add*()}, {@code remove*()}, {@code put*()}m and {@code init*()}
     * (and other attribute-specific) methods to describe the modification.
     * @return A modifier object to complete the {@code findAndModify} operation
     */
    @CheckReturnValue
    public Modifier andModifyFirst() {
      return new Modifier((SillyEntityRepository) repository, criteria, ordering, exclusion);
    }

    /**
     * Used to replace in-place existing version of the document
     */
    @CheckReturnValue
    public Replacer andReplaceFirst(SillyEntity document) {
      return new Replacer((SillyEntityRepository) repository, document, criteria, ordering);
    }
  }

  /**
   * Update the set of {@code "sillyEntity"} documents.
   * @param criteria The search criteria for update
   * @return An updater object that will be used to complete the update.
   */
  @CheckReturnValue
  public Updater update(Criteria criteria) {
    return new Updater(this, criteria);
  }

  /**
   * {@link #update(Criteria) Given} the criteria updater describes how to perform
   * update operations on sets of documents.
   */
  @Generated(from = "SillyEntity", generator = "Repositories")
  @NotThreadSafe
  public static final class Updater extends Repositories.Updater<SillyEntity> {
    private final Serialization serialization;

    private Updater(SillyEntityRepository repository, Criteria criteria) {
      super(repository);
      this.criteria = criteria.constraint;
      this.serialization = repository.serialization;
    }

    /**
     * Specify a new value for the {@code id} attribute.
     * <p>
     * Corresponds to the MongoDB {@code $set} operator.
     * @param value A new value for the {@code id} attribute
     * @return {@code this} updater to be used to complete the update operation
     */
    public Updater setId(int value) {
      setFields = setFields.equal(serialization.idName, false, Support.writable(value));
      return this;
    }

    /**
     * Specify an initial value for the {@code id} attribute. The value will be used if the document is
     * to be inserted. If one or more documents are found for an update, this value will not be used.
     * <p>
     * Corresponds to the MongoDB {@code $setOnInsert} operator.
     * @param value The {@code id} value for an insert.
     * @return {@code this} updater to be used to complete the update operation
     */
    public Updater initId(int value) {
      setOnInsertFields = setOnInsertFields.equal(serialization.idName, false, Support.writable(value));
      return this;
    }

    /**
     * Specify an increment amount for the {@code id} attribute. If the document is to inserted
     * and no initial value has been provided, then {@code 0} will be the default value and the increment will adjust it.
     * <p>
     * Corresponds to the MongoDB {@code $inc} operator.
     * @param increment An amount by which to increment the {@code id} attribute (may be negative)
     * @return {@code this} updater to be used to complete the update operation
     */
    public Updater incrementId(int increment) {
      incrementFields = incrementFields.equal(serialization.idName, false, increment);
      return this;
    }

    /**
     * Specify a new value for the {@code val} attribute.
     * <p>
     * Corresponds to the MongoDB {@code $set} operator.
     * @param value A new value for the {@code val} attribute
     * @return {@code this} updater to be used to complete the update operation
     */
    public Updater setVal(java.lang.String value) {
      setFields = setFields.equal(serialization.valName, false, Support.writable(value));
      return this;
    }

    /**
     * Specify an initial value for the {@code val} attribute. The value will be used if the document is
     * to be inserted. If one or more documents are found for an update, this value will not be used.
     * <p>
     * Corresponds to the MongoDB {@code $setOnInsert} operator.
     * @param value The {@code val} value for an insert.
     * @return {@code this} updater to be used to complete the update operation
     */
    public Updater initVal(java.lang.String value) {
      setOnInsertFields = setOnInsertFields.equal(serialization.valName, false, Support.writable(value));
      return this;
    }


    /**
     * Clear the {@code payload} map attribute.
     * <p>
     * Corresponds to the MongoDB {@code $set} operator, used to reset to empty object
     * @return {@code this} updater to be used to complete the update operation
     */
    public Updater clearPayload() {
      setFields = setFields.equal(serialization.payloadName, false, Support.emptyBsonObject());
      return this;
    }

    /**
     * Put the given key and value into the {@code payload} map attribute.
     * <p>
     * Corresponds to the MongoDB {@code $set} operator for nested objects
     * @param key The key
     * @param value The value
     * @return {@code this} updater to be used to complete the update operation
     */
    public Updater putPayload(java.lang.String key, int value) {
      setFields = setFields.equal(serialization.payloadName + "." + key, false, Support.writable(serialization.payloadSecondaryEncoder, value));
      return this;
    }

    /**
     * Remove the key to value mapping from the {@code payload} map attribute.
     * <p>
     * Corresponds to MongoDB {@code $unset} operator for nested objects
     * @param key The key
     * @return {@code this} updater to be used to complete the update operation
     */
    public Updater removePayload(java.lang.String key) {
      unsetFields = unsetFields.equal(serialization.payloadName + "." + key, false, 1);
      return this;
    }

    /**
     * Clear the {@code ints} list attribute.
     * <p>
     * Corresponds to the MongoDB {@code $set} operator resetting to empty array
     * @return {@code this} updater to be used to complete the update operation
     */
    public Updater clearInts() {
      setFields = setFields.equal(serialization.intsName, false, ImmutableList.<Object>of());
      return this;
    }

    /**
     * Remove a value from the {@code ints} list attribute.
     * <p>
     * Corresponds to the MongoDB {@code $pull} operator.
     * @param value The value to remove
     * @return {@code this} updater to be used to complete the update operation
     */
    public Updater removeInts(int value) {
      pullFields = pullFields.equal(serialization.intsName, false, Support.writable(serialization.intsEncoder, value));
      return this;
    }

    /**
     * Add a value to the {@code ints} list attribute.
     * <p>
     * Corresponds to the MongoDB {@code $push} operator.
     * @param value The value to add
     * @return {@code this} updater to be used to complete the update operation
     */
    public Updater addInts(int value) {
      pushFields = pushFields.equal(serialization.intsName, false, Support.writable(serialization.intsEncoder, value));
      return this;
    }

    /**
     * Override all values of {@code ints} list attribute.
     *
     * <p>Corresponds to the MongoDB {@code $set} operator on the array field.
     * @param values The values to set
     * @return {@code this} updater to be used to complete the update operation
     */
     public Updater setInts(Iterable<java.lang.Integer> values) {
       List<Object> wrappedValues = new ArrayList<>();
       for (java.lang.Integer value : values) {
         wrappedValues.add(Support.writable(serialization.intsEncoder, value));
       }

       setFields = setFields.equal(serialization.intsName, false, wrappedValues);
       return this;
     }

    /**
     * Add all of the given values to the {@code ints} list attribute.
     * <p>
     * Corresponds to the MongoDB {@code $push} operator with the {@code $each} modifier.
     * @param values The values to add
     * @return {@code this} updater to be used to complete the update operation
     */
    public Updater addAllInts(Iterable<java.lang.Integer> values) {
      List<Object> wrappedValues = new ArrayList<>();
      for (java.lang.Integer value : values) {
        wrappedValues.add(Support.writable(serialization.intsEncoder, value));
      }
      if (wrappedValues.isEmpty()) {
        return this;
      }
      Object v = wrappedValues.size() == 1
          ? wrappedValues.get(0)
          : Support.bsonObjectAttribute("$each", wrappedValues);

      pushFields = pushFields.equal(serialization.intsName, false, v);
      return this;
    }


    /**
     * Specify a new value for the {@code der} attribute.
     * <p>
     * Corresponds to the MongoDB {@code $set} operator.
     * @param value A new value for the {@code der} attribute
     * @return {@code this} updater to be used to complete the update operation
     */
    public Updater setDer(UnsignedInteger value) {
      setFields = setFields.equal(serialization.derName, false, Support.writable(serialization.derEncoder, value));
      return this;
    }

    /**
     * Specify an initial value for the {@code der} attribute. The value will be used if the document is
     * to be inserted. If one or more documents are found for an update, this value will not be used.
     * <p>
     * Corresponds to the MongoDB {@code $setOnInsert} operator.
     * @param value The {@code der} value for an insert.
     * @return {@code this} updater to be used to complete the update operation
     */
    public Updater initDer(UnsignedInteger value) {
      setOnInsertFields = setOnInsertFields.equal(serialization.derName, false, Support.writable(serialization.derEncoder, value));
      return this;
    }

  }

  @Generated(from = "SillyEntity", generator = "Repositories")
  @NotThreadSafe
  public static final class Modifier extends Repositories.Modifier<SillyEntity, Modifier> {
    private final Serialization serialization;

    private Modifier(
        SillyEntityRepository repository,
        Constraints.ConstraintHost criteria,
        Constraints.Constraint ordering,
        Constraints.Constraint exclusion) {
      super(repository);
      this.serialization = repository.serialization;
      this.criteria = criteria;
      this.ordering = ordering;
      this.exclusion = exclusion;
    }

    /**
     * Specify a new value for the {@code id} attribute.
     * <p>
     * Corresponds to the MongoDB {@code $set} operator.
     * @param value A new value for the {@code id} attribute
     * @return {@code this} modifier to be used to complete the update operation
     */
    public Modifier setId(int value) {
      setFields = setFields.equal(serialization.idName, false, Support.writable(value));
      return this;
    }

    /**
     * Specify an initial value for the {@code id} attribute. The value will be used if the document is
     * to be inserted. If one or more documents are found for an update, this value will not be used.
     * <p>
     * Corresponds to the MongoDB {@code $setOnInsert} operator.
     * @param value The {@code id} value for an insert.
     * @return {@code this} modifier to be used to complete the update operation
     */
    public Modifier initId(int value) {
      setOnInsertFields = setOnInsertFields.equal(serialization.idName, false, Support.writable(value));
      return this;
    }

    /**
     * Specify an increment amount for the {@code id} attribute. If the document is to inserted
     * and no initial value has been provided, then {@code 0} will be the default value and the increment will adjust it.
     * <p>
     * Corresponds to the MongoDB {@code $inc} operator.
     * @param increment An amount by which to increment the {@code id} attribute (may be negative)
     * @return {@code this} modifier to be used to complete the update operation
     */
    public Modifier incrementId(int increment) {
      incrementFields = incrementFields.equal(serialization.idName, false, increment);
      return this;
    }

    /**
     * Specify a new value for the {@code val} attribute.
     * <p>
     * Corresponds to the MongoDB {@code $set} operator.
     * @param value A new value for the {@code val} attribute
     * @return {@code this} modifier to be used to complete the update operation
     */
    public Modifier setVal(java.lang.String value) {
      setFields = setFields.equal(serialization.valName, false, Support.writable(value));
      return this;
    }

    /**
     * Specify an initial value for the {@code val} attribute. The value will be used if the document is
     * to be inserted. If one or more documents are found for an update, this value will not be used.
     * <p>
     * Corresponds to the MongoDB {@code $setOnInsert} operator.
     * @param value The {@code val} value for an insert.
     * @return {@code this} modifier to be used to complete the update operation
     */
    public Modifier initVal(java.lang.String value) {
      setOnInsertFields = setOnInsertFields.equal(serialization.valName, false, Support.writable(value));
      return this;
    }


    /**
     * Clear the {@code payload} map attribute.
     * <p>
     * Corresponds to the MongoDB {@code $set} operator, used to reset to empty object
     * @return {@code this} modifier to be used to complete the update operation
     */
    public Modifier clearPayload() {
      setFields = setFields.equal(serialization.payloadName, false, Support.emptyBsonObject());
      return this;
    }

    /**
     * Put the given key and value into the {@code payload} map attribute.
     * <p>
     * Corresponds to the MongoDB {@code $set} operator for nested objects
     * @param key The key
     * @param value The value
     * @return {@code this} modifier to be used to complete the update operation
     */
    public Modifier putPayload(java.lang.String key, int value) {
      setFields = setFields.equal(serialization.payloadName + "." + key, false, Support.writable(serialization.payloadSecondaryEncoder, value));
      return this;
    }

    /**
     * Remove the key to value mapping from the {@code payload} map attribute.
     * <p>
     * Corresponds to MongoDB {@code $unset} operator for nested objects
     * @param key The key
     * @return {@code this} modifier to be used to complete the update operation
     */
    public Modifier removePayload(java.lang.String key) {
      unsetFields = unsetFields.equal(serialization.payloadName + "." + key, false, 1);
      return this;
    }

    /**
     * Clear the {@code ints} list attribute.
     * <p>
     * Corresponds to the MongoDB {@code $set} operator resetting to empty array
     * @return {@code this} modifier to be used to complete the update operation
     */
    public Modifier clearInts() {
      setFields = setFields.equal(serialization.intsName, false, ImmutableList.<Object>of());
      return this;
    }

    /**
     * Remove a value from the {@code ints} list attribute.
     * <p>
     * Corresponds to the MongoDB {@code $pull} operator.
     * @param value The value to remove
     * @return {@code this} modifier to be used to complete the update operation
     */
    public Modifier removeInts(int value) {
      pullFields = pullFields.equal(serialization.intsName, false, Support.writable(serialization.intsEncoder, value));
      return this;
    }

    /**
     * Add a value to the {@code ints} list attribute.
     * <p>
     * Corresponds to the MongoDB {@code $push} operator.
     * @param value The value to add
     * @return {@code this} modifier to be used to complete the update operation
     */
    public Modifier addInts(int value) {
      pushFields = pushFields.equal(serialization.intsName, false, Support.writable(serialization.intsEncoder, value));
      return this;
    }

    /**
     * Override all values of {@code ints} list attribute.
     *
     * <p>Corresponds to the MongoDB {@code $set} operator on the array field.
     * @param values The values to set
     * @return {@code this} modifier to be used to complete the update operation
     */
     public Modifier setInts(Iterable<java.lang.Integer> values) {
       List<Object> wrappedValues = new ArrayList<>();
       for (java.lang.Integer value : values) {
         wrappedValues.add(Support.writable(serialization.intsEncoder, value));
       }

       setFields = setFields.equal(serialization.intsName, false, wrappedValues);
       return this;
     }

    /**
     * Add all of the given values to the {@code ints} list attribute.
     * <p>
     * Corresponds to the MongoDB {@code $push} operator with the {@code $each} modifier.
     * @param values The values to add
     * @return {@code this} modifier to be used to complete the update operation
     */
    public Modifier addAllInts(Iterable<java.lang.Integer> values) {
      List<Object> wrappedValues = new ArrayList<>();
      for (java.lang.Integer value : values) {
        wrappedValues.add(Support.writable(serialization.intsEncoder, value));
      }
      if (wrappedValues.isEmpty()) {
        return this;
      }
      Object v = wrappedValues.size() == 1
          ? wrappedValues.get(0)
          : Support.bsonObjectAttribute("$each", wrappedValues);

      pushFields = pushFields.equal(serialization.intsName, false, v);
      return this;
    }


    /**
     * Specify a new value for the {@code der} attribute.
     * <p>
     * Corresponds to the MongoDB {@code $set} operator.
     * @param value A new value for the {@code der} attribute
     * @return {@code this} modifier to be used to complete the update operation
     */
    public Modifier setDer(UnsignedInteger value) {
      setFields = setFields.equal(serialization.derName, false, Support.writable(serialization.derEncoder, value));
      return this;
    }

    /**
     * Specify an initial value for the {@code der} attribute. The value will be used if the document is
     * to be inserted. If one or more documents are found for an update, this value will not be used.
     * <p>
     * Corresponds to the MongoDB {@code $setOnInsert} operator.
     * @param value The {@code der} value for an insert.
     * @return {@code this} modifier to be used to complete the update operation
     */
    public Modifier initDer(UnsignedInteger value) {
      setOnInsertFields = setOnInsertFields.equal(serialization.derName, false, Support.writable(serialization.derEncoder, value));
      return this;
    }

  }

  @Generated(from = "SillyEntity", generator = "Repositories")
  @NotThreadSafe
  public static final class Replacer extends Repositories.Replacer<SillyEntity, Replacer> {
    protected Replacer(SillyEntityRepository repository, SillyEntity document, Constraints.ConstraintHost criteria, Constraints.Constraint ordering) {
      super(repository, document, criteria, ordering);
    }
  }

  /**
   * {@link DBCollection#createIndex(DBObject, DBObject) Ensure an index} on collection sillyEntity by one or
   * more attributes using the family of {@code with*()} attribute-specific methods.
   * While indexes will usually be maintained by special administration scripts, for simple cases it is convenient
   * to ensure an index on application startup.
   * @see Indexer#named(String)
   * @see Indexer#unique()
   * @return An indexer object to be completed with the {@link Indexer#ensure()} operation.
   */
  @CheckReturnValue
  public Indexer index() {
    return new Indexer(this);
  }

  /**
   * An indexer used to create an index on the {@code "sillyEntity"} collection if it does not exist by one or more attributes.
   * @see DBCollection#createIndex(DBObject, DBObject)
   */
  @Generated(from = "SillyEntity", generator = "Repositories")
  @NotThreadSafe
  public static final class Indexer extends Repositories.Indexer<SillyEntity, Indexer> {
    private final Serialization serialization;

    private Indexer(SillyEntityRepository repository) {
      super(repository);
      this.serialization = repository.serialization;
    }

    /**
     * Specify that the next attribute to index will be {@link SillyEntity#id() id}, in the ascending direction.
     * @return {@code this} indexer for use in a chained invocation
     */
    public Indexer withId() {
      fields = fields.equal(serialization.idName, false, 1);
      return this;
    }

    /**
     * Specify that the next attribute to index will be {@link SillyEntity#id() id}, in the descending direction.
     * @return {@code this} indexer for use in a chained invocation
     */
    public Indexer withIdDesceding() {
      fields = fields.equal(serialization.idName, false, -1);
      return this;
    }

    /**
     * Specify that the next attribute to index will be {@link SillyEntity#val() val}, in the ascending direction.
     * @return {@code this} indexer for use in a chained invocation
     */
    public Indexer withVal() {
      fields = fields.equal(serialization.valName, false, 1);
      return this;
    }

    /**
     * Specify that the next attribute to index will be {@link SillyEntity#val() val}, in the descending direction.
     * @return {@code this} indexer for use in a chained invocation
     */
    public Indexer withValDesceding() {
      fields = fields.equal(serialization.valName, false, -1);
      return this;
    }

    /**
     * Specify that the next attribute to index will be {@link SillyEntity#payload() payload}, in the ascending direction.
     * @return {@code this} indexer for use in a chained invocation
     */
    public Indexer withPayload() {
      fields = fields.equal(serialization.payloadName, false, 1);
      return this;
    }

    /**
     * Specify that the next attribute to index will be {@link SillyEntity#payload() payload}, in the descending direction.
     * @return {@code this} indexer for use in a chained invocation
     */
    public Indexer withPayloadDesceding() {
      fields = fields.equal(serialization.payloadName, false, -1);
      return this;
    }

    /**
     * Specify that the next attribute to index will be {@link SillyEntity#ints() ints}, in the ascending direction.
     * @return {@code this} indexer for use in a chained invocation
     */
    public Indexer withInts() {
      fields = fields.equal(serialization.intsName, false, 1);
      return this;
    }

    /**
     * Specify that the next attribute to index will be {@link SillyEntity#ints() ints}, in the descending direction.
     * @return {@code this} indexer for use in a chained invocation
     */
    public Indexer withIntsDesceding() {
      fields = fields.equal(serialization.intsName, false, -1);
      return this;
    }

    /**
     * Specify that the next attribute to index will be {@link SillyEntity#der() der}, in the ascending direction.
     * @return {@code this} indexer for use in a chained invocation
     */
    public Indexer withDer() {
      fields = fields.equal(serialization.derName, false, 1);
      return this;
    }

    /**
     * Specify that the next attribute to index will be {@link SillyEntity#der() der}, in the descending direction.
     * @return {@code this} indexer for use in a chained invocation
     */
    public Indexer withDerDesceding() {
      fields = fields.equal(serialization.derName, false, -1);
      return this;
    }
  }

  /**
   * Search criteria.
   * Returns an initial object to create criteria by invoking methods that describe attribute specific constraints.
   * @return An empty immutable criteria
   */
  public Criteria criteria() {
    return anyCriteria;
  }

  @Beta
  Bson toBson(Criteria criteria) {
    return Support.convertToBson(criteria.constraint);
  }

  /**
   * {@code SillyEntityRepository.Criteria} is a SillyEntity document search query.
   * Call methods on the criteria to add constraints for search queries.
   */
  @Generated(from = "SillyEntity", generator = "Repositories")
  @Immutable
  @SuppressWarnings("unchecked")
  public static final class Criteria extends Repositories.Criteria {
    private final Constraints.Constraint constraint;
    private final Serialization serialization;

    Criteria(Serialization serialization, Constraints.Constraint constraint) {
      this.constraint = constraint;
      this.serialization = serialization;
    }

    public Criteria id(int value) {
      return new Criteria(serialization, constraint.equal(serialization.idName, false, Support.writable(value)));
    }

    public Criteria idNot(int value) {
      return new Criteria(serialization, constraint.equal(serialization.idName, true, Support.writable(value)));
    }

    public Criteria idIn(Iterable<java.lang.Integer> values) {
      List<Object> wrappedValues = new ArrayList<>();
      for (java.lang.Integer value : values) {
        wrappedValues.add(Support.writable(value));
      }
      return new Criteria(serialization, constraint.in(serialization.idName, false, wrappedValues));
    }

    public Criteria idIn(int first, int second, int... rest) {
      List<Object> values = new ArrayList<>(2 + rest.length);
      values.add(Support.writable(first));
      values.add(Support.writable(second));
      for (int value : rest) {
        values.add(Support.writable(value));
      }
      return new Criteria(serialization, constraint.in(serialization.idName, false, values));
    }

    public Criteria idNotIn(Iterable<java.lang.Integer> values) {
      List<Object> wrappedValues = new ArrayList<>();
      for (java.lang.Integer value : values) {
        wrappedValues.add(Support.writable(value));
      }
      return new Criteria(serialization, constraint.in(serialization.idName, true, wrappedValues));
    }

    public Criteria idNotIn(int first, int second, int... rest) {
      List<Object> values = new ArrayList<>(2 + rest.length);
      values.add(Support.writable(first));
      values.add(Support.writable(second));
      for (int value : rest) {
        values.add(Support.writable(value));
      }
      return new Criteria(serialization, constraint.in(serialization.idName, true, values));
    }

    public Criteria idGreaterThan(int lower) {
      return idIn(Range.greaterThan(lower));
    }

    public Criteria idLessThan(int upper) {
      return idIn(Range.lessThan(upper));
    }

    public Criteria idAtMost(int upperInclusive) {
      return idIn(Range.atMost(upperInclusive));
    }

    public Criteria idAtLeast(int lowerInclusive) {
      return idIn(Range.atLeast(lowerInclusive));
    }

    public Criteria idIn(Range<java.lang.Integer> range) {
      return new Criteria(serialization, constraint.range(serialization.idName, false, Support.writable(range)));
    }

    public Criteria idNotIn(Range<java.lang.Integer> range) {
      return new Criteria(serialization, constraint.range(serialization.idName, true, Support.writable(range)));
    }

    public Criteria val(java.lang.String value) {
      return new Criteria(serialization, constraint.equal(serialization.valName, false, Support.writable(value)));
    }

    public Criteria valNot(java.lang.String value) {
      return new Criteria(serialization, constraint.equal(serialization.valName, true, Support.writable(value)));
    }

    public Criteria valIn(Iterable<java.lang.String> values) {
      List<Object> wrappedValues = new ArrayList<>();
      for (java.lang.String value : values) {
        wrappedValues.add(Support.writable(value));
      }
      return new Criteria(serialization, constraint.in(serialization.valName, false, wrappedValues));
    }

    public Criteria valIn(java.lang.String first, java.lang.String second, java.lang.String... rest) {
      List<Object> values = new ArrayList<>(2 + rest.length);
      values.add(Support.writable(first));
      values.add(Support.writable(second));
      for (java.lang.String value : rest) {
        values.add(Support.writable(value));
      }
      return new Criteria(serialization, constraint.in(serialization.valName, false, values));
    }

    public Criteria valNotIn(Iterable<java.lang.String> values) {
      List<Object> wrappedValues = new ArrayList<>();
      for (java.lang.String value : values) {
        wrappedValues.add(Support.writable(value));
      }
      return new Criteria(serialization, constraint.in(serialization.valName, true, wrappedValues));
    }

    public Criteria valNotIn(java.lang.String first, java.lang.String second, java.lang.String... rest) {
      List<Object> values = new ArrayList<>(2 + rest.length);
      values.add(Support.writable(first));
      values.add(Support.writable(second));
      for (java.lang.String value : rest) {
        values.add(Support.writable(value));
      }
      return new Criteria(serialization, constraint.in(serialization.valName, true, values));
    }

    public Criteria valStartsWith(String prefix) {
      return new Criteria(serialization, constraint.match(serialization.valName, false, Constraints.prefixPatternOf(prefix)));
    }

    public Criteria valMatches(Pattern pattern) {
      return new Criteria(serialization, constraint.match(serialization.valName, false, pattern));
    }

    public Criteria valNotMatches(Pattern pattern) {
      return new Criteria(serialization, constraint.match(serialization.valName, true, pattern));
    }

    public Criteria valGreaterThan(java.lang.String lower) {
      return valIn(Range.greaterThan(lower));
    }

    public Criteria valLessThan(java.lang.String upper) {
      return valIn(Range.lessThan(upper));
    }

    public Criteria valAtMost(java.lang.String upperInclusive) {
      return valIn(Range.atMost(upperInclusive));
    }

    public Criteria valAtLeast(java.lang.String lowerInclusive) {
      return valIn(Range.atLeast(lowerInclusive));
    }

    public Criteria valIn(Range<java.lang.String> range) {
      return new Criteria(serialization, constraint.range(serialization.valName, false, Support.writable(range)));
    }

    public Criteria valNotIn(Range<java.lang.String> range) {
      return new Criteria(serialization, constraint.range(serialization.valName, true, Support.writable(range)));
    }

    public Criteria payload(java.lang.String value) {
      return new Criteria(serialization, constraint.equal(serialization.payloadName, false, Support.writable(value)));
    }

    public Criteria payloadNot(java.lang.String value) {
      return new Criteria(serialization, constraint.equal(serialization.payloadName, true, Support.writable(value)));
    }

    public Criteria payloadIn(Iterable<java.lang.String> values) {
      List<Object> wrappedValues = new ArrayList<>();
      for (java.lang.String value : values) {
        wrappedValues.add(Support.writable(value));
      }
      return new Criteria(serialization, constraint.in(serialization.payloadName, false, wrappedValues));
    }

    public Criteria payloadIn(java.lang.String first, java.lang.String second, java.lang.String... rest) {
      List<Object> values = new ArrayList<>(2 + rest.length);
      values.add(Support.writable(first));
      values.add(Support.writable(second));
      for (java.lang.String value : rest) {
        values.add(Support.writable(value));
      }
      return new Criteria(serialization, constraint.in(serialization.payloadName, false, values));
    }

    public Criteria payloadNotIn(Iterable<java.lang.String> values) {
      List<Object> wrappedValues = new ArrayList<>();
      for (java.lang.String value : values) {
        wrappedValues.add(Support.writable(value));
      }
      return new Criteria(serialization, constraint.in(serialization.payloadName, true, wrappedValues));
    }

    public Criteria payloadNotIn(java.lang.String first, java.lang.String second, java.lang.String... rest) {
      List<Object> values = new ArrayList<>(2 + rest.length);
      values.add(Support.writable(first));
      values.add(Support.writable(second));
      for (java.lang.String value : rest) {
        values.add(Support.writable(value));
      }
      return new Criteria(serialization, constraint.in(serialization.payloadName, true, values));
    }

    public Criteria intsEmpty() {
      return new Criteria(serialization, constraint.size(serialization.intsName, false, 0));
    }

    public Criteria intsNonEmpty() {
      return new Criteria(serialization, constraint.size(serialization.intsName, true, 0));
    }

    public Criteria intsSize(int size) {
      return new Criteria(serialization, constraint.size(serialization.intsName, false, size));
    }

    public Criteria intsContains(int value) {
      return new Criteria(serialization, constraint.equal(serialization.intsName, false, Support.writable(serialization.intsEncoder, value)));
    }

    public Criteria intsContainsAll(Iterable<java.lang.Integer> values) {
      List<Object> wrappedValues = new ArrayList<>();
      for (java.lang.Integer value : values) {
        wrappedValues.add(Support.writable(serialization.intsEncoder, value));
      }
      return new Criteria(serialization, constraint.nested(serialization.intsName, Constraints.nilConstraint().equal("$all", false, wrappedValues)));
    }

    public Criteria der(UnsignedInteger value) {
      return new Criteria(serialization, constraint.equal(serialization.derName, false, Support.writable(serialization.derEncoder, value)));
    }

    public Criteria derNot(UnsignedInteger value) {
      return new Criteria(serialization, constraint.equal(serialization.derName, true, Support.writable(serialization.derEncoder, value)));
    }

    public Criteria derIn(Iterable<UnsignedInteger> values) {
      List<Object> wrappedValues = new ArrayList<>();
      for (UnsignedInteger value : values) {
        wrappedValues.add(Support.writable(serialization.derEncoder, value));
      }
      return new Criteria(serialization, constraint.in(serialization.derName, false, wrappedValues));
    }

    public Criteria derIn(UnsignedInteger first, UnsignedInteger second, UnsignedInteger... rest) {
      List<Object> values = new ArrayList<>(2 + rest.length);
      values.add(Support.writable(serialization.derEncoder, first));
      values.add(Support.writable(serialization.derEncoder, second));
      for (UnsignedInteger value : rest) {
        values.add(Support.writable(serialization.derEncoder, value));
      }
      return new Criteria(serialization, constraint.in(serialization.derName, false, values));
    }

    public Criteria derNotIn(Iterable<UnsignedInteger> values) {
      List<Object> wrappedValues = new ArrayList<>();
      for (UnsignedInteger value : values) {
        wrappedValues.add(Support.writable(serialization.derEncoder, value));
      }
      return new Criteria(serialization, constraint.in(serialization.derName, true, wrappedValues));
    }

    public Criteria derNotIn(UnsignedInteger first, UnsignedInteger second, UnsignedInteger... rest) {
      List<Object> values = new ArrayList<>(2 + rest.length);
      values.add(Support.writable(serialization.derEncoder, first));
      values.add(Support.writable(serialization.derEncoder, second));
      for (UnsignedInteger value : rest) {
        values.add(Support.writable(serialization.derEncoder, value));
      }
      return new Criteria(serialization, constraint.in(serialization.derName, true, values));
    }

    public Criteria derGreaterThan(UnsignedInteger lower) {
      return derIn(Range.greaterThan(lower));
    }

    public Criteria derLessThan(UnsignedInteger upper) {
      return derIn(Range.lessThan(upper));
    }

    public Criteria derAtMost(UnsignedInteger upperInclusive) {
      return derIn(Range.atMost(upperInclusive));
    }

    public Criteria derAtLeast(UnsignedInteger lowerInclusive) {
      return derIn(Range.atLeast(lowerInclusive));
    }

    public Criteria derIn(Range<UnsignedInteger> range) {
      return new Criteria(serialization, constraint.range(serialization.derName, false, Support.writable(serialization.derEncoder, range)));
    }

    public Criteria derNotIn(Range<UnsignedInteger> range) {
      return new Criteria(serialization, constraint.range(serialization.derName, true, Support.writable(serialization.derEncoder, range)));
    }

    @Override
    public Criteria or() {
      return new Criteria(serialization, constraint.disjunction());
    }

    public Criteria with(Criteria criteria) {
      return new Criteria(serialization, criteria.constraint.accept(constraint));
    }

    @Override
    public String toString() {
      return "SillyEntityRepository.criteria(" + Support.stringify(constraint) + ")";
    }
  }

  @Generated(from = "SillyEntity", generator = "Repositories")
  private static class Serialization {
    final Encoder<java.lang.Integer> payloadSecondaryEncoder;
    final Encoder<java.lang.Integer> intsEncoder;
    final Encoder<UnsignedInteger> derEncoder;
    final CodecRegistry registry;
    final String idName;
    final String valName;
    final String payloadName;
    final String intsName;
    final String derName;

    Serialization(CodecRegistry registry, RepositorySetup.FieldNamingStrategy fieldNamingStrategy) {
      this.registry = registry;
      this.payloadSecondaryEncoder = this.registry.get(java.lang.Integer.class);
      this.intsEncoder = this.registry.get(java.lang.Integer.class);
      this.derEncoder = this.registry.get(UnsignedInteger.class);
      this.idName = "_id";
      this.valName = "v";
      this.payloadName = "p";
      this.intsName = "i";
      this.derName = translateName(fieldNamingStrategy, "der");
    }

    @Generated(from = "SillyEntity", generator = "Repositories")
    static final class SillyEntityNamingFields {
      public int id;
      public java.lang.String val;
      public Map<java.lang.String, java.lang.Integer> payload;
      public List<java.lang.Integer> ints;
      public UnsignedInteger der;
    }

    private static String translateName(RepositorySetup.FieldNamingStrategy fieldNamingStrategy, String fieldName) {
      try {
        return fieldNamingStrategy.translateName(
            SillyEntityNamingFields.class.getField(fieldName));
      } catch (NoSuchFieldException noSuchField) {
        throw new AssertionError(noSuchField);
      }
    }
  }
}
