package org.immutables.fixture.annotation;

import com.google.common.base.MoreObjects;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.errorprone.annotations.Var;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link An}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableAn.builder()}.
 * Use the static factory method to create immutable instances:
 * {@code ImmutableAn.of()}.
 */
@Generated(from = "An", generator = "Immutables")
@SuppressWarnings({"all"})
@ParametersAreNonnullByDefault
@javax.annotation.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
@CheckReturnValue
final class ImmutableAn implements An {
  private static final Be[] DEFAULT_VALUE_BEES;

  static {
    try {
      DEFAULT_VALUE_BEES =
          cast(An.class.getDeclaredMethod("bees").getDefaultValue());
    } catch(Exception e) {
      throw new ExceptionInInitializerError(e);
    }
  }

  @SuppressWarnings("unchecked")
  private static <T> T cast(Object object) {
    return (T) object;
  }
  private final int value;
  private final Be[] bees;

  private ImmutableAn(int value) {
    this.value = value;
    this.bees = DEFAULT_VALUE_BEES;
  }

  private ImmutableAn(ImmutableAn.Builder builder) {
    this.value = builder.value;
    this.bees = builder.bees != null
        ? builder.bees
        : DEFAULT_VALUE_BEES;
  }

  private ImmutableAn(int value, Be[] bees) {
    this.value = value;
    this.bees = bees;
  }

  /** {@inheritDoc} */
  @Override
  public Class<? extends Annotation> annotationType() {
    return An.class;
  }

  /**
   * @return The value of the {@code value} attribute
   */
  @Override
  public int value() {
    return value;
  }

  /**
   * @return A cloned {@code bees} array
   */
  @Override
  public Be[] bees() {
    return bees.clone();
  }

  /**
   * Copy the current immutable object by setting a value for the {@link An#value() value} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for value
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableAn withValue(int value) {
    if (this.value == value) return this;
    return new ImmutableAn(value, this.bees);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link An#bees() bees}.
   * The array is cloned before being saved as attribute values.
   * @param elements The non-null elements for bees
   * @return A modified copy of {@code this} object
   */
  public final ImmutableAn withBees(Be... elements) {
    Be[] newValue = elements.clone();
    return new ImmutableAn(this.value, newValue);
  }

  /**
   * This instance is equal to any implementation of the {@link ImmutableAn} type with equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof An
        && equalTo(0, (An) another);
  }

  private boolean equalTo(int synthetic, An another) {
    return value == another.value()
        && Arrays.equals(bees, another.bees());
  }

  /**
   * Computes a hash code from attributes: {@code value}, {@code bees}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    @Var int h = 0;
    h += 127 * "value".hashCode() ^ value;
    h += 127 * "bees".hashCode() ^ Arrays.hashCode(bees);
    return h;
  }

  /**
   * Prints the immutable value {@code An} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return MoreObjects.toStringHelper("@An")
        .omitNullValues()
        .add("value", value)
        .add("bees", Arrays.toString(bees))
        .toString();
  }

  /**
   * Construct a new immutable {@code An} instance.
   * @param value The value for the {@code value} attribute
   * @return An immutable An instance
   */
  public static ImmutableAn of(int value) {
    return new ImmutableAn(value);
  }

  /**
   * Creates an immutable copy of a {@link An} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable An instance
   */
  public static ImmutableAn copyOf(An instance) {
    if (instance instanceof ImmutableAn) {
      return (ImmutableAn) instance;
    }
    return ImmutableAn.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableAn ImmutableAn}.
   * <pre>
   * ImmutableAn.builder()
   *    .value(int) // required {@link An#value() value}
   *    .bees(org.immutables.fixture.annotation.Be) // optional {@link An#bees() bees}
   *    .build();
   * </pre>
   * @return A new ImmutableAn builder
   */
  public static ImmutableAn.Builder builder() {
    return new ImmutableAn.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableAn ImmutableAn}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "An", generator = "Immutables")
  @NotThreadSafe
  public static final class Builder {
    private static final long INIT_BIT_VALUE = 0x1L;
    private long initBits = 0x1L;

    private int value;
    private @Nullable Be[] bees;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code An} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder from(An instance) {
      Objects.requireNonNull(instance, "instance");
      value(instance.value());
      bees(instance.bees());
      return this;
    }

    /**
     * Initializes the value for the {@link An#value() value} attribute.
     * @param value The value for value 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder value(int value) {
      this.value = value;
      initBits &= ~INIT_BIT_VALUE;
      return this;
    }

    /**
     * Initializes the value for the {@link An#bees() bees} attribute.
     * <p><em>If not set, this attribute will have a default value as defined by {@link An#bees() bees}.</em>
     * @param bees The elements for bees
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder bees(Be... bees) {
      this.bees = bees.clone();
      return this;
    }

    /**
     * Builds a new {@link ImmutableAn ImmutableAn}.
     * @return An immutable instance of An
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableAn build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new ImmutableAn(this);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_VALUE) != 0) attributes.add("value");
      return "Cannot build An, some of required attributes are not set " + attributes;
    }
  }
}
