package org.immutables.fixture.ast;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.errorprone.annotations.Var;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link InstantiationGenerics.StringNode}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableStringNode.builder()}.
 */
@Generated(from = "InstantiationGenerics.StringNode", generator = "Immutables")
@SuppressWarnings({"all"})
@ParametersAreNonnullByDefault
@javax.annotation.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
@CheckReturnValue
public final class ImmutableStringNode implements InstantiationGenerics.StringNode {
  private final ImmutableList<InstantiationGenerics.TreeElement<String>> elements;

  private ImmutableStringNode(
      ImmutableList<InstantiationGenerics.TreeElement<String>> elements) {
    this.elements = elements;
  }

  /**
   * @return The value of the {@code elements} attribute
   */
  @Override
  public ImmutableList<InstantiationGenerics.TreeElement<String>> elements() {
    return elements;
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link InstantiationGenerics.StringNode#elements() elements}.
   * @param elements The elements to set
   * @return A modified copy of {@code this} object
   */
  @SafeVarargs @SuppressWarnings("varargs")
  public final ImmutableStringNode withElements(InstantiationGenerics.TreeElement<String>... elements) {
    ImmutableList<InstantiationGenerics.TreeElement<String>> newValue = ImmutableList.copyOf(elements);
    return new ImmutableStringNode(newValue);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link InstantiationGenerics.StringNode#elements() elements}.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param elements An iterable of elements elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableStringNode withElements(Iterable<? extends InstantiationGenerics.TreeElement<String>> elements) {
    if (this.elements == elements) return this;
    ImmutableList<InstantiationGenerics.TreeElement<String>> newValue = ImmutableList.copyOf(elements);
    return new ImmutableStringNode(newValue);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableStringNode} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableStringNode
        && equalTo(0, (ImmutableStringNode) another);
  }

  private boolean equalTo(int synthetic, ImmutableStringNode another) {
    return elements.equals(another.elements);
  }

  /**
   * Computes a hash code from attributes: {@code elements}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    @Var int h = 5381;
    h += (h << 5) + elements.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code StringNode} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return MoreObjects.toStringHelper("StringNode")
        .omitNullValues()
        .add("elements", elements)
        .toString();
  }

  /**
   * Creates an immutable copy of a {@link InstantiationGenerics.StringNode} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable StringNode instance
   */
  public static ImmutableStringNode copyOf(InstantiationGenerics.StringNode instance) {
    if (instance instanceof ImmutableStringNode) {
      return (ImmutableStringNode) instance;
    }
    return ImmutableStringNode.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableStringNode ImmutableStringNode}.
   * <pre>
   * ImmutableStringNode.builder()
   *    .addElements|addAllElements(org.immutables.fixture.ast.InstantiationGenerics.TreeElement&amp;lt;String&amp;gt;) // {@link InstantiationGenerics.StringNode#elements() elements} elements
   *    .build();
   * </pre>
   * @return A new ImmutableStringNode builder
   */
  public static ImmutableStringNode.Builder builder() {
    return new ImmutableStringNode.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableStringNode ImmutableStringNode}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "InstantiationGenerics.StringNode", generator = "Immutables")
  @NotThreadSafe
  public static final class Builder {
    private ImmutableList.Builder<InstantiationGenerics.TreeElement<String>> elements = ImmutableList.builder();

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code StringNode} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * Collection elements and entries will be added, not replaced.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder from(InstantiationGenerics.StringNode instance) {
      Objects.requireNonNull(instance, "instance");
      addAllElements(instance.elements());
      return this;
    }

    /**
     * Adds one element to {@link InstantiationGenerics.StringNode#elements() elements} list.
     * @param element A elements element
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addElements(InstantiationGenerics.TreeElement<String> element) {
      this.elements.add(element);
      return this;
    }

    /**
     * Adds elements to {@link InstantiationGenerics.StringNode#elements() elements} list.
     * @param elements An array of elements elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @SafeVarargs @SuppressWarnings("varargs")
    public final Builder addElements(InstantiationGenerics.TreeElement<String>... elements) {
      this.elements.add(elements);
      return this;
    }


    /**
     * Sets or replaces all elements for {@link InstantiationGenerics.StringNode#elements() elements} list.
     * @param elements An iterable of elements elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder elements(Iterable<? extends InstantiationGenerics.TreeElement<String>> elements) {
      this.elements = ImmutableList.builder();
      return addAllElements(elements);
    }

    /**
     * Adds elements to {@link InstantiationGenerics.StringNode#elements() elements} list.
     * @param elements An iterable of elements elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addAllElements(Iterable<? extends InstantiationGenerics.TreeElement<String>> elements) {
      this.elements.addAll(elements);
      return this;
    }

    /**
     * Builds a new {@link ImmutableStringNode ImmutableStringNode}.
     * @return An immutable instance of StringNode
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableStringNode build() {
      return new ImmutableStringNode(elements.build());
    }
  }
}
