package org.immutables.fixture.builder.detection;

import com.google.common.base.MoreObjects;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.errorprone.annotations.Var;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.fixture.builder.attribute_builders.ThirdPartyImmutableWithNestedBuilder;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link NoNewTokenAttributeBuilderParent}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableNoNewTokenAttributeBuilderParent.builder()}.
 */
@Generated(from = "NoNewTokenAttributeBuilderParent", generator = "Immutables")
@SuppressWarnings({"all"})
@ParametersAreNonnullByDefault
@javax.annotation.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
@CheckReturnValue
public final class ImmutableNoNewTokenAttributeBuilderParent
    extends NoNewTokenAttributeBuilderParent {
  private final ThirdPartyImmutableWithNestedBuilder thirdParty;

  private ImmutableNoNewTokenAttributeBuilderParent(ThirdPartyImmutableWithNestedBuilder thirdParty) {
    this.thirdParty = thirdParty;
  }

  /**
   * @return The value of the {@code thirdParty} attribute
   */
  @Override
  public ThirdPartyImmutableWithNestedBuilder getThirdParty() {
    return thirdParty;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link NoNewTokenAttributeBuilderParent#getThirdParty() thirdParty} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for thirdParty
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableNoNewTokenAttributeBuilderParent withThirdParty(ThirdPartyImmutableWithNestedBuilder value) {
    if (this.thirdParty == value) return this;
    ThirdPartyImmutableWithNestedBuilder newValue = Objects.requireNonNull(value, "thirdParty");
    return new ImmutableNoNewTokenAttributeBuilderParent(newValue);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableNoNewTokenAttributeBuilderParent} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableNoNewTokenAttributeBuilderParent
        && equalTo(0, (ImmutableNoNewTokenAttributeBuilderParent) another);
  }

  private boolean equalTo(int synthetic, ImmutableNoNewTokenAttributeBuilderParent another) {
    return thirdParty.equals(another.thirdParty);
  }

  /**
   * Computes a hash code from attributes: {@code thirdParty}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    @Var int h = 5381;
    h += (h << 5) + thirdParty.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code NoNewTokenAttributeBuilderParent} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return MoreObjects.toStringHelper("NoNewTokenAttributeBuilderParent")
        .omitNullValues()
        .add("thirdParty", thirdParty)
        .toString();
  }

  /**
   * Creates an immutable copy of a {@link NoNewTokenAttributeBuilderParent} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable NoNewTokenAttributeBuilderParent instance
   */
  public static ImmutableNoNewTokenAttributeBuilderParent copyOf(NoNewTokenAttributeBuilderParent instance) {
    if (instance instanceof ImmutableNoNewTokenAttributeBuilderParent) {
      return (ImmutableNoNewTokenAttributeBuilderParent) instance;
    }
    return ImmutableNoNewTokenAttributeBuilderParent.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableNoNewTokenAttributeBuilderParent ImmutableNoNewTokenAttributeBuilderParent}.
   * <pre>
   * ImmutableNoNewTokenAttributeBuilderParent.builder()
   *    .thirdParty(org.immutables.fixture.builder.attribute_builders.ThirdPartyImmutableWithNestedBuilder) // required {@link NoNewTokenAttributeBuilderParent#getThirdParty() thirdParty}
   *    .build();
   * </pre>
   * @return A new ImmutableNoNewTokenAttributeBuilderParent builder
   */
  public static ImmutableNoNewTokenAttributeBuilderParent.Builder builder() {
    return new ImmutableNoNewTokenAttributeBuilderParent.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableNoNewTokenAttributeBuilderParent ImmutableNoNewTokenAttributeBuilderParent}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "NoNewTokenAttributeBuilderParent", generator = "Immutables")
  @NotThreadSafe
  public static final class Builder {
    private static final long INIT_BIT_THIRD_PARTY = 0x1L;
    private long initBits = 0x1L;

    private @Nullable ThirdPartyImmutableWithNestedBuilder thirdParty;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code org.immutables.fixture.builder.detection.NestedDetection} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder from(NestedDetection instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    /**
     * Fill a builder with attribute values from the provided {@code org.immutables.fixture.builder.detection.NoNewTokenAttributeBuilderParent} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder from(NoNewTokenAttributeBuilderParent instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    private void from(Object object) {
      if (object instanceof NestedDetection) {
        NestedDetection instance = (NestedDetection) object;
        thirdParty(instance.getThirdParty());
      }
    }

    /**
     * Initializes the value for the {@link NoNewTokenAttributeBuilderParent#getThirdParty() thirdParty} attribute.
     * @param thirdParty The value for thirdParty 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder thirdParty(ThirdPartyImmutableWithNestedBuilder thirdParty) {
      this.thirdParty = Objects.requireNonNull(thirdParty, "thirdParty");
      initBits &= ~INIT_BIT_THIRD_PARTY;
      return this;
    }

    /**
     * Builds a new {@link ImmutableNoNewTokenAttributeBuilderParent ImmutableNoNewTokenAttributeBuilderParent}.
     * @return An immutable instance of NoNewTokenAttributeBuilderParent
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableNoNewTokenAttributeBuilderParent build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new ImmutableNoNewTokenAttributeBuilderParent(thirdParty);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_THIRD_PARTY) != 0) attributes.add("thirdParty");
      return "Cannot build NoNewTokenAttributeBuilderParent, some of required attributes are not set " + attributes;
    }



  }



}
